/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MFuneral;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.gui.DiffText;
import eelk.koguja.model.DomFuneral;
import eelk.koguja.model.DomFuneralHistory;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.VEventPreview;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VFuneralPreview
extends VEventPreview<DomFuneral, DomFuneralHistory> {
    private String personCongregation;
    private Text txtSurename;
    private Text txtGivenName;
    private Text txtDateOfBirth;
    private Text txtCongregation;
    private Text txtDateOfDeath;
    private DiffText diffLastName;
    private DiffText diffFirstName;
    private DiffText diffDateOfBirth;

    public VFuneralPreview(Composite parent) {
        super(parent, 0);
    }

    public VFuneralPreview(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected int getEventType() {
        return 2;
    }

    @Override
    protected Composite getSpecificPane(Composite parent, int style) {
        Composite specificPane = new Composite(parent, style);
        specificPane.setLayout((Layout)new FillLayout());
        Group grpIndividual = new Group(specificPane, 0);
        grpIndividual.setText(Resources.getString("VFuneralPreview.grpIndividual"));
        grpIndividual.setLayout((Layout)new GridLayout(2, false));
        Label lblSurename = new Label((Composite)grpIndividual, 0);
        lblSurename.setText(Resources.getString("VFuneralPreview.lblSurename"));
        lblSurename.setLayoutData((Object)new GridData(128));
        this.txtSurename = new Text((Composite)grpIndividual, 2052);
        this.txtSurename.setLayoutData((Object)new GridData(768));
        this.txtSurename.setEditable(false);
        Label lblGivenName = new Label((Composite)grpIndividual, 0);
        lblGivenName.setText(Resources.getString("VFuneralPreview.lblGivenName"));
        lblGivenName.setLayoutData((Object)new GridData(128));
        this.txtGivenName = new Text((Composite)grpIndividual, 2052);
        this.txtGivenName.setLayoutData((Object)new GridData(768));
        this.txtGivenName.setEditable(false);
        Label lblDateOfBirth = new Label((Composite)grpIndividual, 0);
        lblDateOfBirth.setText(Resources.getString("VFuneralPreview.lblDateOfBirth"));
        lblDateOfBirth.setLayoutData((Object)new GridData(128));
        this.txtDateOfBirth = new Text((Composite)grpIndividual, 2052);
        this.txtDateOfBirth.setLayoutData((Object)new GridData(768));
        this.txtDateOfBirth.setEditable(false);
        Label lblDateOfDeath = new Label((Composite)grpIndividual, 0);
        lblDateOfDeath.setText(Resources.getString("VFuneralPreview.lblDateOfDeath"));
        lblDateOfDeath.setLayoutData((Object)new GridData(128));
        this.txtDateOfDeath = new Text((Composite)grpIndividual, 2052);
        this.txtDateOfDeath.setLayoutData((Object)new GridData(768));
        this.txtDateOfDeath.setEditable(false);
        Label lblCongregation = new Label((Composite)grpIndividual, 0);
        lblCongregation.setText(Resources.getString("VFuneralPreview.lblCongregation"));
        lblCongregation.setLayoutData((Object)new GridData(128));
        this.txtCongregation = new Text((Composite)grpIndividual, 2052);
        this.txtCongregation.setLayoutData((Object)new GridData(768));
        this.txtCongregation.setEditable(false);
        return specificPane;
    }

    @Override
    protected void initControls() {
        super.initControls();
        this.diffLastName = new DiffText(this.txtSurename);
        this.diffFirstName = new DiffText(this.txtGivenName);
        this.diffDateOfBirth = new DiffText(this.txtDateOfBirth);
    }

    @Override
    public void loadHistory() {
        if (this.historyID == null) {
            return;
        }
        super.loadHistory();
        String newLastName = Util.d(((DomFuneralHistory)this.historicalObject).getPersonLastName());
        String newFirstName = Util.d(((DomFuneralHistory)this.historicalObject).getPersonFirstName());
        String newDateOfBirth = Util.dateToStr(((DomFuneralHistory)this.historicalObject).getPersonBirthDate());
        this.txtSurename.setText(newLastName);
        this.txtGivenName.setText(newFirstName);
        this.txtDateOfBirth.setText(newDateOfBirth);
    }

    @Override
    protected void setSelectedObject(Integer objectId) throws SQLException, ObjectNotFound {
        this.selectedObject = MFuneral.instance().get(objectId);
    }

    @Override
    protected List<DomFuneralHistory> getHistoryList() throws SQLException, ObjectNotFound {
        List<DomFuneralHistory> list = MFuneral.instance().getFuneralHistory(this.getObjectID());
        list.add(0, new DomFuneralHistory((DomFuneral)this.selectedObject));
        return list;
    }

    @Override
    public void refresh() {
        super.refresh();
        DomFuneral funeral = (DomFuneral)this.selectedObject;
        this.setTitle(Util.d(funeral.getPersonLastName()));
        this.txtSurename.setText(Util.d(funeral.getPersonLastName()));
        this.txtGivenName.setText(Util.d(funeral.getPersonFirstName()));
        this.txtCongregation.setText(this.personCongregation);
        this.txtDateOfBirth.setText(Util.dateToStr(funeral.getPersonBirthDate()));
        this.txtDateOfDeath.setText(Util.dateToStr(funeral.getDeathDate()));
        this.diffLastName.setBaseText(funeral.getPersonLastName());
        this.diffFirstName.setBaseText(funeral.getPersonFirstName());
        this.diffDateOfBirth.setBaseText(Util.dateToStr(funeral.getPersonBirthDate()));
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        super.load(p);
        if (this.selectedObject == null) {
            return;
        }
        Integer personCongId = null;
        if (((DomFuneral)this.selectedObject).getPersonId() != null) {
            personCongId = MPersonSwt.instance().getCongregation(((DomFuneral)this.selectedObject).getPersonId());
        }
        this.personCongregation = personCongId == null ? "" : MCongregation.instance().get(personCongId).getName();
    }
}

