/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MFuneral;
import eelk.koguja.gui.DatePickerCombo;
import eelk.koguja.model.DomFuneral;
import eelk.koguja.model.DomParticipant;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.ISave;
import eelk.koguja.view.VEdit;
import eelk.koguja.view.VEventCommon;
import eelk.koguja.view.VPersonData;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VFuneralEdit
extends VEdit {
    private DomFuneral funeral;
    private boolean askCommentOnSave = true;
    private VEventCommon vwEventCommon;
    private Composite cmpEventFuneral;
    private VPersonData vwBuriedPerson;
    private DatePickerCombo dpcDeathDate;
    private Text txtDeathPlace;
    private Text txtDeathCertNo;
    private Text txtDeathReason;
    private DatePickerCombo dpcCremationTime;
    private DatePickerCombo dpcBurialTime;
    private Text txtGraveLoc;
    private Button chkBurialPermVer;
    private Button chkIsReburial;

    public VFuneralEdit(Composite parent) {
        this(parent, 0);
    }

    public VFuneralEdit(Composite parent, int style) {
        super(parent, style);
    }

    public DomFuneral getFuneral() {
        return this.funeral;
    }

    public void setBuriedPersonId(Integer id) {
        this.vwBuriedPerson.setObjectID(id);
    }

    public boolean askCommentOnSave() {
        return this.askCommentOnSave;
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        p.beginTask(Resources.getMsgString("Load.Loading"), 7);
        this.setMode(this.getObjectID() == null ? ISave.SaveMode.SaveAdd : ISave.SaveMode.SaveUpdate);
        if (this.getObjectID() != null) {
            this.setMode(ISave.SaveMode.SaveUpdate);
            this.vwEventCommon.setMode(ISave.SaveMode.SaveUpdate);
            this.funeral = MFuneral.instance().get(this.getObjectID());
            this.vwEventCommon.setEvent(this.getFuneral());
            this.vwBuriedPerson.setPerson(this.getFuneral().getPersonId(), this.getFuneral().getPersonFirstName(), this.getFuneral().getPersonLastName(), this.getFuneral().getPersonBirthDate(), this.getFuneral().getPersonCode());
            this.vwEventCommon.setParticipants(MFuneral.instance().getParticipants(this.getObjectID()));
        } else {
            this.setMode(ISave.SaveMode.SaveAdd);
            this.vwEventCommon.setMode(ISave.SaveMode.SaveAdd);
            this.vwEventCommon.setParticipants(new ArrayList<DomParticipant>());
            this.funeral = new DomFuneral();
            this.funeral.setDocNr(MFuneral.getNextDocNr(Session.congregation().getId()));
            this.vwEventCommon.setEvent(this.funeral);
        }
        p.worked(1);
        this.vwEventCommon.load(p);
        this.vwBuriedPerson.load(p);
        p.worked(1);
        this.askCommentOnSave = false;
        p.done();
    }

    @Override
    public void refresh() {
        this.vwEventCommon.refresh();
        this.vwBuriedPerson.refresh();
        if (this.getFuneral() == null) {
            return;
        }
        if (this.getFuneral().getDeathDate() != null) {
            this.dpcDeathDate.setDate(this.getFuneral().getDeathDate());
        }
        if (this.getFuneral().getDeathPlace() != null) {
            this.txtDeathPlace.setText(Util.d(this.getFuneral().getDeathPlace()));
        }
        if (this.getFuneral().getDeathCertNo() != null) {
            this.txtDeathCertNo.setText(Util.d(this.getFuneral().getDeathCertNo()));
        }
        if (this.getFuneral().getDeathReason() != null) {
            this.txtDeathReason.setText(Util.d(this.getFuneral().getDeathReason()));
        }
        if (this.getFuneral().getBurialTime() != null) {
            this.dpcBurialTime.setDate(this.getFuneral().getBurialTime());
        }
        if (this.getFuneral().getCremationTime() != null) {
            this.dpcCremationTime.setDate(this.getFuneral().getCremationTime());
        }
        if (this.getFuneral().getGraveLocation() != null) {
            this.txtGraveLoc.setText(Util.d(this.getFuneral().getGraveLocation()));
        }
        if (this.getFuneral().getBurialPermission() != null) {
            this.chkBurialPermVer.setSelection(Util.d(this.getFuneral().getBurialPermission()));
        }
        if (this.getFuneral().isReburial() != null) {
            this.chkIsReburial.setSelection(Util.d(this.getFuneral().isReburial()));
        }
    }

    @Override
    public boolean save(IProgressMonitor p) throws SQLException {
        p.beginTask(Resources.getMsgString("Save.Saving"), 2);
        if (this.getMode().equals((Object)ISave.SaveMode.SaveAdd)) {
            this.setObjectID(MFuneral.instance().create(this.getFuneral()));
        } else if (this.getMode().equals((Object)ISave.SaveMode.SaveUpdate)) {
            MFuneral.instance().modify(this.getFuneral());
        }
        p.worked(1);
        MFuneral.instance().setParticipants(this.getObjectID(), this.vwEventCommon.getParticipants());
        p.worked(2);
        p.done();
        if (this.getObjectID() >= 0) {
            this.setMode(ISave.SaveMode.SaveUpdate);
        }
        return this.getObjectID() >= 0;
    }

    @Override
    public boolean collect() {
        if (this.getFuneral() == null) {
            this.funeral = new DomFuneral();
            this.vwEventCommon.setEvent(this.getFuneral());
        }
        if (!this.vwEventCommon.collect()) {
            return false;
        }
        if (!this.collectBuriedPersonData()) {
            return false;
        }
        if (!this.collectFuneralData()) {
            return false;
        }
        if (this.getMode() == ISave.SaveMode.SaveAdd) {
            boolean baptismPreformed = false;
            try {
                baptismPreformed = MFuneral.getFuneralForPerson(this.funeral.getPersonId()) != null;
            }
            catch (SQLException ex) {
                baptismPreformed = false;
            }
            if (baptismPreformed && !GuiUtil.confirmationDialog(this.getShell(), "Err.VEventCommon.EventExists")) {
                return false;
            }
        }
        this.askCommentOnSave |= this.vwEventCommon.askCommentOnSave();
        if (this.getMode() == ISave.SaveMode.SaveAdd) {
            this.askCommentOnSave = false;
        }
        return true;
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new GridLayout(2, true));
        this.cmpEventFuneral = new Composite((Composite)this, 0);
        this.cmpEventFuneral.setLayoutData((Object)new GridData(1808));
        this.cmpEventFuneral.setLayout((Layout)new GridLayout(1, true));
        this.initBuriedControls();
        this.initFuneralControls();
        this.vwEventCommon = new VEventCommon(this);
        this.vwEventCommon.setLayoutData(new GridData(1808));
        this.vwEventCommon.setEventType(2);
    }

    private void initBuriedControls() {
        Group grpBuriedPerson = new Group(this.cmpEventFuneral, 0);
        grpBuriedPerson.setText(Resources.getString("VFuneralEdit.grpBuriedPerson"));
        grpBuriedPerson.setLayoutData((Object)new GridData(768));
        grpBuriedPerson.setLayout((Layout)new FillLayout());
        GuiUtil.displayAsMandatory((Control)grpBuriedPerson);
        this.vwBuriedPerson = new VPersonData((Composite)grpBuriedPerson, 0);
    }

    private void initFuneralControls() {
        Group grpFuneral = new Group(this.cmpEventFuneral, 0);
        grpFuneral.setText(Resources.getString("VFuneralEdit.grpFuneral"));
        grpFuneral.setLayoutData((Object)new GridData(1808));
        grpFuneral.setLayout((Layout)new GridLayout(2, false));
        Label lblDeathDate = new Label((Composite)grpFuneral, 0);
        lblDeathDate.setText(Resources.getString("VFuneralEdit.lblDeathDate"));
        lblDeathDate.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblDeathDate);
        this.dpcDeathDate = new DatePickerCombo((Composite)grpFuneral, 2048);
        this.dpcDeathDate.setLayoutData(new GridData(32));
        Label lblDeathPlace = new Label((Composite)grpFuneral, 0);
        lblDeathPlace.setText(Resources.getString("VFuneralEdit.lblDeathPlace"));
        lblDeathPlace.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblDeathPlace);
        this.txtDeathPlace = new Text((Composite)grpFuneral, 2048);
        this.txtDeathPlace.setLayoutData((Object)new GridData(768));
        this.txtDeathPlace.setTextLimit(240);
        Label lblDeathCertNo = new Label((Composite)grpFuneral, 0);
        lblDeathCertNo.setText(Resources.getString("VFuneralEdit.lblDeathCertNo"));
        lblDeathCertNo.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblDeathCertNo);
        this.txtDeathCertNo = new Text((Composite)grpFuneral, 2048);
        this.txtDeathCertNo.setLayoutData((Object)new GridData(768));
        this.txtDeathCertNo.setTextLimit(240);
        Label lblDeathReason = new Label((Composite)grpFuneral, 0);
        lblDeathReason.setText(Resources.getString("VFuneralEdit.lblDeathReason"));
        lblDeathReason.setLayoutData((Object)new GridData(128));
        this.txtDeathReason = new Text((Composite)grpFuneral, 2048);
        this.txtDeathReason.setLayoutData((Object)new GridData(768));
        this.txtDeathReason.setTextLimit(240);
        Label lblCremationTime = new Label((Composite)grpFuneral, 0);
        lblCremationTime.setText(Resources.getString("VFuneralEdit.lblCremationTime"));
        lblCremationTime.setLayoutData((Object)new GridData(128));
        this.dpcCremationTime = new DatePickerCombo((Composite)grpFuneral, 2048);
        this.dpcCremationTime.setLayoutData(new GridData(32));
        Label lblBurialTime = new Label((Composite)grpFuneral, 0);
        lblBurialTime.setText(Resources.getString("VFuneralEdit.lblBurialTime"));
        lblBurialTime.setLayoutData((Object)new GridData(128));
        this.dpcBurialTime = new DatePickerCombo((Composite)grpFuneral, 2048);
        this.dpcBurialTime.setLayoutData(new GridData(32));
        Label lblGraveLoc = new Label((Composite)grpFuneral, 0);
        lblGraveLoc.setText(Resources.getString("VFuneralEdit.lblGraveLoc"));
        lblGraveLoc.setLayoutData((Object)new GridData(128));
        this.txtGraveLoc = new Text((Composite)grpFuneral, 2048);
        this.txtGraveLoc.setLayoutData((Object)new GridData(768));
        this.txtGraveLoc.setTextLimit(240);
        new Label((Composite)grpFuneral, 0);
        this.chkBurialPermVer = new Button((Composite)grpFuneral, 32);
        this.chkBurialPermVer.setText(Resources.getString("VFuneralEdit.chkBurialPermVer"));
        this.chkBurialPermVer.setLayoutData((Object)new GridData(768));
        new Label((Composite)grpFuneral, 0);
        this.chkIsReburial = new Button((Composite)grpFuneral, 32);
        this.chkIsReburial.setText(Resources.getString("VFuneralEdit.chkIsReburial"));
        this.chkIsReburial.setLayoutData((Object)new GridData(768));
    }

    private boolean collectBuriedPersonData() {
        if (!this.vwBuriedPerson.collect()) {
            return false;
        }
        if (this.vwBuriedPerson.getObjectID() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VFuneralEdit.BuriedPerson", new Object[0]);
            this.vwBuriedPerson.setFocus();
            return false;
        }
        this.askCommentOnSave |= Util.compare(this.funeral.getPersonId(), this.vwBuriedPerson.getObjectID()) != 0;
        this.getFuneral().setPersonId(this.vwBuriedPerson.getObjectID());
        DomPerson person = this.vwBuriedPerson.getPerson();
        this.funeral.setPersonFirstName(person.getFirstName());
        this.funeral.setPersonLastName(person.getLastName());
        this.funeral.setPersonCode(person.getCode());
        this.funeral.setPersonBirthDate(person.getBirthDate());
        return true;
    }

    private boolean collectFuneralData() {
        Date date = this.vwBuriedPerson.getPerson().getBirthDate();
        this.askCommentOnSave |= Util.compare(this.dpcDeathDate.getSqlDate(), this.getFuneral().getDeathDate()) != 0;
        this.getFuneral().setDeathDate(this.dpcDeathDate.getSqlDate());
        if (this.getFuneral().getDeathDate() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VFuneralEdit.DeathDate", new Object[0]);
            this.dpcDeathDate.setFocus();
            return false;
        }
        if (date != null && this.getFuneral().getDeathDate().compareTo(date) < 0) {
            GuiUtil.informationDialog(this.getShell(), "Err.VFuneralEdit.DeathDate.Birth", new Object[0]);
            this.dpcDeathDate.setFocus();
            return false;
        }
        if (this.getFuneral().getDeathDate().compareTo(Calendar.getInstance().getTime()) > 0) {
            GuiUtil.informationDialog(this.getShell(), "Err.VFuneralEdit.DeathDate.Future", new Object[0]);
            this.dpcDeathDate.setFocus();
            return false;
        }
        String s = Util.c(this.txtDeathPlace.getText());
        this.askCommentOnSave |= Util.compare(s, this.getFuneral().getDeathPlace()) != 0;
        this.getFuneral().setDeathPlace(s);
        if (this.getFuneral().getDeathPlace() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VFuneralEdit.DeathPlace", new Object[0]);
            this.txtDeathPlace.setFocus();
            return false;
        }
        s = Util.c(this.txtDeathCertNo.getText());
        this.askCommentOnSave |= Util.compare(s, this.getFuneral().getDeathCertNo()) != 0;
        this.getFuneral().setDeathCertNo(Util.c(this.txtDeathCertNo.getText()));
        if (this.getFuneral().getDeathCertNo() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VFuneralEdit.DeathCertNo", new Object[0]);
            this.txtDeathCertNo.setFocus();
            return false;
        }
        s = Util.c(this.txtDeathReason.getText());
        this.askCommentOnSave |= Util.compare(s, this.getFuneral().getDeathReason()) != 0;
        this.getFuneral().setDeathReason(Util.c(this.txtDeathReason.getText()));
        Date d = this.dpcBurialTime.getSqlDate();
        this.askCommentOnSave |= Util.compare(d, this.getFuneral().getBurialTime()) != 0;
        this.getFuneral().setBurialTime(this.dpcBurialTime.getSqlDate());
        d = this.dpcCremationTime.getSqlDate();
        this.askCommentOnSave |= Util.compare(d, this.getFuneral().getCremationTime()) != 0;
        this.getFuneral().setCremationTime(this.dpcCremationTime.getSqlDate());
        s = Util.c(this.txtGraveLoc.getText());
        this.askCommentOnSave |= Util.compare(s, this.getFuneral().getGraveLocation()) != 0;
        this.getFuneral().setGraveLocation(Util.c(this.txtGraveLoc.getText()));
        this.askCommentOnSave |= Util.compare(Boolean.valueOf(this.chkBurialPermVer.getSelection()), this.getFuneral().getBurialPermission()) != 0;
        this.getFuneral().setBurialPermission(this.chkBurialPermVer.getSelection());
        this.askCommentOnSave |= Util.compare(Boolean.valueOf(this.chkIsReburial.getSelection()), this.getFuneral().isReburial()) != 0;
        this.getFuneral().setIsReburial(this.chkIsReburial.getSelection());
        return true;
    }
}

