/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.model.DomEventState;
import eelk.koguja.search.EventResult;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.VResult;
import eelk.koguja.viewer.AbstractSorter;
import java.util.Date;
import org.eclipse.swt.widgets.Composite;

public abstract class VEventResult
extends VResult {
    public VEventResult(Composite parent) {
        this(parent, 0);
    }

    public VEventResult(Composite parent, int style) {
        super(parent, style);
    }

    protected abstract int getEventType();

    @Override
    protected String[] getColumns() {
        return new String[]{Resources.getString("VEventResult.colDocNr"), Resources.getString("VEventResult.colState"), Resources.getString("VEventResult.colEventDateTime"), Resources.getString("VEventResult.colName"), Resources.getString("VEventResult.colFirstName"), Resources.getString("VEventResult.colDateOfBirth")};
    }

    @Override
    public String getColumnLabel(Object o, int column) {
        String res = "";
        if (o == null) {
            return res;
        }
        EventResult result = (EventResult)o;
        switch (column) {
            case 0: {
                res = result.docNr;
                break;
            }
            case 1: {
                res = DomEventState.nameOf(this.getEventType(), result.state);
                break;
            }
            case 2: {
                String date = Util.dateToStr(result.date);
                String timeStart = Util.timeToStr(result.start);
                String timeEnd = Util.timeToStr(result.end);
                if (Util.c(date) == null) {
                    res = "";
                    break;
                }
                if (Util.c(timeStart) == null && Util.c(timeEnd) == null) {
                    res = date;
                    break;
                }
                res = date + " " + timeStart + " - " + timeEnd;
                break;
            }
            case 3: {
                res = result.lastName;
                break;
            }
            case 4: {
                res = result.firstName;
                break;
            }
            case 5: {
                res = Util.dateToStr(result.birthdate);
            }
        }
        return res;
    }

    @Override
    protected AbstractSorter getSorter() {
        return new AbstractSorter(){

            @Override
            public Comparable getSortValue(Object o, int column) {
                if (o == null) {
                    return null;
                }
                EventResult eventResult = (EventResult)o;
                switch (column) {
                    case 0: {
                        return eventResult.docNr;
                    }
                    case 1: {
                        return DomEventState.nameOf(VEventResult.this.getEventType(), eventResult.state);
                    }
                    case 2: {
                        Date date = null;
                        if (eventResult.date != null) {
                            date = eventResult.start != null ? new Date(eventResult.date.getTime() + eventResult.start.getTime()) : (eventResult.end != null ? new Date(eventResult.date.getTime() + eventResult.end.getTime()) : new Date(eventResult.date.getTime()));
                        } else if (eventResult.start != null) {
                            date = new Date(eventResult.start.getTime());
                        } else if (eventResult.end != null) {
                            date = new Date(eventResult.end.getTime());
                        }
                        return date;
                    }
                    case 3: {
                        return eventResult.lastName;
                    }
                    case 4: {
                        return eventResult.firstName;
                    }
                    case 5: {
                        return eventResult.birthdate;
                    }
                }
                return null;
            }
        };
    }
}

