/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.gui.DiffText;
import eelk.koguja.model.DomEvent;
import eelk.koguja.model.DomEventState;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.VPreview;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class VEventPreview<D extends DomEvent, DH extends DomEvent>
extends VPreview {
    protected D selectedObject;
    protected DH historicalObject;
    private List<DH> objectHistory;
    private Text txtCongregation;
    private Text txtDocumentNumber;
    private Text txtState;
    private Text txtApplicationDate;
    private Text txtEventDate;
    private Text txtEventBeginTime;
    private Text txtEventEndTime;
    private DiffText diffCongregation;
    private DiffText diffstate;
    private DiffText diffAppDate;
    private DiffText diffEventDate;
    private DiffText diffEventStart;
    private DiffText diffEventEnd;

    public VEventPreview(Composite parent) {
        this(parent, 0);
    }

    public VEventPreview(Composite parent, int style) {
        super(parent, style);
    }

    protected abstract Composite getSpecificPane(Composite var1, int var2);

    protected abstract int getEventType();

    @Override
    protected void initControls() {
        this.setLayout((Layout)new GridLayout(2, false));
        Group grpEvent = new Group((Composite)this, 0);
        grpEvent.setText(Resources.getString("VEventPreview.grpEvent"));
        grpEvent.setLayout((Layout)new GridLayout(4, false));
        grpEvent.setLayoutData((Object)new GridData(784));
        Label lblCongregation = new Label((Composite)grpEvent, 0);
        lblCongregation.setText(Resources.getString("VEventPreview.lblCongregation"));
        lblCongregation.setLayoutData((Object)new GridData(128));
        this.txtCongregation = new Text((Composite)grpEvent, 2052);
        this.txtCongregation.setLayoutData((Object)new GridData(768));
        this.txtCongregation.setEditable(false);
        Label lblDocumentNumber = new Label((Composite)grpEvent, 0);
        lblDocumentNumber.setText(Resources.getString("VEventPreview.lblDocumentNumber"));
        lblDocumentNumber.setLayoutData((Object)new GridData(128));
        this.txtDocumentNumber = new Text((Composite)grpEvent, 2052);
        this.txtDocumentNumber.setLayoutData((Object)new GridData(768));
        this.txtDocumentNumber.setEditable(false);
        Label lblState = new Label((Composite)grpEvent, 0);
        lblState.setText(Resources.getString("VEventPreview.lblState"));
        lblState.setLayoutData((Object)new GridData(128));
        this.txtState = new Text((Composite)grpEvent, 2052);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.txtState.setLayoutData((Object)gridData);
        this.txtState.setEditable(false);
        Label lblApplicationDate = new Label((Composite)grpEvent, 0);
        lblApplicationDate.setText(Resources.getString("VEventPreview.lblApplicationDate"));
        lblApplicationDate.setLayoutData((Object)new GridData(128));
        this.txtApplicationDate = new Text((Composite)grpEvent, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.txtApplicationDate.setLayoutData((Object)gridData);
        this.txtApplicationDate.setEditable(false);
        Label lblEventDate = new Label((Composite)grpEvent, 0);
        lblEventDate.setText(Resources.getString("VEventPreview.lblEventDate"));
        lblEventDate.setLayoutData((Object)new GridData(128));
        this.txtEventDate = new Text((Composite)grpEvent, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.txtEventDate.setLayoutData((Object)gridData);
        this.txtEventDate.setEditable(false);
        Label lblEventTime = new Label((Composite)grpEvent, 0);
        lblEventTime.setText(Resources.getString("VEventPreview.lblEventTime"));
        lblEventTime.setLayoutData((Object)new GridData(128));
        this.txtEventBeginTime = new Text((Composite)grpEvent, 2052);
        this.txtEventBeginTime.setLayoutData((Object)new GridData(768));
        this.txtEventBeginTime.setEditable(false);
        Label lblLine1 = new Label((Composite)grpEvent, 0);
        lblLine1.setText("-");
        lblLine1.setLayoutData((Object)new GridData(64));
        this.txtEventEndTime = new Text((Composite)grpEvent, 2052);
        this.txtEventEndTime.setLayoutData((Object)new GridData(768));
        this.txtEventEndTime.setEditable(false);
        Composite cmpSpecificPane = this.getSpecificPane(this, 0);
        cmpSpecificPane.setLayoutData((Object)new GridData(784));
        this.diffCongregation = new DiffText(this.txtCongregation);
        this.diffstate = new DiffText(this.txtState);
        this.diffAppDate = new DiffText(this.txtApplicationDate);
        this.diffEventDate = new DiffText(this.txtEventDate);
        this.diffEventStart = new DiffText(this.txtEventBeginTime);
        this.diffEventEnd = new DiffText(this.txtEventEndTime);
    }

    @Override
    public List<String> getHistory() {
        ArrayList<String> historyList = new ArrayList<String>();
        if (this.objectHistory != null) {
            for (DomEvent historyElement : this.objectHistory) {
                String s = Util.dateToStr(historyElement.getModified_on()) + " " + historyElement.getModified_by();
                historyList.add(s);
            }
        }
        return historyList;
    }

    @Override
    public void loadHistory() {
        if (this.historyID == null) {
            return;
        }
        this.historicalObject = (DomEvent)this.objectHistory.get(this.historyID);
        String newCongregation = ((DomEvent)this.historicalObject).getCongregationName();
        String newState = DomEventState.nameOf(this.getEventType(), ((DomEvent)this.historicalObject).getState());
        String newAppDate = Util.dateToStr(((DomEvent)this.historicalObject).getApplicationDate());
        String newEventDate = Util.dateToStr(((DomEvent)this.historicalObject).getEventDate()) + (((DomEvent)this.historicalObject).getEventFuzzyDate() != null ? " - " + Util.dateToStr(((DomEvent)this.historicalObject).getEventFuzzyDate()) : "");
        String newEventSatrt = Util.timeToStr(((DomEvent)this.historicalObject).getEventStart());
        String newEvenEnd = Util.timeToStr(((DomEvent)this.historicalObject).getEventEnd());
        this.txtCongregation.setText(newCongregation);
        this.txtState.setText(newState);
        this.txtApplicationDate.setText(newAppDate);
        this.txtEventDate.setText(newEventDate);
        this.txtEventBeginTime.setText(newEventSatrt);
        this.txtEventEndTime.setText(newEvenEnd);
    }

    @Override
    public void refresh() {
        D event = this.selectedObject;
        if (event == null) {
            return;
        }
        this.txtCongregation.setText(((DomEvent)event).getCongregationName());
        this.txtDocumentNumber.setText(((DomEvent)event).getDocNr());
        this.txtState.setText(DomEventState.nameOf(this.getEventType(), ((DomEvent)event).getState()));
        this.txtApplicationDate.setText(Util.dateToStr(((DomEvent)event).getApplicationDate()));
        this.txtEventDate.setText(Util.dateToStr(((DomEvent)event).getEventDate()) + (((DomEvent)event).getEventFuzzyDate() != null ? " - " + Util.dateToStr(((DomEvent)event).getEventFuzzyDate()) : ""));
        this.txtEventBeginTime.setText(Util.timeToStr(((DomEvent)event).getEventStart()));
        this.txtEventEndTime.setText(Util.timeToStr(((DomEvent)event).getEventEnd()));
        this.diffCongregation.setBaseText(((DomEvent)event).getCongregationName());
        this.diffstate.setBaseText(DomEventState.nameOf(this.getEventType(), ((DomEvent)event).getState()));
        this.diffAppDate.setBaseText(Util.dateToStr(((DomEvent)event).getApplicationDate()));
        this.diffEventDate.setBaseText(Util.dateToStr(((DomEvent)event).getEventDate()) + (((DomEvent)event).getEventFuzzyDate() != null ? " - " + Util.dateToStr(((DomEvent)event).getEventFuzzyDate()) : ""));
        this.diffEventStart.setBaseText(Util.timeToStr(((DomEvent)event).getEventStart()));
        this.diffEventEnd.setBaseText(Util.timeToStr(((DomEvent)event).getEventEnd()));
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        if (this.getObjectID() == null) {
            return;
        }
        this.setSelectedObject(this.getObjectID());
        this.objectHistory = this.getHistoryList();
    }

    protected abstract void setSelectedObject(Integer var1) throws SQLException, ObjectNotFound;

    protected abstract List<DH> getHistoryList() throws SQLException, ObjectNotFound;
}

