/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MLocation;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.dao.MRole;
import eelk.koguja.dao.MUserSwt;
import eelk.koguja.events.BusinessObjectManagedEvent;
import eelk.koguja.events.IBusinessObjectManagedListener;
import eelk.koguja.gui.DatePickerCombo;
import eelk.koguja.gui.FuzzyDatePickerCombo;
import eelk.koguja.gui.TableEx;
import eelk.koguja.model.BusinessObject;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomEvent;
import eelk.koguja.model.DomEventState;
import eelk.koguja.model.DomLocation;
import eelk.koguja.model.DomParticipant;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.DomRole;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.seq.SeqSelectOfficiant;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.ISave;
import eelk.koguja.view.VEdit;
import eelk.koguja.view.VPersonData;
import eelk.koguja.viewer.DomComboCellEditor;
import eelk.koguja.viewer.DomComboViewer;
import eelk.koguja.viewer.DomLabelProvider;
import eelk.koguja.viewer.DomTableViewer;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class VEventCommon
extends VEdit
implements SelectionListener,
IBusinessObjectManagedListener<DomPerson>,
ISelectionChangedListener {
    public Text txtNr;
    private DomEvent event;
    private int eventType = -1;
    private boolean askCommentOnSave = true;
    private boolean participantsManaged = false;
    private SeqSelectOfficiant seqSelectOfficiant;
    private DomPerson officiant;
    private List<DomLocation> lstLocation;
    private List<DomCongregation> lstCongregation;
    private Hashtable<Integer, DomPerson> hshPartPersons;
    private List<DomRole> lstPartRoles;
    private List<DomParticipant> lstParticipants;
    private List<DomPerson> lstOfficant;
    private DomComboViewer<DomLocation> vwrLocation;
    private DomComboViewer<DomCongregation> vwrCongregation;
    private DomTableViewer<DomParticipant> vwrParticipants;
    private DomComboViewer<DomPerson> vwrOfficant;
    private DomComboCellEditor<DomRole> vwrPartRoles;
    private Group grpEvent;
    private Button rdbStateRegistered;
    private Button rdbStateReady;
    private Button rdbStateCompleted;
    private Button rdbStateCancelled;
    private DatePickerCombo dpcAppDate;
    private Text txtPassage;
    private FuzzyDatePickerCombo dpcEventDate;
    private Text txtEventStartTime;
    private Text txtEventEndTime;
    private Combo cmbLocation;
    private Button btnSelectOfficiant;
    private Text txtLegimitation;
    private Text txtRemark;
    private Button rdbMyCong;
    private Button rdbDefinedCong;
    private Button rdbOtherCong;
    private Combo cmbDefinedCong;
    private Text txtOtherCong;
    private VPersonData vwParticipant;
    private TableEx tblParticipants;
    private Text txtBook;
    private Text txtPage;

    public VEventCommon(Composite parent) {
        this(parent, 0);
    }

    public VEventCommon(Composite parent, int style) {
        super(parent, style);
    }

    public int getEventType() {
        return this.eventType;
    }

    public void setEventType(int value) {
        if (this.eventType == value) {
            return;
        }
        this.eventType = value;
        switch (this.eventType) {
            case 0: {
                this.grpEvent.setText(Resources.getString("VEventCommon.grpEvent.Baptism"));
                break;
            }
            case 1: {
                this.grpEvent.setText(Resources.getString("VEventCommon.grpEvent.Confirmation"));
                break;
            }
            case 2: {
                this.grpEvent.setText(Resources.getString("VEventCommon.grpEvent.Funeral"));
                break;
            }
            case 3: {
                this.grpEvent.setText(Resources.getString("VEventCommon.grpEvent.Wedding"));
                break;
            }
            default: {
                this.grpEvent.setText(Resources.getString("VEventCommon.grpEvent"));
            }
        }
        this.rdbStateRegistered.setText(DomEventState.nameOf(this.eventType, 0));
        this.rdbStateReady.setText(DomEventState.nameOf(this.eventType, 1));
        this.rdbStateCompleted.setText(DomEventState.nameOf(this.eventType, 2));
        this.rdbStateCancelled.setText(DomEventState.nameOf(this.eventType, 3));
    }

    public List<DomParticipant> getParticipants() {
        return this.lstParticipants;
    }

    public void setParticipants(List<DomParticipant> value) {
        this.lstParticipants = value;
        if (this.lstParticipants != null) {
            if (this.hshPartPersons == null) {
                this.hshPartPersons = new Hashtable();
            } else {
                this.hshPartPersons.clear();
            }
            for (DomParticipant part : this.lstParticipants) {
                this.hshPartPersons.put(part.getPersonId(), part.getPerson());
            }
        }
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        this.lstLocation = MLocation.listCurrentCongLocations();
        p.worked(1);
        this.lstOfficant = MUserSwt.congregationUsers(Session.congregation().getId(), "%", "%");
        p.worked(1);
        this.lstCongregation = MCongregation.listCongregations();
        p.worked(1);
        this.lstPartRoles = MRole.listRoles();
        p.worked(1);
        try {
            this.officiant = this.event != null && this.event.getOffciantId() != null && this.event.getOffciantId() >= 0 ? MPersonSwt.instance().getFromAll(this.event.getOffciantId()) : null;
        }
        catch (ObjectNotFound objectNotFound) {
            // empty catch block
        }
        this.askCommentOnSave = false;
        p.worked(1);
        if (this.getMode() == ISave.SaveMode.SaveAdd) {
            this.event.setCongregationId(Session.congregation().getId());
            this.event.setState(2);
        }
        p.worked(1);
    }

    @Override
    public void refresh() {
        Integer congId;
        this.vwrLocation.setSource(this.lstLocation);
        boolean foundLoc = false;
        for (DomLocation location : this.lstLocation) {
            if (!location.getName().equals(Session.congregation().getLocation())) continue;
            foundLoc = true;
            this.vwrLocation.setSelectedObject(location.getId());
            break;
        }
        if (!foundLoc && Session.congregation().getLocation() != null) {
            this.cmbLocation.add(Session.congregation().getLocation());
            this.cmbLocation.select(this.cmbLocation.indexOf(Session.congregation().getLocation()));
        }
        this.vwrCongregation.setSource(this.lstCongregation);
        this.vwrPartRoles.setSource(this.lstPartRoles);
        this.vwrOfficant.setSource(this.lstOfficant);
        if (this.event == null) {
            return;
        }
        if (this.event.getState() != null) {
            switch (this.event.getState()) {
                case 0: {
                    this.rdbStateRegistered.setSelection(true);
                    break;
                }
                case 1: {
                    this.rdbStateReady.setSelection(true);
                    break;
                }
                case 2: {
                    this.rdbStateCompleted.setSelection(true);
                    break;
                }
                case 3: {
                    this.rdbStateCancelled.setSelection(true);
                }
            }
        }
        if (this.event.getDocNr() != null) {
            this.txtNr.setText(this.event.getDocNr());
        }
        if (this.event.getApplicationDate() != null) {
            this.dpcAppDate.setDate(this.event.getApplicationDate());
        }
        if (this.event.getScripturalPassage() != null) {
            this.txtPassage.setText(Util.d(this.event.getScripturalPassage()));
        }
        if (this.event.getEventDate() != null) {
            this.dpcEventDate.setDate(this.event.getEventDate());
        }
        if (this.event.getEventFuzzyDate() != null) {
            this.dpcEventDate.setFuzzyDate(this.event.getEventFuzzyDate());
        }
        if (this.event.getEventStart() != null) {
            this.txtEventStartTime.setText(Util.timeToStr(this.event.getEventStart()));
        }
        if (this.event.getEventEnd() != null) {
            this.txtEventEndTime.setText(Util.timeToStr(this.event.getEventEnd()));
        }
        if (this.event.getLocationId() != null) {
            this.vwrLocation.setSelectedObject(this.event.getLocationId());
        }
        if (this.event.getLegitimation() != null) {
            this.txtLegimitation.setText(Util.d(this.event.getLegitimation()));
        }
        if (this.event.getComment() != null) {
            this.txtRemark.setText(Util.d(this.event.getComment()));
        }
        this.rdbMyCong.setSelection(false);
        this.rdbDefinedCong.setSelection(false);
        this.rdbOtherCong.setSelection(false);
        DomPerson nullPerson = new DomPerson();
        if (!this.lstOfficant.contains(null)) {
            this.lstOfficant.add(0, nullPerson);
            this.vwrOfficant.setSource(this.lstOfficant);
        }
        if (this.officiant != null) {
            if (!this.lstOfficant.contains(this.officiant)) {
                this.lstOfficant.add(this.officiant);
                this.vwrOfficant.setSource(this.lstOfficant);
            }
            this.vwrOfficant.setSelectedObject(this.officiant.getId());
        }
        if ((congId = this.event.getCongregationId()) == null) {
            this.rdbOtherCong.setSelection(true);
            this.txtOtherCong.setText(Util.d(this.event.getCongregationName()));
        } else if (Session.congregation().getId() != congId.intValue()) {
            this.rdbDefinedCong.setSelection(true);
            this.vwrCongregation.setSelectedObject(congId);
        } else {
            this.rdbMyCong.setSelection(true);
        }
        this.cmbDefinedCong.setEnabled(this.rdbDefinedCong.getSelection());
        this.txtOtherCong.setEnabled(this.rdbOtherCong.getSelection());
        this.vwrParticipants.setSource(this.lstParticipants);
        if (this.event.getBook() != null) {
            this.txtBook.setText(Util.d(this.event.getBook()));
        }
        if (this.event.getPage() != null) {
            this.txtPage.setText(Util.d(this.event.getPage()));
        }
        this.dpcAppDate.setFocus();
    }

    @Override
    public boolean save(IProgressMonitor p) throws SQLException {
        return false;
    }

    @Override
    public boolean collect() {
        if (this.event == null) {
            return false;
        }
        if (!this.collectEventData()) {
            return false;
        }
        if (!this.collectCongregationData()) {
            return false;
        }
        return this.collectBookData();
    }

    @Override
    public void businessObjectManaged(BusinessObjectManagedEvent<DomPerson> e) {
        if (this.vwParticipant == e.getSource()) {
            this.manageParticipants(e);
        }
    }

    @Override
    public void selectionChanged(SelectionChangedEvent e) {
        if (this.vwrParticipants.getViewer() == e.getSource() && this.vwrParticipants.getSelectedObject() != null) {
            this.vwParticipant.setPerson(this.hshPartPersons.get(((DomParticipant)this.vwrParticipants.getSelectedObject()).getPersonId()));
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.rdbDefinedCong == e.getSource()) {
            this.cmbDefinedCong.setEnabled(this.rdbDefinedCong.getSelection());
        } else if (this.rdbOtherCong == e.getSource()) {
            this.txtOtherCong.setEnabled(this.rdbOtherCong.getSelection());
        } else if (this.btnSelectOfficiant == e.getSource()) {
            this.selectOfficiant();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected boolean askCommentOnSave() {
        return this.askCommentOnSave || this.participantsManaged;
    }

    protected void manageParticipants(BusinessObjectManagedEvent<DomPerson> e) {
        DomPerson person = e.getBusinessObject();
        if (person == null) {
            return;
        }
        this.participantsManaged = true;
        boolean setSource = false;
        DomParticipant part = new DomParticipant();
        part.setId(-person.getId());
        part.setPersonId(person.getId());
        part.getPerson().setFirstName(person.getFirstName());
        part.getPerson().setLastName(person.getLastName());
        part.getPerson().setDeathDate(person.getDeathDate());
        switch (e.getEventType()) {
            case 1: {
                if (this.hshPartPersons.get(part.getPersonId()) != null) break;
                setSource = this.lstParticipants.add(part);
                this.hshPartPersons.put(part.getPersonId(), part.getPerson());
                break;
            }
            case 2: {
                setSource = this.lstParticipants.remove(part);
                this.hshPartPersons.remove(part.getPersonId());
                part = null;
            }
        }
        if (setSource) {
            this.vwrParticipants.setSource(this.lstParticipants);
        }
        if (part != null) {
            this.vwrParticipants.setSelectedObject(part.getId());
        }
        if (this.vwrParticipants.getSelectedObject() != null) {
            this.vwParticipant.setPerson(this.hshPartPersons.get(((DomParticipant)this.vwrParticipants.getSelectedObject()).getPersonId()));
        }
    }

    private boolean collectEventData() {
        Time time;
        if (this.rdbStateRegistered.getSelection()) {
            this.event.setState(0);
        } else if (this.rdbStateReady.getSelection()) {
            this.event.setState(1);
        } else if (this.rdbStateCompleted.getSelection()) {
            this.event.setState(2);
        } else if (this.rdbStateCancelled.getSelection()) {
            this.event.setState(3);
        } else {
            GuiUtil.informationDialog(this.getShell(), "Err.VEventCommon.State", new Object[0]);
            this.rdbStateRegistered.setFocus();
            this.rdbStateRegistered.setSelection(false);
            return false;
        }
        Date date = this.dpcAppDate.getSqlDate();
        this.askCommentOnSave |= Util.compare(this.event.getApplicationDate(), date) != 0;
        this.event.setApplicationDate(this.dpcAppDate.getSqlDate());
        if (this.event.getApplicationDate() == null && this.dpcAppDate.getDate() != null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VEventCommon.ApplicationDate", new Object[0]);
            this.dpcAppDate.setFocus();
            return false;
        }
        String s = Util.c(this.txtLegimitation.getText());
        this.askCommentOnSave |= Util.compare(s, this.event.getLegitimation()) != 0;
        this.event.setLegitimation(s);
        date = this.dpcEventDate.getSqlDate();
        this.askCommentOnSave |= Util.compare(date, this.event.getEventDate()) != 0;
        this.event.setEventDate(date);
        if (this.event.getEventDate() == null && this.dpcEventDate.getDate() != null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VEventCommon.EventDate", new Object[0]);
            this.dpcEventDate.setFocus();
            return false;
        }
        if (this.event.getEventDate() != null) {
            date = this.dpcEventDate.getSqlFuzzyDate();
            this.askCommentOnSave |= Util.compare(date, this.event.getEventFuzzyDate()) != 0;
            this.event.setEventFuzzyDate(date);
        }
        this.askCommentOnSave |= Util.compare(time = Util.strToSqlTime(this.txtEventStartTime.getText()), this.event.getEventStart()) != 0;
        this.event.setEventStart(time);
        if (this.event.getEventStart() == null && Util.c(this.txtEventStartTime.getText()) != null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VEventCommon.EventStart", new Object[0]);
            this.txtEventStartTime.setFocus();
            return false;
        }
        time = Util.strToSqlTime(this.txtEventEndTime.getText());
        this.askCommentOnSave |= Util.compare(time, this.event.getEventEnd()) != 0;
        this.event.setEventEnd(time);
        if (this.event.getEventEnd() == null && Util.c(this.txtEventEndTime.getText()) != null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VEventCommon.EventEnd", new Object[0]);
            this.txtEventEndTime.setFocus();
            return false;
        }
        if (this.event.getEventStart() != null && this.event.getEventEnd() != null && this.event.getEventStart().compareTo(this.event.getEventEnd()) > 0) {
            GuiUtil.informationDialog(this.getShell(), "Err.VEventCommon.EventStart.BeforeEnd", new Object[0]);
            this.txtEventEndTime.setFocus();
            return false;
        }
        Integer id = this.vwrLocation.getSelectedObject() != null ? Integer.valueOf(this.vwrLocation.getSelectedObjectID()) : null;
        this.event.location = this.cmbLocation.getText();
        int s_id = -1;
        for (int i = 0; i < this.vwrLocation.getSource().size(); ++i) {
            if (((DomLocation)this.vwrLocation.getSource().get(i)).getName().compareTo(this.event.location) != 0) continue;
            s_id = i;
            break;
        }
        if (s_id != -1 && id == null) {
            id = ((DomLocation)this.vwrLocation.getSource().get(s_id)).getId();
        }
        this.askCommentOnSave |= Util.compare(id, this.event.getLocationId()) != 0;
        this.event.setLocationId(id);
        Integer n = id = this.vwrOfficant.getSelectedObject() != null ? Integer.valueOf(this.vwrOfficant.getSelectedObjectID()) : null;
        if (id != null && id < 0) {
            id = null;
        }
        this.askCommentOnSave |= Util.compare(id, this.event.getOffciantId()) != 0;
        this.event.setOffciantId(id);
        s = Util.c(this.txtPassage.getText());
        this.askCommentOnSave |= Util.compare(s, this.event.getScripturalPassage()) != 0;
        this.event.setScripturalPassage(Util.c(s));
        s = Util.c(this.txtRemark.getText());
        this.askCommentOnSave |= Util.compare(s, this.event.getComment()) != 0;
        this.event.setComment(s);
        return true;
    }

    private boolean collectCongregationData() {
        String s = null;
        if (this.rdbMyCong.getSelection()) {
            Integer cid = this.event.getCongregationId();
            this.event.setCongregationId(Session.current().getCongregation().getId());
            this.askCommentOnSave |= Util.compare(cid, this.event.getCongregationId()) != 0;
            s = Session.current().getCongregation().getName();
        } else if (this.rdbDefinedCong.getSelection()) {
            if (this.vwrCongregation.getSelectedObject() == null) {
                GuiUtil.informationDialog(this.getShell(), "Err.VEventCommon.Congregation", new Object[0]);
                this.cmbDefinedCong.setFocus();
                return false;
            }
            Integer cid = this.event.getCongregationId();
            this.event.setCongregationId(this.vwrCongregation.getSelectedObjectID());
            this.askCommentOnSave |= Util.compare(cid, this.event.getCongregationId()) != 0;
            s = ((DomCongregation)this.vwrCongregation.getSelectedObject()).getName();
        } else if (this.rdbOtherCong.getSelection()) {
            s = Util.c(this.txtOtherCong.getText());
            if (s == null) {
                GuiUtil.informationDialog(this.getShell(), "Err.VEventCommon.CongregationName", new Object[0]);
                this.txtOtherCong.setFocus();
                return false;
            }
            this.event.setCongregationId(null);
            this.event.setCongregationName(s);
            this.askCommentOnSave |= Util.compare(s, this.event.getCongregationName()) != 0;
        } else {
            this.rdbMyCong.setFocus();
            return false;
        }
        this.event.setCongregationName(s);
        return true;
    }

    private boolean collectBookData() {
        String s = Util.c(this.txtBook.getText());
        this.askCommentOnSave |= Util.compare(s, this.event.getBook()) != 0;
        this.event.setBook(s);
        s = Util.c(this.txtPage.getText());
        this.askCommentOnSave |= Util.compare(s, this.event.getPage()) != 0;
        this.event.setPage(s);
        return true;
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new GridLayout(1, true));
        this.initEventControls();
        this.initCongControls();
        this.initPartControls();
        this.initBookControls();
    }

    private void initEventControls() {
        this.grpEvent = new Group((Composite)this, 0);
        this.grpEvent.setText(Resources.getString("VEventCommon.grpEvent"));
        this.grpEvent.setLayoutData((Object)new GridData(1808));
        this.grpEvent.setLayout((Layout)new GridLayout(2, false));
        Label lblNr = new Label((Composite)this.grpEvent, 0);
        lblNr.setText(Resources.getString("VDonationEdit.lblDocNr"));
        lblNr.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblNr);
        this.txtNr = new Text((Composite)this.grpEvent, 2056);
        this.txtNr.setLayoutData((Object)new GridData(768));
        this.txtNr.setTextLimit(240);
        Label lblEventDate = new Label((Composite)this.grpEvent, 0);
        lblEventDate.setText(Resources.getString("VEventCommon.lblEventDate"));
        lblEventDate.setLayoutData((Object)new GridData(128));
        this.dpcEventDate = new FuzzyDatePickerCombo((Composite)this.grpEvent, 2048);
        this.dpcEventDate.setLayoutData(new GridData(768));
        Label lblEventTime = new Label((Composite)this.grpEvent, 0);
        lblEventTime.setText(Resources.getString("VEventCommon.lblEventTime"));
        lblEventTime.setLayoutData((Object)new GridData(128));
        Composite cmpEventTime = new Composite((Composite)this.grpEvent, 0);
        cmpEventTime.setLayoutData((Object)new GridData(768));
        cmpEventTime.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        this.txtEventStartTime = new Text(cmpEventTime, 2048);
        this.txtEventStartTime.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.txtEventStartTime, 4);
        Label lblEventTimeTo = new Label(cmpEventTime, 0);
        lblEventTimeTo.setText("-");
        lblEventTimeTo.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment((Control)lblEventTimeTo, 4);
        this.txtEventEndTime = new Text(cmpEventTime, 2048);
        this.txtEventEndTime.setLayoutData((Object)formData);
        Label lblLocation = new Label((Composite)this.grpEvent, 0);
        lblLocation.setText(Resources.getString("VEventCommon.lblLocation"));
        lblLocation.setLayoutData((Object)new GridData(128));
        this.cmbLocation = new Combo((Composite)this.grpEvent, 2048);
        this.cmbLocation.setLayoutData((Object)new GridData(768));
        this.vwrLocation = new DomComboViewer(this.cmbLocation);
        Label lblOfficiant = new Label((Composite)this.grpEvent, 0);
        lblOfficiant.setText(Resources.getString("VEventCommon.lblOfficiant"));
        lblOfficiant.setLayoutData((Object)new GridData(128));
        Composite cmpOfficiant = new Composite((Composite)this.grpEvent, 0);
        cmpOfficiant.setLayoutData((Object)new GridData(768));
        cmpOfficiant.setLayout((Layout)new FormLayout());
        Combo cmbOfficiant = new Combo(cmpOfficiant, 2056);
        this.vwrOfficant = new DomComboViewer(cmbOfficiant);
        this.btnSelectOfficiant = new Button(cmpOfficiant, 8);
        this.btnSelectOfficiant.setText(Resources.getGenString("SelectF"));
        this.btnSelectOfficiant.addSelectionListener((SelectionListener)this);
        formData = new FormData();
        formData.right = new FormAttachment(100, 0);
        this.btnSelectOfficiant.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 2);
        formData.right = new FormAttachment((Control)this.btnSelectOfficiant, -4);
        cmbOfficiant.setLayoutData((Object)formData);
        Label lblPassage = new Label((Composite)this.grpEvent, 0);
        lblPassage.setText(Resources.getString("VEventCommon.lblPassage"));
        lblPassage.setLayoutData((Object)new GridData(128));
        this.txtPassage = new Text((Composite)this.grpEvent, 2048);
        this.txtPassage.setLayoutData((Object)new GridData(768));
        this.txtPassage.setTextLimit(240);
        Label lblRemark = new Label((Composite)this.grpEvent, 0);
        lblRemark.setText(Resources.getString("VEventCommon.lblRemark"));
        lblRemark.setLayoutData((Object)new GridData(130));
        this.txtRemark = new Text((Composite)this.grpEvent, 2050);
        this.txtRemark.setLayoutData((Object)new GridData(1808));
        this.txtRemark.setTextLimit(240);
        Label lblAppDate = new Label((Composite)this.grpEvent, 0);
        lblAppDate.setText(Resources.getString("VEventCommon.lblAppDate"));
        lblAppDate.setLayoutData((Object)new GridData(128));
        this.dpcAppDate = new DatePickerCombo((Composite)this.grpEvent, 2048);
        this.dpcAppDate.setLayoutData(new GridData(768));
        Label lblLegimitation = new Label((Composite)this.grpEvent, 0);
        lblLegimitation.setText(Resources.getString("VEventCommon.lblLegimitation"));
        lblLegimitation.setLayoutData((Object)new GridData(128));
        this.txtLegimitation = new Text((Composite)this.grpEvent, 2048);
        this.txtLegimitation.setLayoutData((Object)new GridData(768));
        this.txtLegimitation.setTextLimit(240);
        this.initStateControls();
    }

    private void initStateControls() {
        Label lblState = new Label((Composite)this.grpEvent, 0);
        lblState.setText(Resources.getString("VEventCommon.lblState"));
        lblState.setLayoutData((Object)new GridData(130));
        GuiUtil.displayAsMandatory((Control)lblState);
        Composite cmpState = new Composite((Composite)this.grpEvent, 0);
        cmpState.setLayout((Layout)new GridLayout(2, false));
        cmpState.setLayoutData((Object)new GridData(34));
        this.rdbStateRegistered = new Button(cmpState, 16);
        this.rdbStateRegistered.setText(DomEventState.nameOf(0));
        this.rdbStateRegistered.setLayoutData((Object)new GridData(32));
        new Label(cmpState, 0);
        this.rdbStateReady = new Button(cmpState, 16);
        this.rdbStateReady.setText(DomEventState.nameOf(1));
        this.rdbStateReady.setLayoutData((Object)new GridData(32));
        new Label(cmpState, 0);
        this.rdbStateCompleted = new Button(cmpState, 16);
        this.rdbStateCompleted.setText(DomEventState.nameOf(2));
        this.rdbStateCompleted.setLayoutData((Object)new GridData(32));
        this.rdbStateCancelled = new Button(cmpState, 16);
        this.rdbStateCancelled.setText(DomEventState.nameOf(3));
        this.rdbStateCancelled.setLayoutData((Object)new GridData(32));
    }

    private void initCongControls() {
        Group grpCongregation = new Group((Composite)this, 0);
        grpCongregation.setText(Resources.getString("VEventCommon.grpCongregation"));
        grpCongregation.setLayoutData((Object)new GridData(768));
        grpCongregation.setLayout((Layout)new GridLayout(3, true));
        GuiUtil.displayAsMandatory((Control)grpCongregation);
        this.rdbMyCong = new Button((Composite)grpCongregation, 16);
        this.rdbMyCong.setText(Resources.getString("VEventCommon.rdbMyCong"));
        this.rdbMyCong.setLayoutData((Object)new GridData(768));
        this.rdbMyCong.setSelection(true);
        this.rdbDefinedCong = new Button((Composite)grpCongregation, 16);
        this.rdbDefinedCong.setText(Resources.getString("VEventCommon.rdbDefinedCong"));
        this.rdbDefinedCong.setLayoutData((Object)new GridData(768));
        this.rdbDefinedCong.addSelectionListener((SelectionListener)this);
        this.rdbOtherCong = new Button((Composite)grpCongregation, 16);
        this.rdbOtherCong.setText(Resources.getString("VEventCommon.rdbOtherCong"));
        this.rdbOtherCong.setLayoutData((Object)new GridData(768));
        this.rdbOtherCong.addSelectionListener((SelectionListener)this);
        new Label((Composite)grpCongregation, 0);
        this.cmbDefinedCong = new Combo((Composite)grpCongregation, 2056);
        this.cmbDefinedCong.setLayoutData((Object)new GridData(768));
        this.cmbDefinedCong.setEnabled(false);
        this.vwrCongregation = new DomComboViewer(this.cmbDefinedCong);
        this.txtOtherCong = new Text((Composite)grpCongregation, 2048);
        this.txtOtherCong.setLayoutData((Object)new GridData(768));
        this.txtOtherCong.setEnabled(false);
        this.txtOtherCong.setTextLimit(240);
    }

    private void initPartControls() {
        Group grpParticipant = new Group((Composite)this, 0);
        grpParticipant.setText(Resources.getString("VEventCommon.grpParticipant"));
        grpParticipant.setLayoutData((Object)new GridData(1808));
        grpParticipant.setLayout((Layout)new GridLayout(1, false));
        this.vwParticipant = new VPersonData((Composite)grpParticipant, false, false, 1);
        this.vwParticipant.setLayoutData(new GridData(768));
        this.vwParticipant.addBusinessObjectListener(this);
        this.tblParticipants = new TableEx((Composite)grpParticipant, 67584);
        this.tblParticipants.setHeaderVisible(true);
        this.tblParticipants.setLayoutData(new GridData(1808));
        this.tblParticipants.setLinesVisible(true);
        TableColumn colPartName = new TableColumn(this.tblParticipants.getTable(), 0);
        colPartName.setText(Resources.getString("VEventCommon.colPartName"));
        TableColumn colPartRole = new TableColumn(this.tblParticipants.getTable(), 0);
        colPartRole.setText(Resources.getString("VEventCommon.colPartRole"));
        this.vwrParticipants = new DomTableViewer(this.tblParticipants.getTable(), this.getParticipantsLabelProvider());
        this.vwrParticipants.packColumns();
        this.vwrParticipants.getViewer().addSelectionChangedListener(this);
        this.vwrPartRoles = new DomComboCellEditor<DomRole>((Composite)this.tblParticipants.getTable()){

            @Override
            protected Object doGetValue() {
                Integer result = (Integer)super.doGetValue();
                ((DomParticipant)VEventCommon.this.vwrParticipants.getSelectedObject()).setRoleId(result);
                return result;
            }

            @Override
            protected void doSetValue(Object value) {
                value = ((DomParticipant)VEventCommon.this.vwrParticipants.getSelectedObject()).getRoleId();
                super.doSetValue(value);
            }
        };
        CellEditor[] partCellEditors = new CellEditor[]{null, this.vwrPartRoles};
        TableViewer vwr = (TableViewer)this.vwrParticipants.getViewer();
        vwr.setColumnProperties(new String[]{"person_id", "role_id"});
        vwr.setCellEditors(partCellEditors);
    }

    private void initBookControls() {
        Group grpBook = new Group((Composite)this, 0);
        grpBook.setText(Resources.getString("VEventCommon.grpBook"));
        grpBook.setLayoutData((Object)new GridData(768));
        grpBook.setLayout((Layout)new GridLayout(4, false));
        Label lblBook = new Label((Composite)grpBook, 0);
        lblBook.setText(Resources.getString("VEventCommon.lblBook"));
        lblBook.setLayoutData((Object)new GridData(128));
        this.txtBook = new Text((Composite)grpBook, 2048);
        this.txtBook.setLayoutData((Object)new GridData(768));
        this.txtBook.setTextLimit(240);
        Label lblPage = new Label((Composite)grpBook, 0);
        lblPage.setText(Resources.getString("VEventCommon.lblPage"));
        lblPage.setLayoutData((Object)new GridData(128));
        this.txtPage = new Text((Composite)grpBook, 2048);
        this.txtPage.setLayoutData((Object)new GridData(768));
        this.txtPage.setTextLimit(240);
    }

    private ITableLabelProvider getParticipantsLabelProvider() {
        return new DomLabelProvider<BusinessObject>(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (element == null) {
                    return "";
                }
                DomParticipant part = (DomParticipant)element;
                switch (columnIndex) {
                    case 0: {
                        return (((DomPerson)VEventCommon.this.hshPartPersons.get(part.getPersonId())).getDeathDate() != null ? "+ " : "") + ((DomPerson)VEventCommon.this.hshPartPersons.get(part.getPersonId())).toString();
                    }
                    case 1: {
                        return VEventCommon.this.vwrPartRoles.getViewer().getTextOf(part.getRoleId());
                    }
                }
                return "";
            }
        };
    }

    private void selectOfficiant() {
        if (this.seqSelectOfficiant == null) {
            this.seqSelectOfficiant = new SeqSelectOfficiant(this.getShell());
        }
        if (Sequence.execSequence(this.seqSelectOfficiant) == Sequence.SeqResult.SeqCompleted) {
            this.officiant = this.seqSelectOfficiant.getPerson();
            if (this.officiant != null) {
                if (!this.lstOfficant.contains(this.officiant)) {
                    this.lstOfficant.add(this.officiant);
                    this.vwrOfficant.setSource(this.lstOfficant);
                }
                this.vwrOfficant.setSelectedObject(this.officiant.getId());
            }
        }
    }

    public void addStateSelectionListener(SelectionListener arg0) {
        if (this.rdbStateRegistered != null) {
            this.rdbStateRegistered.addSelectionListener(arg0);
        }
        if (this.rdbStateReady != null) {
            this.rdbStateReady.addSelectionListener(arg0);
        }
        if (this.rdbStateCompleted != null) {
            this.rdbStateCompleted.addSelectionListener(arg0);
        }
        if (this.rdbStateCancelled != null) {
            this.rdbStateCancelled.addSelectionListener(arg0);
        }
    }

    public DomEvent getEvent() {
        return this.event;
    }

    public void setEvent(DomEvent event) {
        this.event = event;
    }
}

