/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MDonationType;
import eelk.koguja.model.DomDonationType;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.VAttributes;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class VDonationTypes
extends VAttributes<DomDonationType>
implements SelectionListener {
    private static final Logger logger = Logger.getLogger(VDonationTypes.class);
    private List<DomDonationType> donationTypes;
    private Button chkMemberDonation;

    public VDonationTypes(Composite parent) {
        this(parent, 0);
    }

    public VDonationTypes(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initControls() {
    }

    @Override
    protected void initControlsHere() {
        super.initControlsHere();
        FormData formData = new FormData();
        formData.left = new FormAttachment(this.getNameControl(), 0, 16384);
        formData.top = new FormAttachment(this.getNameControl(), 8);
        this.chkMemberDonation = new Button(this.getAttrPanel(), 32);
        this.chkMemberDonation.setText(Resources.getString("VDonationTypes.chkMemberDonation"));
        this.chkMemberDonation.setLayoutData((Object)formData);
        this.chkMemberDonation.moveAbove((Control)super.getButtonsPanel());
        this.setTableHeaderText(Resources.getString("VDonationTypes.tblAttributes.colName"));
        this.setNameLabelText(Resources.getString("VDonationTypes.lblName"));
        this.getVwrAttributes().packColumns();
        this.getBtnAdd().addSelectionListener((SelectionListener)this);
        this.getBtnModify().addSelectionListener((SelectionListener)this);
        this.getBtnDelete().addSelectionListener((SelectionListener)this);
    }

    public boolean getMbsDonationSelection() {
        return this.chkMemberDonation.getSelection();
    }

    public void setMbsDonationSelection(boolean isSelected) {
        this.chkMemberDonation.setSelection(isSelected);
    }

    @Override
    public void selectionChanged(SelectionChangedEvent e) {
        if (e.getSelection().isEmpty()) {
            this.setAttributeText("");
            this.setMbsDonationSelection(false);
        } else {
            this.setAttributeText(this.getSelectedObject().toString());
            this.setMbsDonationSelection(((DomDonationType)this.getSelectedObject()).getIsMbsDonation());
        }
        this.checkButtons();
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.getBtnAdd())) {
            this.createDonationType();
        } else if (e.getSource().equals(this.getBtnModify())) {
            this.modifyDonationType((DomDonationType)this.getSelectedObject(), this.getAttributeText(), this.chkMemberDonation.getSelection());
        } else if (e.getSource().equals(this.getBtnDelete())) {
            this.deleteDonationType((DomDonationType)this.getSelectedObject());
        }
    }

    private int createDonationType() {
        String newDonationTypeName = this.getAttributeText();
        boolean isMbsDonation = this.getMbsDonationSelection();
        final DomDonationType domDonationType = new DomDonationType();
        domDonationType.setName(newDonationTypeName);
        domDonationType.setIsMbsDonation(isMbsDonation);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("CreatingObject"), -1);
                try {
                    MDonationType.instance().create(domDonationType);
                    Session.connection().commit();
                    VDonationTypes.this.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Create"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
        return 0;
    }

    private int modifyDonationType(DomDonationType domDonationType, String newName, boolean newMbsDonation) {
        if (!GuiUtil.confirmationDialog(this.getShell(), "Msg.ConfirmDonationTypeMod", domDonationType.getName(), Resources.getGenString(String.valueOf(domDonationType.getIsMbsDonation()).toLowerCase()), newName, Resources.getGenString(String.valueOf(newMbsDonation).toLowerCase()))) {
            return -1;
        }
        final DomDonationType donationType = domDonationType.clone();
        donationType.setName(newName);
        donationType.setIsMbsDonation(newMbsDonation);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("Save.Saving"), -1);
                try {
                    MDonationType.instance().modify(donationType);
                    Session.connection().commit();
                    VDonationTypes.this.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
        return 0;
    }

    private int deleteDonationType(DomDonationType domDonationType) {
        if (!GuiUtil.confirmationDialog(this.getShell(), "Msg.ConfirmDonationTypeDel", domDonationType.getName())) {
            return -1;
        }
        final DomDonationType donationType = domDonationType;
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("DeletingObject"), -1);
                try {
                    MDonationType.instance().delete(donationType.getId());
                    Session.connection().commit();
                    VDonationTypes.this.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
                catch (ObjectNotFound e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Delete") + "." + Resources.getErrString("ObjectNotFound"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
        return 0;
    }

    public void load(IProgressMonitor p) throws SQLException {
        this.donationTypes = MDonationType.listDonationTypes(false);
    }

    public void refresh() {
        this.setSource(this.donationTypes);
    }
}

