/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.gui.FillDtpc;
import eelk.koguja.gui.FuzzyDatePickerSearch;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomGroup;
import eelk.koguja.search.DonationExpression;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.VAdvancedSearch;
import eelk.koguja.view.VMain;
import eelk.koguja.viewer.DomComboViewer;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VDonationSearchAdvanced
extends VAdvancedSearch<DonationExpression>
implements SelectionListener {
    private Button rdbPerson;
    private Button rdbGroup;
    private Button rdbAnonymus;
    private Text txtSurename;
    private Text txtGivenName;
    private Combo cmbGroup;
    private FuzzyDatePickerSearch dpcDate;
    private Combo cmbCongregation;
    private Text txtAmountFrom;
    private Text txtAmountTo;
    private Button searchHistory;
    private FuzzyDatePickerSearch dpcHistory;
    private DomComboViewer<DomGroup> vwrGroups;

    public VDonationSearchAdvanced(Composite parent) {
        this(parent, 0);
    }

    public VDonationSearchAdvanced(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new GridLayout(2, true));
        Group grpDonator = new Group((Composite)this, 0);
        grpDonator.setText(Resources.getString("VDonationSearchAdvanced.grpDonator"));
        grpDonator.setLayout((Layout)new GridLayout(3, false));
        grpDonator.setLayoutData((Object)new GridData(784));
        Group grpDonation = new Group((Composite)this, 0);
        grpDonation.setText(Resources.getString("VDonationSearchAdvanced.grpDonation"));
        grpDonation.setLayout((Layout)new GridLayout(2, false));
        grpDonation.setLayoutData((Object)new GridData(784));
        this.rdbPerson = new Button((Composite)grpDonator, 16);
        this.rdbPerson.setText(Resources.getString("VDonationSearchAdvanced.rdbPerson"));
        GridData data = new GridData(2);
        this.rdbPerson.setLayoutData((Object)data);
        Label lblSurename = new Label((Composite)grpDonator, 0);
        lblSurename.setText(Resources.getString("VDonationSearchAdvanced.lblSurename"));
        lblSurename.setLayoutData((Object)new GridData(128));
        Composite cmpName = new Composite((Composite)grpDonator, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cmpName.setLayout((Layout)layout);
        cmpName.setLayoutData((Object)new GridData(1808));
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 20;
        this.txtSurename = new Text(cmpName, 2052);
        this.txtSurename.setLayoutData((Object)data);
        Label lblGivenName = new Label(cmpName, 0);
        lblGivenName.setText(Resources.getString("VDonationSearchAdvanced.lblGivenName"));
        lblGivenName.setLayoutData((Object)new GridData(128));
        this.txtGivenName = new Text(cmpName, 2052);
        this.txtGivenName.setLayoutData((Object)data);
        this.rdbGroup = new Button((Composite)grpDonator, 16);
        this.rdbGroup.setText(Resources.getString("VDonationSearchAdvanced.rdbGroup"));
        data = new GridData(2);
        data.horizontalSpan = 2;
        this.rdbGroup.setLayoutData((Object)data);
        this.cmbGroup = new Combo((Composite)grpDonator, 8);
        this.cmbGroup.setLayoutData((Object)new GridData(768));
        this.rdbAnonymus = new Button((Composite)grpDonator, 16);
        this.rdbAnonymus.setText(Resources.getString("VDonationSearchAdvanced.rdbAnonymus"));
        this.rdbAnonymus.setLayoutData((Object)new GridData(2));
        Label lblDate = new Label((Composite)grpDonation, 0);
        lblDate.setText(Resources.getString("VDonationSearchAdvanced.lblDate"));
        lblDate.setLayoutData((Object)new GridData(128));
        this.dpcDate = new FuzzyDatePickerSearch((Composite)grpDonation, 2048);
        GridLayout layout2 = new GridLayout(3, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        this.dpcDate.setLayout((Layout)layout2);
        GridData gData = new GridData(768);
        gData.widthHint = 110;
        this.dpcDate.setLayoutData(gData);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 50;
        Label lblCongregation = new Label((Composite)grpDonation, 0);
        lblCongregation.setText(Resources.getString("VDonationSearchAdvanced.lblCongregation"));
        lblCongregation.setLayoutData((Object)new GridData(128));
        this.cmbCongregation = new Combo((Composite)grpDonation, 8);
        data = new GridData(770);
        data.widthHint = 50;
        this.cmbCongregation.setLayoutData((Object)data);
        Label lblAmount = new Label((Composite)grpDonation, 0);
        lblAmount.setText(Resources.getString("VDonationSearchAdvanced.lblAmount"));
        lblAmount.setLayoutData((Object)new GridData(128));
        Composite cmpAmount = new Composite((Composite)grpDonation, 0);
        GridLayout layout3 = new GridLayout(3, false);
        layout3.marginWidth = 0;
        layout3.marginHeight = 0;
        cmpAmount.setLayout((Layout)layout3);
        cmpAmount.setLayoutData((Object)new GridData(1808));
        this.txtAmountFrom = new Text(cmpAmount, 2052);
        this.txtAmountFrom.setLayoutData((Object)new GridData(768));
        Label lblLine2 = new Label(cmpAmount, 0);
        lblLine2.setText("-");
        this.txtAmountTo = new Text(cmpAmount, 2052);
        this.txtAmountTo.setLayoutData((Object)new GridData(768));
        this.txtAmountFrom.setTextLimit(12);
        this.txtAmountTo.setTextLimit(12);
        this.vwrCongregation = new DomComboViewer(this.cmbCongregation);
        this.vwrGroups = new DomComboViewer(this.cmbGroup);
        new Label((Composite)this, 0);
        Composite cmpHistory = new Composite((Composite)this, 0);
        GridLayout layout4 = new GridLayout(4, false);
        layout4.marginWidth = 0;
        layout4.marginHeight = 0;
        cmpHistory.setLayout((Layout)layout4);
        cmpHistory.setLayoutData((Object)new GridData(1808));
        Label lblSearchHistory = new Label(cmpHistory, 0);
        lblSearchHistory.setText(Resources.getString("VDonationSearchAdvanced.lblSearchHistory"));
        lblSearchHistory.setLayoutData((Object)new GridData(128));
        this.searchHistory = new Button(cmpHistory, 32);
        this.searchHistory.setLayoutData((Object)new GridData());
        Label lblHistoryDate = new Label(cmpHistory, 0);
        lblHistoryDate.setText(Resources.getString("VDonationSearchAdvanced.lblHistory"));
        lblHistoryDate.setLayoutData((Object)new GridData(128));
        this.dpcHistory = new FuzzyDatePickerSearch(cmpHistory, 2048);
        GridLayout layout5 = new GridLayout(3, false);
        layout5.marginWidth = 0;
        layout5.marginHeight = 0;
        this.dpcHistory.setLayout((Layout)layout2);
        GridData gData1 = new GridData(768);
        gData1.widthHint = 110;
        this.dpcHistory.setLayoutData(gData1);
        this.dpcHistory.setEnabled(this.searchHistory.getSelection());
        this.rdbPerson.addSelectionListener((SelectionListener)this);
        this.rdbGroup.addSelectionListener((SelectionListener)this);
        this.rdbAnonymus.addSelectionListener((SelectionListener)this);
        this.searchHistory.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                VDonationSearchAdvanced.this.dpcHistory.setEnabled(VDonationSearchAdvanced.this.searchHistory.getSelection());
            }
        });
        Calendar defaultDate = Calendar.getInstance();
        defaultDate.setTime(new Date());
        defaultDate.set(2, 0);
        defaultDate.set(5, 1);
        new FillDtpc(this.dpcDate, defaultDate.getTime());
        this.rdbPerson.setSelection(true);
        this.checkButtons();
    }

    public void widgetSelected(SelectionEvent e) {
        this.checkButtons();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void checkButtons() {
        if (this.rdbPerson.getSelection()) {
            this.txtGivenName.setEnabled(true);
            this.txtSurename.setEnabled(true);
            this.cmbGroup.setEnabled(false);
            this.vwrGroups.setSelectedObject(null);
        } else if (this.rdbGroup.getSelection()) {
            this.txtGivenName.setEnabled(false);
            this.txtSurename.setEnabled(false);
            this.txtGivenName.setText("");
            this.txtSurename.setText("");
            this.cmbGroup.setEnabled(true);
        } else if (this.rdbAnonymus.getSelection()) {
            this.txtGivenName.setEnabled(false);
            this.txtSurename.setEnabled(false);
            this.cmbGroup.setEnabled(false);
            this.txtGivenName.setText("");
            this.txtSurename.setText("");
            this.vwrGroups.setSelectedObject(null);
        }
    }

    @Override
    public void fillExp(DonationExpression e) {
        if (e == null) {
            return;
        }
        if (this.rdbPerson.getSelection()) {
            e.donationFrom.setValue(0);
            e.lastName.setValue(Util.c(this.txtSurename.getText()));
            e.firstName.setValue(Util.c(this.txtGivenName.getText()));
        } else if (this.rdbGroup.getSelection()) {
            e.donationFrom.setValue(1);
            DomGroup g = (DomGroup)this.vwrGroups.getSelectedObject();
            e.group.setValue(g == null || this.cmbGroup.getSelectionIndex() <= 0 ? null : Integer.valueOf(g.getId()));
        } else if (this.rdbAnonymus.getSelection()) {
            e.donationFrom.setValue(2);
        } else {
            e.donationFrom.setValue(null);
        }
        DomCongregation d = (DomCongregation)this.vwrCongregation.getSelectedObject();
        e.congregation.setValue(d == null || this.vwrCongregation.getSelectedObjectID() == -1 ? null : Integer.valueOf(d.getId()));
        e.dateFrom.setValue(this.dpcDate.getSqlDate());
        e.dateTo.setValue(this.dpcDate.getSqlFuzzyDate());
        e.amountFrom.setValue(Util.strToFloat(this.txtAmountFrom.getText()));
        e.amountTo.setValue(Util.strToFloat(this.txtAmountTo.getText()));
        e.searchHistory.setValue(this.searchHistory.getSelection());
        e.historyFrom.setValue(this.dpcHistory.getSqlDate());
        e.historyTo.setValue(this.dpcHistory.getSqlFuzzyDate());
    }

    @Override
    public void loadExp(DonationExpression e) {
        if (e == null) {
            return;
        }
        if (e.donationFrom.getValue() == null || (Integer)e.donationFrom.getValue() == 0) {
            this.rdbPerson.setSelection(true);
            this.rdbAnonymus.setSelection(false);
            this.rdbGroup.setSelection(false);
            this.txtSurename.setEnabled(true);
            this.txtGivenName.setEnabled(true);
            this.cmbGroup.setEnabled(false);
        } else if ((Integer)e.donationFrom.getValue() == 2) {
            this.rdbAnonymus.setSelection(true);
            this.rdbPerson.setSelection(false);
            this.rdbGroup.setSelection(false);
            this.txtSurename.setEnabled(false);
            this.txtGivenName.setEnabled(false);
            this.cmbGroup.setEnabled(false);
        } else if ((Integer)e.donationFrom.getValue() == 1) {
            this.rdbGroup.setSelection(true);
            this.rdbPerson.setSelection(false);
            this.rdbAnonymus.setSelection(false);
            this.txtSurename.setEnabled(false);
            this.txtGivenName.setEnabled(false);
            this.cmbGroup.setEnabled(true);
        }
        this.txtSurename.setText(Util.d((String)e.lastName.getValue()));
        this.txtGivenName.setText(Util.d((String)e.firstName.getValue()));
        this.vwrGroups.setSelectedObject((Integer)e.group.getValue());
        this.vwrCongregation.setSelectedObject((Integer)e.congregation.getValue());
        this.dpcDate.setDate((Date)e.dateFrom.getValue());
        this.dpcDate.setFuzzyDate((Date)e.dateTo.getValue());
        this.txtAmountFrom.setText(Util.floatToStr((Float)e.amountFrom.getValue()));
        this.txtAmountTo.setText(Util.floatToStr((Float)e.amountTo.getValue()));
        this.searchHistory.setSelection(((Boolean)e.searchHistory.getValue()).booleanValue());
        this.dpcHistory.setDate((Date)e.historyFrom.getValue());
        this.dpcHistory.setFuzzyDate((Date)e.historyTo.getValue());
    }

    @Override
    public DonationExpression createExp() {
        return new DonationExpression();
    }

    public void setGroups(List<DomGroup> groups) {
        this.vwrGroups.setSource(groups);
    }

    @Override
    public VMain.SearchMode getMode() {
        return VMain.SearchMode.DONATION;
    }

    @Override
    protected void fillStandardList() {
    }

    @Override
    public void setDefaults() {
        super.setDefaults();
        this.cmbCongregation.select(this.cmbCongregation.indexOf(Session.congregation().getName()));
    }
}

