/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.search.DonationResult;
import eelk.koguja.util.Currencies;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.VMain;
import eelk.koguja.view.VResult;
import eelk.koguja.viewer.AbstractSorter;
import org.eclipse.swt.widgets.Composite;

public class VDonationResult
extends VResult {
    public VDonationResult(Composite parent) {
        this(parent, 0);
    }

    public VDonationResult(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected String[] getColumns() {
        return new String[]{Resources.getString("VDonationResult.colDocNr"), Resources.getString("VDonationResult.colName"), Resources.getString("VDonationResult.colFirstName"), Resources.getString("VDonationResult.colGroupName"), Resources.getString("VDonationResult.colType"), Resources.getString("VDonationResult.colCongregation"), Resources.getString("VDonationResult.colTotal"), Resources.getString("VDonationResult.colDonationDate")};
    }

    @Override
    public String getColumnLabel(Object o, int column) {
        String res = "";
        if (o == null) {
            return res;
        }
        DonationResult result = (DonationResult)o;
        switch (column) {
            case 0: {
                res = result.docNr;
                break;
            }
            case 1: {
                res = result.lastName;
                break;
            }
            case 2: {
                res = result.firstName;
                break;
            }
            case 3: {
                res = result.group;
                break;
            }
            case 4: {
                res = result.type;
                break;
            }
            case 5: {
                res = result.congregation;
                break;
            }
            case 6: {
                if (result.amount != null) {
                    res = result.amount + " " + Currencies.getCurrencySymbol(result.date);
                    break;
                }
                res = "";
                break;
            }
            case 7: {
                res = Util.dateToStr(result.date);
            }
        }
        return res;
    }

    @Override
    protected AbstractSorter getSorter() {
        return new AbstractSorter(){

            @Override
            public Comparable getSortValue(Object o, int column) {
                if (o == null) {
                    return null;
                }
                DonationResult donationResult = (DonationResult)o;
                switch (column) {
                    case 0: {
                        return donationResult.docNr;
                    }
                    case 1: {
                        return donationResult.lastName;
                    }
                    case 2: {
                        return donationResult.firstName;
                    }
                    case 3: {
                        return donationResult.group;
                    }
                    case 4: {
                        return donationResult.type;
                    }
                    case 5: {
                        return donationResult.congregation;
                    }
                    case 6: {
                        if (Currencies.getCurrencySymbol(donationResult.date).equals("kr")) {
                            return Double.valueOf(Currencies.getEekInEur(donationResult.amount).doubleValue());
                        }
                        return Double.valueOf(donationResult.amount.doubleValue());
                    }
                    case 7: {
                        return donationResult.date;
                    }
                }
                return null;
            }
        };
    }

    @Override
    public VMain.SearchMode getMode() {
        return VMain.SearchMode.DONATION;
    }
}

