/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MDeanery;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomDeanery;
import eelk.koguja.util.IDbUtil;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.ILoad;
import eelk.koguja.view.View;
import eelk.koguja.viewer.DomComboViewer;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VDonationReportSetup
extends View
implements DisposeListener,
ILoad {
    private String reportTitle;
    private Date startDate;
    private Date endDate;
    private int scope = 0;
    private int deaneryID = -1;
    private int congregationID = -1;
    private Text txtTitle;
    private Text txtStartDate;
    private Text txtEndDate;
    private Button btnComplete;
    private Button btnDeanery;
    private Button btnCongregation;
    private Combo cmbDeanery;
    private DomComboViewer<DomDeanery> vwrDeanery;
    private Combo cmbCongregation;
    private DomComboViewer<DomCongregation> vwrCongregation;
    private List<DomDeanery> deaneryList;
    private List<DomCongregation> congregationList;

    public VDonationReportSetup(Composite parent) {
        super(parent);
    }

    public VDonationReportSetup(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initControls() {
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        Group cmpTitle = new Group((Composite)this, 0);
        cmpTitle.setLayoutData((Object)new GridData(768));
        cmpTitle.setLayout((Layout)new GridLayout(2, false));
        Label lblTitle = new Label((Composite)cmpTitle, 0);
        lblTitle.setText(Resources.getString("VDonationReportSetup.lblTitle"));
        lblTitle.setLayoutData((Object)new GridData(128));
        this.txtTitle = new Text((Composite)cmpTitle, 2048);
        this.txtTitle.setLayoutData((Object)new GridData(768));
        this.txtTitle.addDisposeListener((DisposeListener)this);
        Group grpPeriod = new Group((Composite)this, 0);
        grpPeriod.setText(Resources.getString("VDonationReportSetup.grpPeriod"));
        grpPeriod.setLayoutData((Object)new GridData(768));
        grpPeriod.setLayout((Layout)new GridLayout(3, false));
        this.txtStartDate = new Text((Composite)grpPeriod, 2048);
        this.txtStartDate.setTextLimit(10);
        this.txtStartDate.setLayoutData((Object)new GridData(1));
        this.txtStartDate.addDisposeListener((DisposeListener)this);
        Label lblDash = new Label((Composite)grpPeriod, 0);
        lblDash.setText("-");
        lblDash.setLayoutData((Object)new GridData(1));
        this.txtEndDate = new Text((Composite)grpPeriod, 2048);
        this.txtEndDate.setLayoutData((Object)new GridData(1));
        this.txtEndDate.addDisposeListener((DisposeListener)this);
        Group grpBusinessUnit = new Group((Composite)this, 0);
        grpBusinessUnit.setText(Resources.getString("VDonationReportSetup.grpBusinessUnit"));
        grpBusinessUnit.setLayoutData((Object)new GridData(1808));
        grpBusinessUnit.setLayout((Layout)new GridLayout(2, false));
        this.btnComplete = new Button((Composite)grpBusinessUnit, 16);
        this.btnComplete.addDisposeListener((DisposeListener)this);
        this.btnComplete.setText(Resources.getString("VDonationReportSetup.btnComplete"));
        GridData gData = new GridData();
        gData.horizontalSpan = 2;
        this.btnComplete.setLayoutData((Object)gData);
        this.btnDeanery = new Button((Composite)grpBusinessUnit, 16);
        this.btnDeanery.addDisposeListener((DisposeListener)this);
        this.btnDeanery.setText(Resources.getString("VDonationReportSetup.btnDeanery"));
        this.cmbDeanery = new Combo((Composite)grpBusinessUnit, 2048);
        this.cmbDeanery.addDisposeListener((DisposeListener)this);
        this.cmbDeanery.setLayoutData((Object)new GridData(768));
        this.vwrDeanery = new DomComboViewer(this.cmbDeanery);
        this.btnCongregation = new Button((Composite)grpBusinessUnit, 16);
        this.btnCongregation.addDisposeListener((DisposeListener)this);
        this.btnCongregation.setText(Resources.getString("VDonationReportSetup.btnCongregation"));
        this.cmbCongregation = new Combo((Composite)grpBusinessUnit, 2048);
        this.cmbCongregation.addDisposeListener((DisposeListener)this);
        this.cmbCongregation.setLayoutData((Object)new GridData(768));
        this.vwrCongregation = new DomComboViewer(this.cmbCongregation);
        this.btnComplete.setSelection(true);
        this.addDisposeListener(this);
    }

    public void widgetDisposed(DisposeEvent e) {
        Object s = e.getSource();
        if (this.txtTitle == s) {
            this.reportTitle = this.txtTitle.getText();
        } else if (this.btnComplete == s && this.btnComplete.getSelection()) {
            this.scope = 1;
        } else if (this.btnDeanery == s && this.btnDeanery.getSelection()) {
            this.scope = 2;
        } else if (this.btnCongregation == s && this.btnCongregation.getSelection()) {
            this.scope = 3;
        } else if (this.cmbDeanery == s) {
            this.deaneryID = this.vwrDeanery.getSelectedObjectID();
        } else if (this.cmbCongregation == s) {
            this.congregationID = this.vwrCongregation.getSelectedObjectID();
        } else if (this.txtStartDate == s) {
            try {
                this.startDate = new Date(Util.getDateFormat().parse(this.txtStartDate.getText()).getTime());
            }
            catch (Exception ex) {
                this.startDate = null;
            }
        } else if (this.txtEndDate == s) {
            try {
                this.endDate = new Date(Util.getDateFormat().parse(this.txtEndDate.getText()).getTime());
            }
            catch (Exception ex) {
                this.endDate = null;
            }
        }
    }

    public String getReportTitle() {
        return this.txtTitle.isDisposed() ? this.reportTitle : this.txtTitle.getText();
    }

    public void setReportTitle(String title) {
        this.txtTitle.setText(title);
    }

    @Override
    public Integer getObjectID() {
        return null;
    }

    @Override
    public void setObjectID(Integer i) {
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException {
        p.beginTask(Resources.getMsgString("Load.Loading"), 2);
        p.subTask(Resources.getMsgString("LoadingGroupMembership"));
        this.deaneryList = MDeanery.listDeaneries();
        p.worked(1);
        p.subTask(Resources.getMsgString("LoadingRoles"));
        this.congregationList = MCongregation.listMyCongregations(IDbUtil.Permission.Read);
        p.worked(1);
    }

    @Override
    public void refresh() {
        this.vwrDeanery.setSource(this.deaneryList);
        this.vwrCongregation.setSource(this.congregationList);
    }

    public int getScope() {
        if (!this.btnComplete.isDisposed() && this.btnComplete.getSelection()) {
            return 1;
        }
        if (!this.btnDeanery.isDisposed() && this.btnDeanery.getSelection()) {
            return 2;
        }
        if (!this.btnCongregation.isDisposed() && this.btnCongregation.getSelection()) {
            return 3;
        }
        return this.scope;
    }

    public int getCongregationID() {
        if (this.getScope() == 3) {
            if (!this.cmbCongregation.isDisposed()) {
                return this.vwrCongregation.getSelectedObjectID();
            }
            return this.congregationID;
        }
        return -1;
    }

    public int getDeaneryID() {
        if (this.getScope() == 2) {
            if (!this.cmbDeanery.isDisposed()) {
                return this.vwrDeanery.getSelectedObjectID();
            }
            return this.deaneryID;
        }
        return -1;
    }

    public Date getStartDate() {
        if (this.txtStartDate.isDisposed()) {
            return this.startDate;
        }
        try {
            return new Date(Util.getDateFormat().parse(this.txtStartDate.getText()).getTime());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Date getEndDate() {
        if (this.txtEndDate.isDisposed()) {
            return this.endDate;
        }
        try {
            return new Date(Util.getDateFormat().parse(this.txtEndDate.getText()).getTime());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Map<String, Object> getReportParameters() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("TITLE", this.getReportTitle());
        m.put("DateFrom", Util.dateToStr(this.startDate));
        m.put("DateTo", Util.dateToStr(this.endDate));
        return m;
    }

    public Map<String, Object> getReportConstraints() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        int i = -1;
        switch (this.getScope()) {
            case 2: {
                i = this.getDeaneryID();
                m.put("deanery_id", i == -1 ? null : Integer.valueOf(i));
                break;
            }
            case 3: {
                i = this.getCongregationID();
                m.put("congregation_id", i == -1 ? null : Integer.valueOf(i));
            }
        }
        if (this.getStartDate() != null) {
            m.put("start_date", this.getStartDate());
        }
        if (this.getEndDate() != null) {
            m.put("end_date", this.getEndDate());
        }
        return m;
    }
}

