/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MDonation;
import eelk.koguja.gui.DiffText;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomDonation;
import eelk.koguja.model.DomDonationHistory;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.Currencies;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.VPreview;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VDonationPreview
extends VPreview {
    private DomDonation selectedObject;
    private DomCongregation congregation;
    private List<DomDonationHistory> donationHistory;
    private DiffText diffSurename;
    private DiffText diffGivenName;
    private DiffText diffGroup;
    private DiffText diffDate;
    private DiffText diffAmount;
    private Text txtSurename;
    private Text txtGivenName;
    private Text txtGroup;
    private Text txtDate;
    private Text txtCongregation;
    private Text txtAmount;
    private Label lblAmountCurrency;

    public VDonationPreview(Composite parent) {
        this(parent, 0);
    }

    public VDonationPreview(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new GridLayout(2, false));
        Group grpDonator = new Group((Composite)this, 0);
        grpDonator.setText(Resources.getString("VDonationPreview.grpDonator"));
        grpDonator.setLayout((Layout)new GridLayout(2, false));
        grpDonator.setLayoutData((Object)new GridData(784));
        Group grpDonation = new Group((Composite)this, 0);
        grpDonation.setText(Resources.getString("VDonationPreview.grpDonation"));
        grpDonation.setLayout((Layout)new GridLayout(2, false));
        grpDonation.setLayoutData((Object)new GridData(784));
        Label lblSurename = new Label((Composite)grpDonator, 0);
        lblSurename.setText(Resources.getString("VDonationPreview.lblSurename"));
        lblSurename.setLayoutData((Object)new GridData(128));
        this.txtSurename = new Text((Composite)grpDonator, 2052);
        this.txtSurename.setLayoutData((Object)new GridData(768));
        this.txtSurename.setEditable(false);
        Label lblGivenName = new Label((Composite)grpDonator, 0);
        lblGivenName.setText(Resources.getString("VDonationPreview.lblGivenName"));
        lblGivenName.setLayoutData((Object)new GridData(128));
        this.txtGivenName = new Text((Composite)grpDonator, 2052);
        this.txtGivenName.setLayoutData((Object)new GridData(768));
        this.txtGivenName.setEditable(false);
        Label lblGroup = new Label((Composite)grpDonator, 0);
        lblGroup.setText(Resources.getString("VDonationPreview.lblGroup"));
        lblGroup.setLayoutData((Object)new GridData(128));
        this.txtGroup = new Text((Composite)grpDonator, 2052);
        this.txtGroup.setLayoutData((Object)new GridData(768));
        this.txtGroup.setEditable(false);
        Label lblDate = new Label((Composite)grpDonation, 0);
        lblDate.setText(Resources.getString("VDonationPreview.lblDate"));
        lblDate.setLayoutData((Object)new GridData(128));
        this.txtDate = new Text((Composite)grpDonation, 2052);
        this.txtDate.setLayoutData((Object)new GridData(32));
        this.txtDate.setEditable(false);
        Label lblCongregation = new Label((Composite)grpDonation, 0);
        lblCongregation.setText(Resources.getString("VDonationPreview.lblCongregation"));
        lblCongregation.setLayoutData((Object)new GridData(128));
        this.txtCongregation = new Text((Composite)grpDonation, 2052);
        this.txtCongregation.setLayoutData((Object)new GridData(768));
        this.txtCongregation.setEditable(false);
        Label lblAmount = new Label((Composite)grpDonation, 0);
        lblAmount.setText(Resources.getString("VDonationPreview.lblAmount"));
        lblAmount.setLayoutData((Object)new GridData(128));
        Composite cmp = new Composite((Composite)grpDonation, 0);
        cmp.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        cmp.setLayout((Layout)gridLayout);
        this.txtAmount = new Text(cmp, 2052);
        this.txtAmount.setLayoutData((Object)new GridData(32));
        this.txtAmount.setEditable(false);
        this.lblAmountCurrency = new Label(cmp, 0);
        this.lblAmountCurrency.setLayoutData((Object)new GridData(768));
        this.diffSurename = new DiffText(this.txtSurename);
        this.diffGivenName = new DiffText(this.txtGivenName);
        this.diffGroup = new DiffText(this.txtGroup);
        this.diffDate = new DiffText(this.txtDate);
        this.diffAmount = new DiffText(this.txtAmount);
    }

    @Override
    public void loadHistory() {
        if (this.historyID == null) {
            return;
        }
        DomDonationHistory historicalDonation = this.donationHistory.get(this.historyID);
        String newLastName = historicalDonation.getPersonLastName();
        String newFirstName = historicalDonation.getPersonFirstName();
        String newGroupName = historicalDonation.getGroupName();
        String newDonationDate = Util.dateToStr(historicalDonation.getDonationDate());
        String newAmount = Util.bigDecimalToStr(historicalDonation.getAmount());
        this.txtSurename.setText(Util.d(newLastName));
        this.txtGivenName.setText(Util.d(newFirstName));
        this.txtGroup.setText(Util.d(newGroupName));
        this.txtDate.setText(Util.d(newDonationDate));
        this.txtAmount.setText(Util.d(newAmount));
    }

    @Override
    public List<String> getHistory() {
        ArrayList<String> historyList = new ArrayList<String>();
        if (this.donationHistory != null) {
            for (DomDonationHistory historyElement : this.donationHistory) {
                String s = Util.dateToStr(historyElement.getModified_on()) + " " + historyElement.getModified_by();
                historyList.add(s);
            }
        }
        return historyList;
    }

    @Override
    public void refresh() {
        this.donationHistory.add(0, new DomDonationHistory(this.selectedObject));
        switch (this.selectedObject.getDonationFrom()) {
            case 0: {
                String name = Util.c(this.selectedObject.getPersonFirstName());
                if (name == null) {
                    name = Util.c(this.selectedObject.getPersonLastName());
                } else if (Util.c(this.selectedObject.getPersonLastName()) != null) {
                    name = name + " " + this.selectedObject.getPersonLastName();
                }
                this.setTitle(Util.d(name));
                break;
            }
            case 1: {
                this.setTitle(this.selectedObject.getGroupName());
                break;
            }
            case 2: {
                this.setTitle(Resources.getString("VDonationPreview.TitleAnonymous"));
                break;
            }
            default: {
                this.setTitle("");
            }
        }
        this.txtSurename.setText(Util.d(this.selectedObject.getPersonLastName()));
        this.txtGivenName.setText(Util.d(this.selectedObject.getPersonFirstName()));
        this.txtGroup.setText(Util.d(this.selectedObject.getGroupName()));
        this.txtDate.setText(Util.dateToStr(this.selectedObject.getDonationDate()));
        if (this.congregation == null) {
            this.txtCongregation.setText("");
        } else {
            this.txtCongregation.setText(Util.d(this.congregation.getName()));
        }
        this.txtAmount.setText(Util.bigDecimalToStr(this.selectedObject.getAmount()));
        this.lblAmountCurrency.setText(Currencies.getCurrencySymbol(this.selectedObject.getDonationDate()));
        this.diffSurename.setBaseText(this.txtSurename.getText());
        this.diffGivenName.setBaseText(this.txtGivenName.getText());
        this.diffGroup.setBaseText(this.txtGroup.getText());
        this.diffDate.setBaseText(this.txtDate.getText());
        this.diffAmount.setBaseText(this.txtAmount.getText());
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        if (this.getObjectID() == null) {
            return;
        }
        this.selectedObject = MDonation.instance().get(this.getObjectID());
        this.congregation = MCongregation.instance().get(this.selectedObject.getCongregationId());
        this.donationHistory = MDonation.getDonationHistory(this.getObjectID());
    }
}

