/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MDonationUse;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomDonationUse;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.IDbUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.VAttributes;
import eelk.koguja.view.View;
import eelk.koguja.viewer.DomComboViewer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class VDonationIntendedUses
extends View
implements SelectionListener {
    private static final Logger logger = Logger.getLogger(VDonationIntendedUses.class);
    private List<DomCongregation> congregations;
    private List<DomDonationUse> donationUses;
    private DomComboViewer<DomCongregation> vwrCongregation;
    private Combo cmbCongregation;
    private VAttributes<DomDonationUse> vwDonationUses;
    private Group grpDonationUses;

    public VDonationIntendedUses(Composite parent) {
        this(parent, 0);
    }

    public VDonationIntendedUses(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initControls() {
        Composite cmpCongregation = new Composite((Composite)this, 0);
        cmpCongregation.setLayout((Layout)new GridLayout(2, false));
        Label lblCongregation = new Label(cmpCongregation, 0);
        lblCongregation.setText(Resources.getString("VDonationUseAdmin.lblCongregation"));
        lblCongregation.setLayoutData((Object)new GridData(32));
        this.cmbCongregation = new Combo(cmpCongregation, 0x800 | Combo.LIMIT);
        this.cmbCongregation.setLayoutData((Object)new GridData(768));
        this.grpDonationUses = new Group((Composite)this, 0);
        this.grpDonationUses.setLayout((Layout)new FillLayout(256));
        this.grpDonationUses.setText(Resources.getString("VDonationUseAdmin.grpDonationUses"));
        this.vwDonationUses = new VAttributes<DomDonationUse>((Composite)this.grpDonationUses, this.getStyle()){

            @Override
            public boolean isAddEnabled() {
                return super.isAddEnabled() && VDonationIntendedUses.this.vwrCongregation.getSelectedObjectID() >= 0;
            }
        };
        this.vwDonationUses.setTableHeaderText(Resources.getString("VDonationUseAdmin.vwDonationUses.colName"));
        this.vwDonationUses.setNameLabelText(Resources.getString("VDonationUseAdmin.vwDonationUses.lblName"));
        this.vwDonationUses.getVwrAttributes().packColumns();
        if (this.getLayout() == null) {
            this.setLayout((Layout)new FormLayout());
        }
        FormData formData = null;
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(50, 0);
        cmpCongregation.setLayoutData((Object)formData);
        formData = new FormData();
        formData.top = new FormAttachment((Control)cmpCongregation, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        formData.bottom = new FormAttachment(100, -5);
        this.grpDonationUses.setLayoutData((Object)formData);
        this.cmbCongregation.addSelectionListener((SelectionListener)this);
        this.vwrCongregation = new DomComboViewer(this.cmbCongregation);
        this.vwDonationUses.getBtnAdd().addSelectionListener((SelectionListener)this);
        this.vwDonationUses.getBtnModify().addSelectionListener((SelectionListener)this);
        this.vwDonationUses.getBtnDelete().addSelectionListener((SelectionListener)this);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.cmbCongregation)) {
            this.loadDonationUses(this.vwrCongregation.getSelectedObjectID());
            this.vwDonationUses.checkButtons();
        } else if (e.getSource().equals(this.vwDonationUses.getBtnAdd())) {
            this.createDonationUse(this.vwrCongregation.getSelectedObjectID());
        } else if (e.getSource().equals(this.vwDonationUses.getBtnModify())) {
            this.modifyDonationUse((DomDonationUse)this.vwDonationUses.getSelectedObject(), this.vwDonationUses.getAttributeText());
        } else if (e.getSource().equals(this.vwDonationUses.getBtnDelete())) {
            this.deleteDonationUse((DomDonationUse)this.vwDonationUses.getSelectedObject());
        }
    }

    protected int createDonationUse(int congId) {
        String newDonationUseName = this.vwDonationUses.getAttributeText();
        final DomDonationUse domDonationUse = new DomDonationUse();
        domDonationUse.setName(newDonationUseName);
        domDonationUse.setCongregationId(congId);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("CreatingObject"), -1);
                try {
                    MDonationUse.instance().create(domDonationUse);
                    Session.connection().commit();
                    VDonationIntendedUses.this.donationUses = MDonationUse.listDonationUses(domDonationUse.getCongregationId());
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Create"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refreshDonationUses();
        return 0;
    }

    private int modifyDonationUse(DomDonationUse domDonationUse, String newName) {
        if (!GuiUtil.confirmationDialog(this.getShell(), "Msg.ConfirmDonationUseMod", domDonationUse.getName(), newName)) {
            return -1;
        }
        final DomDonationUse donationUse = domDonationUse.clone();
        donationUse.setName(newName);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("Save.Saving"), -1);
                try {
                    MDonationUse.instance().modify(donationUse);
                    Session.connection().commit();
                    VDonationIntendedUses.this.donationUses = MDonationUse.listDonationUses(donationUse.getCongregationId());
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refreshDonationUses();
        return 0;
    }

    private int deleteDonationUse(DomDonationUse domDonationUse) {
        if (!GuiUtil.confirmationDialog(this.getShell(), "Msg.ConfirmDonationUseDel", domDonationUse.getName())) {
            return -1;
        }
        final DomDonationUse donationUse = domDonationUse;
        donationUse.setCongregationId(domDonationUse.getCongregationId());
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("DeletingObject"), -1);
                try {
                    MDonationUse.instance().delete(donationUse.getId());
                    Session.connection().commit();
                    VDonationIntendedUses.this.donationUses = MDonationUse.listDonationUses(donationUse.getCongregationId());
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
                catch (ObjectNotFound e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Delete") + "." + Resources.getErrString("ObjectNotFound"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refreshDonationUses();
        return 0;
    }

    protected void loadDonationUses(int congId) {
        if (congId == -1) {
            this.donationUses = new ArrayList<DomDonationUse>();
        }
        final int id = congId;
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getString("Msg.LoadingDonationUses"), -1);
                try {
                    VDonationIntendedUses.this.donationUses = MDonationUse.listDonationUses(id);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refreshDonationUses();
    }

    public void load(IProgressMonitor p) throws SQLException {
        this.congregations = MCongregation.listMyCongregations(IDbUtil.Permission.Admin);
    }

    public void refresh() {
        this.vwrCongregation.setSource(this.congregations);
        this.vwrCongregation.setSelectedObject(Session.congregation().getId());
        this.loadDonationUses(Session.congregation().getId());
        this.refreshDonationUses();
    }

    public void refreshDonationUses() {
        this.vwDonationUses.setSource(this.donationUses);
    }
}

