/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MDonation;
import eelk.koguja.dao.MDonationType;
import eelk.koguja.dao.MDonationUse;
import eelk.koguja.dao.MGroupSwt;
import eelk.koguja.gui.DatePickerCombo;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomDonation;
import eelk.koguja.model.DomDonationMethod;
import eelk.koguja.model.DomDonationType;
import eelk.koguja.model.DomDonationUse;
import eelk.koguja.model.DomGroup;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.Currencies;
import eelk.koguja.util.DbUtil;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.util.Util;
import eelk.koguja.view.ISave;
import eelk.koguja.view.VEdit;
import eelk.koguja.view.VPersonData;
import eelk.koguja.viewer.DomComboViewer;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VDonationEdit
extends VEdit
implements SelectionListener,
ModifyListener {
    private static final Logger logger = Logger.getLogger(VDonationEdit.class);
    private DomDonation donation;
    private DomDonationType donationType;
    private DomCongregation donationCong;
    private boolean askCommentOnSave = true;
    private int selectedCongregationId;
    private boolean loadIntendedUsesSucceeded;
    private List<DomGroup> lstRegGroups;
    private List<DomDonationType> lstTypes;
    private List<DomDonationUse> lstIntendedUses;
    private final List<DomDonationMethod> lstPaymentMethods = DomDonationMethod.listAll();
    private DomComboViewer<DomGroup> vwrRegGroups;
    private DomComboViewer<DomDonationType> vwrTypes;
    private DomComboViewer<DomDonationUse> vwrIntendedUses;
    private DomComboViewer<DomDonationMethod> vwrPaymentMethods;
    private Composite cmpBody;
    private Button rdbPerson;
    private VPersonData vwPerson;
    private Button rdbGroup;
    private Combo cmbRegGroup;
    private Text txtOtherGroup;
    private Button rdbAnonymous;
    private Text txtDocNr;
    private Combo cmbType;
    private Text txtCongregation;
    private DatePickerCombo dpcDate;
    private Text txtObject;
    private Text txtAmount;
    private Label lblAmountCurrency;
    private Button chkIsApprox;
    private Button chkIsTaxReturned;
    private Combo cmbPaymentMethod;
    private Text txtRemarks;
    private Text txtBook;
    private Text txtPage;

    public VDonationEdit(Composite parent) {
        this(parent, 0);
    }

    public VDonationEdit(Composite parent, int style) {
        super(parent, style);
    }

    public DomDonation getDonation() {
        return this.donation;
    }

    public void setDonatingPersonId(Integer id) {
        this.vwPerson.setObjectID(id);
        this.rdbPerson.setSelection(true);
        this.setDonatorsEnabled(0);
    }

    public DomDonationType getDonationType() {
        return this.donationType;
    }

    public DomCongregation getDonationCong() {
        return this.donationCong;
    }

    public boolean askCommentOnSave() {
        return this.askCommentOnSave;
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        p.beginTask(Resources.getMsgString("Load.Loading"), 6);
        this.setMode(this.getObjectID() == null ? ISave.SaveMode.SaveAdd : ISave.SaveMode.SaveUpdate);
        if (this.getObjectID() != null) {
            this.setMode(ISave.SaveMode.SaveUpdate);
            this.donation = MDonation.instance().get(this.getObjectID());
            this.donation.setDocNr(DbUtil.getNextDocNr(MDonation.getNextDocNr(this.donation.getCongregationId())));
            this.vwPerson.setPerson(this.donation.getPersonId(), this.donation.getPersonFirstName(), this.donation.getPersonLastName(), this.donation.getPersonBirthDate(), this.donation.getPersonCode());
        } else {
            this.setMode(ISave.SaveMode.SaveAdd);
            this.donation = new DomDonation();
            this.donation.setDocNr(MDonation.getNextDocNr(Session.congregation().getId()));
            this.donation.setDonationDate(new Date(new java.util.Date().getTime()));
            this.donation.setCongregationId(Session.congregation().getId());
        }
        p.worked(1);
        this.lstRegGroups = MGroupSwt.listGroups(Session.congregation().getId());
        this.lstRegGroups.add(0, new DomGroup());
        p.worked(1);
        this.lstTypes = MDonationType.listDonationTypes(true);
        p.worked(1);
        if (this.getMode() == ISave.SaveMode.SaveUpdate) {
            this.loadIntendedUses(this.donation.getCongregationId());
        }
        p.worked(1);
        this.donationCong = MCongregation.instance().get(this.donation.getCongregationId());
        p.worked(1);
        this.vwPerson.load(p);
        p.worked(1);
        p.done();
        this.askCommentOnSave = false;
    }

    @Override
    public void refresh() {
        this.vwrRegGroups.setSource(this.lstRegGroups);
        this.vwrTypes.setSource(this.lstTypes);
        this.vwrPaymentMethods.setSource(this.lstPaymentMethods);
        this.txtDocNr.setText(Util.d(this.donation.getDocNr()));
        this.dpcDate.setDate(this.donation.getDonationDate());
        if (this.getMode() == ISave.SaveMode.SaveAdd) {
            if (this.lstTypes.size() > 0 && this.lstTypes.get(0).getIsMbsDonation().booleanValue()) {
                this.vwrTypes.setSelectedObject(this.lstTypes.get(0).getId());
            }
            this.updateIntendedUses();
        } else if (this.donation != null) {
            if (this.donation.getDonationFrom() != null) {
                switch (this.donation.getDonationFrom()) {
                    case 0: {
                        this.rdbPerson.setSelection(true);
                        break;
                    }
                    case 1: {
                        this.rdbGroup.setSelection(true);
                        if (this.donation.getGroupId() != null) {
                            this.vwrRegGroups.setSelectedObject(this.donation.getGroupId());
                            break;
                        }
                        this.txtOtherGroup.setText(Util.d(this.donation.getGroupName()));
                        break;
                    }
                    case 2: {
                        this.rdbAnonymous.setSelection(true);
                    }
                }
                this.setDonatorsEnabled(this.donation.getDonationFrom());
            }
            if (this.donation.getTypeId() != null) {
                this.vwrTypes.setSelectedObject(this.donation.getTypeId());
            }
            if (this.donation.getPaymentMethod() != null) {
                this.vwrPaymentMethods.setSelectedObject(this.donation.getPaymentMethod());
            }
            this.dpcDate.setDate(this.donation.getDonationDate());
            this.txtObject.setText(Util.d(this.donation.getDonationObject()));
            this.txtAmount.setText(Util.d(this.donation.getAmount() == null ? null : this.donation.getAmount().toString()));
            this.chkIsApprox.setSelection(this.donation.isApproxAmount().booleanValue());
            this.chkIsTaxReturned.setSelection(this.donation.isTaxReturned().booleanValue());
            this.txtRemarks.setText(Util.d(this.donation.getComment()));
            this.txtBook.setText(Util.d(this.donation.getBook()));
            this.txtPage.setText(Util.d(this.donation.getPage()));
        }
        this.donationType = (DomDonationType)this.vwrTypes.getSelectedObject();
        this.txtCongregation.setText(Util.d(this.getDonationCong().getName()));
        this.lblAmountCurrency.setText(Currencies.getCurrencySymbol(this.dpcDate.getDate()));
        this.updateTaxReturned();
        this.vwPerson.refresh();
        this.refreshIntendedUses();
    }

    private void loadIntendedUses(int congregationId) throws SQLException {
        if (congregationId == -1) {
            this.lstIntendedUses = null;
        } else {
            this.lstIntendedUses = MDonationUse.listDonationUses(congregationId);
            this.lstIntendedUses.add(0, new DomDonationUse());
        }
    }

    private void refreshIntendedUses() {
        this.vwrIntendedUses.setSource(this.lstIntendedUses);
        if (this.donation != null && this.donation.getIntendedUseId() != null) {
            this.vwrIntendedUses.setSelectedObject(this.donation.getIntendedUseId());
        }
    }

    private void updateIntendedUses() {
        this.selectedCongregationId = this.donation.getCongregationId();
        Operation.run(this.getShell(), true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    VDonationEdit.this.loadIntendedUses(VDonationEdit.this.selectedCongregationId);
                    VDonationEdit.this.loadIntendedUsesSucceeded = true;
                }
                catch (SQLException ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
                    VDonationEdit.this.loadIntendedUsesSucceeded = false;
                }
            }
        });
        if (!this.loadIntendedUsesSucceeded) {
            this.lstIntendedUses.clear();
        }
        this.refreshIntendedUses();
    }

    @Override
    public boolean save(IProgressMonitor p) throws SQLException {
        p.beginTask(Resources.getMsgString("Save.Saving"), 1);
        if (this.getMode().equals((Object)ISave.SaveMode.SaveAdd)) {
            this.setObjectID(MDonation.instance().create(this.donation));
        } else if (this.getMode().equals((Object)ISave.SaveMode.SaveUpdate)) {
            MDonation.instance().modify(this.donation);
        }
        p.worked(1);
        p.done();
        if (this.objectID >= 0) {
            this.setMode(ISave.SaveMode.SaveUpdate);
        }
        return this.objectID >= 0;
    }

    @Override
    public boolean collect() {
        if (this.donation == null) {
            this.donation = new DomDonation();
        }
        if (!this.collectDonatorData()) {
            return false;
        }
        if (!this.collectDonationData()) {
            return false;
        }
        if (this.getMode() == ISave.SaveMode.SaveAdd) {
            this.askCommentOnSave = false;
        }
        return true;
    }

    private boolean collectDonatorData() {
        Integer oldGroupId = this.donation.getGroupId();
        String oldGroupName = this.donation.getGroupName();
        if (this.rdbPerson.getSelection()) {
            if (!this.vwPerson.collect()) {
                return false;
            }
            if (this.vwPerson.getPerson() == null) {
                GuiUtil.informationDialog(this.getShell(), "Err.VDonationEdit.Person", new Object[0]);
                this.vwPerson.setFocus();
                return false;
            }
            this.askCommentOnSave |= Util.compare(this.donation.getPersonId(), this.vwPerson.getObjectID()) != 0;
            this.donation.setPersonId(this.vwPerson.getObjectID());
            DomPerson person = this.vwPerson.getPerson();
            this.donation.setPersonFirstName(person.getFirstName());
            this.donation.setPersonLastName(person.getLastName());
            this.donation.setPersonCode(person.getCode());
            this.donation.setPersonBirthDate(person.getBirthDate());
            this.askCommentOnSave |= Util.compare(this.donation.getDonationFrom(), 0) != 0;
            this.donation.setDonationFrom(0);
        } else if (this.rdbGroup.getSelection()) {
            if (this.vwrRegGroups.getSelectedObject() == null || this.vwrRegGroups.getSelectedObjectID() == -1) {
                this.donation.setGroupName(Util.c(this.txtOtherGroup.getText()));
                if (this.donation.getGroupName() == null) {
                    GuiUtil.informationDialog(this.getShell(), "Err.VDonationEdit.Group", new Object[0]);
                    this.txtOtherGroup.setFocus();
                    return false;
                }
                this.donation.setGroupId(null);
            } else {
                this.donation.setGroupId(this.vwrRegGroups.getSelectedObjectID());
                this.donation.setGroupName(((DomGroup)this.vwrRegGroups.getSelectedObject()).getName());
            }
            this.askCommentOnSave |= Util.compare(this.donation.getDonationFrom(), 1) != 0;
            this.donation.setDonationFrom(1);
        } else if (this.rdbAnonymous.getSelection()) {
            this.askCommentOnSave |= Util.compare(this.donation.getDonationFrom(), 2) != 0;
            this.donation.setDonationFrom(2);
        } else {
            return false;
        }
        this.askCommentOnSave |= Util.compare(this.donation.getGroupId(), oldGroupId) != 0;
        this.askCommentOnSave |= Util.compare(this.donation.getGroupName(), oldGroupName) != 0;
        return true;
    }

    private boolean collectDonationData() {
        this.askCommentOnSave |= Util.compare(this.donation.getDocNr(), Util.c(this.txtDocNr.getText())) != 0;
        this.donation.setDocNr(Util.c(this.txtDocNr.getText()));
        Integer oldTypeId = this.donation.getTypeId();
        if (this.vwrTypes.getSelectedObject() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VDonationEdit.Type", new Object[0]);
            this.cmbType.setFocus();
            return false;
        }
        this.donation.setTypeId(this.vwrTypes.getSelectedObjectID());
        this.askCommentOnSave |= Util.compare(this.donation.getTypeId(), oldTypeId) != 0;
        Integer oldIntUseId = this.donation.getIntendedUseId();
        if (this.vwrIntendedUses.getSelectedObject() == null || this.vwrIntendedUses.getSelectedObjectID() == -1) {
            this.donation.setIntendedUseId(null);
        } else {
            this.donation.setIntendedUseId(this.vwrIntendedUses.getSelectedObjectID());
        }
        this.askCommentOnSave |= Util.compare(this.donation.getIntendedUseId(), oldIntUseId) != 0;
        this.askCommentOnSave |= Util.compare(this.donation.getDonationObject(), Util.c(this.txtObject.getText())) != 0;
        this.donation.setDonationObject(Util.c(this.txtObject.getText()));
        this.askCommentOnSave |= Util.compare(this.donation.getDonationDate(), this.dpcDate.getSqlDate()) != 0;
        this.donation.setDonationDate(this.dpcDate.getSqlDate());
        if (this.donation.getDonationDate() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VDonationEdit.Date", new Object[0]);
            this.dpcDate.setFocus();
            return false;
        }
        this.askCommentOnSave |= Util.compare(this.donation.getAmount(), Util.strToBigDecimal(this.txtAmount.getText())) != 0;
        this.donation.setAmount(Util.strToBigDecimal(this.txtAmount.getText()));
        if (this.donation.getAmount() == null) {
            if (Util.c(this.txtObject.getText()) == null) {
                GuiUtil.informationDialog(this.getShell(), "Err.VDonationEdit.ObjectAmount", new Object[0]);
                this.txtAmount.setFocus();
                return false;
            }
        } else if ((double)this.donation.getAmount().floatValue() < 0.0) {
            GuiUtil.informationDialog(this.getShell(), "Err.VDonationEdit.Amount", new Object[0]);
            this.txtAmount.setFocus();
            return false;
        }
        this.askCommentOnSave |= Util.compare(this.donation.isApproxAmount(), this.chkIsApprox.getSelection()) != 0;
        this.donation.setIsApproxAmount(this.chkIsApprox.getSelection());
        this.askCommentOnSave |= Util.compare(this.donation.isTaxReturned(), this.chkIsTaxReturned.getSelection()) != 0;
        this.donation.setIsTaxReturned(this.chkIsTaxReturned.getSelection());
        Integer oldPaymentMethod = this.donation.getPaymentMethod();
        if (this.vwrPaymentMethods.getSelectedObject() == null) {
            this.donation.setPaymentMethod(null);
            if (Util.c(this.txtObject.getText()) == null) {
                GuiUtil.informationDialog(this.getShell(), "Err.VDonationEdit.PaymentMethod", new Object[0]);
                this.cmbPaymentMethod.setFocus();
                return false;
            }
        } else {
            this.donation.setPaymentMethod(this.vwrPaymentMethods.getSelectedObjectID());
        }
        this.askCommentOnSave |= Util.compare(this.donation.getPaymentMethod(), oldPaymentMethod) != 0;
        this.askCommentOnSave |= Util.compare(this.donation.getComment(), Util.c(this.txtRemarks.getText())) != 0;
        this.donation.setComment(Util.c(this.txtRemarks.getText()));
        this.askCommentOnSave |= Util.compare(this.donation.getBook(), Util.c(this.txtBook.getText())) != 0;
        this.donation.setBook(Util.c(this.txtBook.getText()));
        this.askCommentOnSave |= Util.compare(this.donation.getPage(), Util.c(this.txtPage.getText())) != 0;
        this.donation.setPage(Util.c(this.txtPage.getText()));
        return true;
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.rdbPerson == e.getSource()) {
            this.setDonatorsEnabled(0);
        } else if (this.rdbGroup == e.getSource()) {
            this.setDonatorsEnabled(1);
        } else if (this.rdbAnonymous == e.getSource()) {
            this.setDonatorsEnabled(2);
        } else if (this.cmbRegGroup == e.getSource()) {
            this.setDonatorOtherGroupEnabled(true);
        } else if (this.cmbType == e.getSource()) {
            this.donationType = (DomDonationType)this.vwrTypes.getSelectedObject();
        } else if (this.chkIsApprox == e.getSource()) {
            this.updateTaxReturned();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() == this.txtObject) {
            this.togglePayment();
        }
    }

    private void togglePayment() {
        boolean enabled = Util.c(this.txtObject.getText()) == null;
        this.txtAmount.setEnabled(enabled);
        this.chkIsApprox.setEnabled(enabled);
        this.chkIsTaxReturned.setEnabled(enabled);
        this.cmbPaymentMethod.setEnabled(enabled);
        if (!enabled) {
            this.txtAmount.setText("");
            this.chkIsApprox.setSelection(false);
            this.chkIsTaxReturned.setSelection(false);
            this.vwrPaymentMethods.setSelectedObject(null);
        }
    }

    private void setDonatorsEnabled(int i) {
        switch (i) {
            case 0: {
                this.setDonatorPersonEnabled(true);
                this.setDonatorGroupEnabled(false);
                break;
            }
            case 1: {
                this.setDonatorPersonEnabled(false);
                this.setDonatorGroupEnabled(true);
                break;
            }
            case 2: {
                this.setDonatorPersonEnabled(false);
                this.setDonatorGroupEnabled(false);
            }
        }
    }

    private void setDonatorPersonEnabled(boolean b) {
        this.vwPerson.setEnabled(b);
    }

    private void setDonatorGroupEnabled(boolean b) {
        this.cmbRegGroup.setEnabled(b);
        this.setDonatorOtherGroupEnabled(b);
    }

    private void setDonatorOtherGroupEnabled(boolean b) {
        if (this.txtOtherGroup != null) {
            this.txtOtherGroup.setEnabled(b && (this.vwrRegGroups.getSelectedObject() == null || this.vwrRegGroups.getSelectedObjectID() == -1));
        }
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new GridLayout(1, false));
        this.initDonationHeaderCtrls();
        this.cmpBody = new Composite((Composite)this, 0);
        this.cmpBody.setLayoutData((Object)new GridData(1808));
        this.cmpBody.setLayout((Layout)new GridLayout(2, true));
        this.initDonatorCtrls();
        this.initDonationCtrls();
    }

    private void initDonationHeaderCtrls() {
        Composite cmpHeader = new Composite((Composite)this, 0);
        cmpHeader.setLayoutData((Object)new GridData(768));
        cmpHeader.setLayout((Layout)new GridLayout(1, true));
        Composite cmpRow1 = new Composite(cmpHeader, 0);
        cmpRow1.setLayoutData((Object)new GridData(768));
        cmpRow1.setLayout((Layout)new GridLayout(6, false));
        Label lblDocNr = new Label(cmpRow1, 0);
        lblDocNr.setText(Resources.getString("VDonationEdit.lblDocNr"));
        lblDocNr.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblDocNr);
        this.txtDocNr = new Text(cmpRow1, 2056);
        this.txtDocNr.setLayoutData((Object)new GridData(32));
        Label lblDate = new Label(cmpRow1, 0);
        lblDate.setText(Resources.getString("VDonationEdit.lblDate"));
        lblDate.setLayoutData((Object)new GridData(32));
        GuiUtil.displayAsMandatory((Control)lblDate);
        this.dpcDate = new DatePickerCombo(cmpRow1, 2048);
        this.dpcDate.setLayoutData(new GridData());
        this.dpcDate.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                VDonationEdit.this.lblAmountCurrency.setText(Currencies.getCurrencySymbol(VDonationEdit.this.dpcDate.getDate()));
            }

            public void focusGained(FocusEvent arg0) {
            }
        });
        Label lblType = new Label(cmpRow1, 0);
        lblType.setText(Resources.getString("VDonationEdit.lblType"));
        lblType.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblType);
        this.cmbType = new Combo(cmpRow1, 8);
        this.cmbType.setLayoutData((Object)new GridData(768));
        this.cmbType.addSelectionListener((SelectionListener)this);
        this.vwrTypes = new DomComboViewer(this.cmbType);
        Composite cmpRow2 = new Composite(cmpHeader, 0);
        cmpRow2.setLayoutData((Object)new GridData(768));
        cmpRow2.setLayout((Layout)new GridLayout(3, true));
        Label lblIntendedUse = new Label(cmpRow2, 0);
        lblIntendedUse.setText(Resources.getString("VDonationEdit.lblIntendedUse"));
        GridData grSpan = new GridData(128);
        grSpan.horizontalSpan = 2;
        lblIntendedUse.setLayoutData((Object)grSpan);
        Combo cmbIntendedUse = new Combo(cmpRow2, 8);
        cmbIntendedUse.setLayoutData((Object)new GridData(768));
        this.vwrIntendedUses = new DomComboViewer(cmbIntendedUse);
    }

    private void initDonatorCtrls() {
        Composite cmpDonator = new Composite(this.cmpBody, 0);
        cmpDonator.setLayoutData((Object)new GridData(770));
        cmpDonator.setLayout((Layout)new GridLayout(1, false));
        this.rdbPerson = new Button(cmpDonator, 16);
        this.rdbPerson.setText(Resources.getString("VDonationEdit.rdbPerson"));
        this.rdbPerson.setLayoutData((Object)new GridData(768));
        this.rdbPerson.addSelectionListener((SelectionListener)this);
        GuiUtil.displayAsMandatory((Control)this.rdbPerson);
        Group grpPerson = new Group(cmpDonator, 0);
        grpPerson.setText(Resources.getString("VDonationEdit.grpPerson"));
        grpPerson.setLayoutData((Object)new GridData(768));
        grpPerson.setLayout((Layout)new FillLayout());
        this.vwPerson = new VPersonData((Composite)grpPerson, true, true, false, 0);
        this.rdbGroup = new Button(cmpDonator, 16);
        this.rdbGroup.setText(Resources.getString("VDonationEdit.rdbGroup"));
        this.rdbGroup.setLayoutData((Object)new GridData(768));
        this.rdbGroup.addSelectionListener((SelectionListener)this);
        GuiUtil.displayAsMandatory((Control)this.rdbGroup);
        Group grpGroup = new Group(cmpDonator, 16);
        grpGroup.setText(Resources.getString("VDonationEdit.grpGroup"));
        grpGroup.setLayoutData((Object)new GridData(768));
        grpGroup.setLayout((Layout)new GridLayout(2, false));
        Label lblOtherGroup = new Label((Composite)grpGroup, 0);
        lblOtherGroup.setText(Resources.getString("VDonationEdit.lblOtherGroup"));
        lblOtherGroup.setLayoutData((Object)new GridData(128));
        this.txtOtherGroup = new Text((Composite)grpGroup, 2048);
        this.txtOtherGroup.setLayoutData((Object)new GridData(768));
        Label lblRegGroup = new Label((Composite)grpGroup, 0);
        lblRegGroup.setText(Resources.getString("VDonationEdit.lblRegGroup"));
        lblRegGroup.setLayoutData((Object)new GridData(128));
        this.cmbRegGroup = new Combo((Composite)grpGroup, 8);
        this.cmbRegGroup.setLayoutData((Object)new GridData(768));
        this.cmbRegGroup.addSelectionListener((SelectionListener)this);
        this.vwrRegGroups = new DomComboViewer(this.cmbRegGroup);
        this.rdbAnonymous = new Button(cmpDonator, 16);
        this.rdbAnonymous.setText(Resources.getString("VDonationEdit.rdbAnonymous"));
        this.rdbAnonymous.setLayoutData((Object)new GridData(768));
        this.rdbAnonymous.addSelectionListener((SelectionListener)this);
        GuiUtil.displayAsMandatory((Control)this.rdbAnonymous);
    }

    private void initDonationCtrls() {
        Composite cmpDonation = new Composite(this.cmpBody, 0);
        cmpDonation.setLayoutData((Object)new GridData(1808));
        cmpDonation.setLayout((Layout)new GridLayout(1, true));
        Composite cmpDonationSpecific = new Composite(cmpDonation, 0);
        cmpDonationSpecific.setLayoutData((Object)new GridData(1808));
        cmpDonationSpecific.setLayout((Layout)new GridLayout(2, false));
        Label lblCongregation = new Label(cmpDonationSpecific, 0);
        lblCongregation.setText(Resources.getString("VDonationEdit.lblCongregation"));
        lblCongregation.setLayoutData((Object)new GridData(128));
        this.txtCongregation = new Text(cmpDonationSpecific, 2056);
        this.txtCongregation.setLayoutData((Object)new GridData(768));
        Label lblObject = new Label(cmpDonationSpecific, 0);
        lblObject.setText(Resources.getString("VDonationEdit.lblObject"));
        lblObject.setLayoutData((Object)new GridData(128));
        this.txtObject = new Text(cmpDonationSpecific, 2048);
        this.txtObject.setLayoutData((Object)new GridData(768));
        this.txtObject.addModifyListener((ModifyListener)this);
        Label lblAmount = new Label(cmpDonationSpecific, 0);
        lblAmount.setText(Resources.getString("VDonationEdit.lblAmount"));
        lblAmount.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblAmount);
        Composite cmp = new Composite(cmpDonationSpecific, 0);
        cmp.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        cmp.setLayout((Layout)gridLayout);
        this.txtAmount = new Text(cmp, 2048);
        this.txtAmount.setLayoutData((Object)new GridData(32));
        this.lblAmountCurrency = new Label(cmp, 0);
        this.lblAmountCurrency.setLayoutData((Object)new GridData(768));
        new Label(cmpDonationSpecific, 0);
        this.chkIsApprox = new Button(cmpDonationSpecific, 32);
        this.chkIsApprox.setText(Resources.getString("VDonationEdit.chkIsApprox"));
        this.chkIsApprox.addSelectionListener((SelectionListener)this);
        new Label(cmpDonationSpecific, 0);
        this.chkIsTaxReturned = new Button(cmpDonationSpecific, 32);
        this.chkIsTaxReturned.setText(Resources.getString("VDonationEdit.chkIsTaxReturned"));
        this.chkIsTaxReturned.setSelection(true);
        Label lblPaymentMethod = new Label(cmpDonationSpecific, 0);
        lblPaymentMethod.setText(Resources.getString("VDonationEdit.lblPaymentMethod"));
        lblPaymentMethod.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblPaymentMethod);
        this.cmbPaymentMethod = new Combo(cmpDonationSpecific, 8);
        this.cmbPaymentMethod.setLayoutData((Object)new GridData(768));
        this.cmbPaymentMethod.addSelectionListener((SelectionListener)this);
        this.vwrPaymentMethods = new DomComboViewer(this.cmbPaymentMethod);
        Label lblRemarks = new Label(cmpDonationSpecific, 0);
        lblRemarks.setText(Resources.getString("VDonationEdit.lblRemarks"));
        lblRemarks.setLayoutData((Object)new GridData(130));
        this.txtRemarks = new Text(cmpDonationSpecific, 2050);
        this.txtRemarks.setLayoutData((Object)new GridData(1808));
        Label lblBook = new Label(cmpDonationSpecific, 0);
        lblBook.setText(Resources.getString("VDonationEdit.lblBook"));
        lblBook.setLayoutData((Object)new GridData(128));
        this.txtBook = new Text(cmpDonationSpecific, 2048);
        this.txtBook.setLayoutData((Object)new GridData(768));
        Label lblPage = new Label(cmpDonationSpecific, 0);
        lblPage.setText(Resources.getString("VDonationEdit.lblPage"));
        lblPage.setLayoutData((Object)new GridData(128));
        this.txtPage = new Text(cmpDonationSpecific, 2048);
        this.txtPage.setLayoutData((Object)new GridData(768));
    }

    private void updateTaxReturned() {
        if (this.chkIsApprox.getSelection()) {
            this.chkIsTaxReturned.setSelection(false);
        }
        this.chkIsTaxReturned.setEnabled(!this.chkIsApprox.getSelection());
        this.togglePayment();
    }
}

