/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.model.DomConnection;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.preference.MConnection;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.VEdit;
import java.sql.SQLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VConnectionEdit
extends VEdit {
    private DomConnection connection;
    private boolean skipLoad = false;
    private boolean extended = false;
    private Text txtDriver;
    private Text txtHost;
    private Text txtPort;
    private Text txtDb;
    private Text txtSsl;

    public VConnectionEdit(Composite parent) {
        this(parent, 0);
    }

    public VConnectionEdit(Composite parent, int style) {
        super(parent, style);
    }

    public DomConnection getConnection() {
        return this.connection;
    }

    public void setConnection(DomConnection value) {
        this.skipLoad = true;
        this.connection = value;
    }

    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        if (this.skipLoad) {
            return;
        }
        this.connection = new DomConnection();
        MConnection.instance().load(this.connection);
    }

    @Override
    public void refresh() {
        if (this.connection == null) {
            return;
        }
        if (this.txtDriver != null) {
            this.txtDriver.setText(Util.d(this.connection.getDriver()));
        }
        this.txtHost.setText(Util.d(this.connection.getHost()));
        this.txtPort.setText(Util.d(this.connection.getPort()));
        this.txtDb.setText(Util.d(this.connection.getDatabaseName()));
        this.txtSsl.setText(Util.d(this.connection.getHasSsl() != false ? "true" : "false"));
    }

    @Override
    public boolean save(IProgressMonitor p) throws SQLException {
        MConnection.instance().save(this.connection);
        return false;
    }

    @Override
    public boolean collect() {
        if (this.connection == null) {
            this.connection = new DomConnection();
        }
        if (this.txtDriver != null) {
            this.connection.setDriver(Util.c(this.txtDriver.getText()));
            if (this.connection.getDriver() == null) {
                GuiUtil.informationDialog(this.getShell(), "Err.VConnectionEdit.Driver", new Object[0]);
                this.txtDriver.setFocus();
                return false;
            }
        }
        this.connection.setHost(Util.c(this.txtHost.getText()));
        if (this.connection.getHost() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VConnectionEdit.Host", new Object[0]);
            this.txtHost.setFocus();
            return false;
        }
        this.connection.setPort(Util.c(this.txtPort.getText()));
        if (this.connection.getPort() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VConnectionEdit.Port", new Object[0]);
            this.txtPort.setFocus();
            return false;
        }
        this.connection.setDatabaseName(Util.c(this.txtDb.getText()));
        if (this.connection.getDatabaseName() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VConnectionEdit.DatabaseName", new Object[0]);
            this.txtDb.setFocus();
            return false;
        }
        this.connection.setHasSsl(Util.c(this.txtSsl.getText()).contains("true"));
        return true;
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new GridLayout(2, false));
        if (this.extended) {
            Label lblDriver = new Label((Composite)this, 0);
            lblDriver.setText(Resources.getString("VConnection.lblDriver"));
            lblDriver.setLayoutData((Object)new GridData(128));
            GuiUtil.displayAsMandatory((Control)lblDriver);
            this.txtDriver = new Text((Composite)this, 2048);
            this.txtDriver.setLayoutData((Object)new GridData(768));
            this.txtDriver.setTextLimit(240);
        }
        Label lblHost = new Label((Composite)this, 0);
        lblHost.setText(Resources.getString("VConnection.lblHost"));
        lblHost.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblHost);
        this.txtHost = new Text((Composite)this, 2048);
        this.txtHost.setLayoutData((Object)new GridData(768));
        this.txtHost.setTextLimit(240);
        Label lblPort = new Label((Composite)this, 0);
        lblPort.setText(Resources.getString("VConnection.lblPort"));
        lblPort.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblPort);
        this.txtPort = new Text((Composite)this, 2048);
        this.txtPort.setTextLimit(240);
        this.txtPort.setLayoutData((Object)new GridData(768));
        Label lblDb = new Label((Composite)this, 0);
        lblDb.setText(Resources.getString("VConnection.lblDb"));
        lblDb.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblDb);
        this.txtDb = new Text((Composite)this, 2048);
        this.txtDb.setTextLimit(240);
        this.txtDb.setLayoutData((Object)new GridData(768));
        Label lblSsl = new Label((Composite)this, 0);
        lblSsl.setText(Resources.getString("VConnection.lblSsl"));
        lblSsl.setLayoutData((Object)new GridData(128));
        this.txtSsl = new Text((Composite)this, 2048);
        this.txtSsl.setTextLimit(240);
        this.txtSsl.setLayoutData((Object)new GridData(768));
    }
}

