/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MDeanery;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomDeanery;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.util.Util;
import eelk.koguja.view.ILoad;
import eelk.koguja.view.VAttributes;
import eelk.koguja.view.VCongregationAttributes;
import eelk.koguja.view.View;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class VCongregations
extends View
implements ILoad,
ISelectionChangedListener,
SelectionListener {
    private static final Logger logger = Logger.getLogger(VCongregations.class);
    private List<DomDeanery> deaneries;
    private List<DomCongregation> congregations;
    private Group grpCongregations;
    private VAttributes<DomDeanery> vwDeaneries;
    private VCongregationAttributes vwCongregations;

    public VCongregations(Composite parent) {
        this(parent, 0);
    }

    public VCongregations(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    public Integer getObjectID() {
        return null;
    }

    @Override
    public void setObjectID(Integer i) {
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new GridLayout(1, true));
        Group grpDeaneries = new Group((Composite)this, 0);
        grpDeaneries.setLayout((Layout)new FillLayout());
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        grpDeaneries.setLayoutData((Object)gd);
        grpDeaneries.setText(Resources.getString("VCongregations.grpDeaneries"));
        this.vwDeaneries = new VAttributes((Composite)grpDeaneries);
        GuiUtil.displayAsMandatory((Control)this.vwDeaneries.getNameLabel());
        this.vwDeaneries.setTableHeaderText(Resources.getString("VCongregations.vwDeaneries.colName"));
        this.vwDeaneries.setNameLabelText(Resources.getString("VCongregations.vwDeaneries.lblName"));
        this.vwDeaneries.getVwrAttributes().packColumns();
        this.grpCongregations = new Group((Composite)this, 0);
        this.grpCongregations.setLayout((Layout)new FillLayout());
        gd = new GridData(1808);
        gd.minimumHeight = 300;
        this.grpCongregations.setLayoutData((Object)gd);
        this.grpCongregations.setText(Resources.getString("VCongregations.grpCongregations"));
        this.vwCongregations = new VCongregationAttributes((Composite)this.grpCongregations){

            @Override
            public boolean isAddEnabled() {
                return super.isAddEnabled() && VCongregations.this.vwDeaneries.getAttributesTable().getSelectionCount() == 1;
            }
        };
        GuiUtil.displayAsMandatory((Control)this.vwCongregations.getNameLabel());
        this.vwCongregations.setTableHeaderText(Resources.getString("VCongregations.vwCongregations.colName"));
        this.vwCongregations.setNameLabelText(Resources.getString("VCongregations.vwCongregations.lblName"));
        this.vwCongregations.getVwrAttributes().packColumns();
        this.vwDeaneries.getVwrAttributes().getViewer().addSelectionChangedListener(this);
        this.vwDeaneries.getBtnAdd().addSelectionListener((SelectionListener)this);
        this.vwDeaneries.getBtnModify().addSelectionListener((SelectionListener)this);
        this.vwDeaneries.getBtnDelete().addSelectionListener((SelectionListener)this);
        this.vwCongregations.getBtnAdd().addSelectionListener((SelectionListener)this);
        this.vwCongregations.getBtnModify().addSelectionListener((SelectionListener)this);
        this.vwCongregations.getBtnDelete().addSelectionListener((SelectionListener)this);
        this.setTitle(Resources.getString("VCongregations.Title"));
    }

    @Override
    public void selectionChanged(SelectionChangedEvent e) {
        IStructuredSelection sel = (IStructuredSelection)e.getSelection();
        this.loadCongregations((DomDeanery)sel.getFirstElement());
        this.vwCongregations.checkButtons();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.vwDeaneries.getBtnAdd())) {
            this.createDeanery();
        } else if (e.getSource().equals(this.vwDeaneries.getBtnModify())) {
            this.modifyDeanery((DomDeanery)this.vwDeaneries.getSelectedObject(), this.vwDeaneries.getAttributeText());
        } else if (e.getSource().equals(this.vwDeaneries.getBtnDelete())) {
            this.deleteDeanery((DomDeanery)this.vwDeaneries.getSelectedObject());
        } else if (e.getSource().equals(this.vwCongregations.getBtnAdd())) {
            this.createCongregation(((DomDeanery)this.vwDeaneries.getSelectedObject()).getId());
        } else if (e.getSource().equals(this.vwCongregations.getBtnModify())) {
            this.modifyCongregation((DomCongregation)this.vwCongregations.getSelectedObject(), this.vwCongregations.getAttributeText(), this.vwCongregations.getCongLocation(), this.vwCongregations.getEMail(), this.vwCongregations.getAddressId(), this.vwCongregations.getAutomailEnabled());
        } else if (e.getSource().equals(this.vwCongregations.getBtnDelete())) {
            this.deleteCongregation((DomCongregation)this.vwCongregations.getSelectedObject());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    private int createDeanery() {
        String newDeaneryName = this.vwDeaneries.getAttributeText();
        final DomDeanery domDeanery = new DomDeanery();
        domDeanery.setName(newDeaneryName);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("CreatingObject"), -1);
                try {
                    MDeanery.instance().create(domDeanery);
                    Session.connection().commit();
                    VCongregations.this.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Create"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
        return 0;
    }

    private int modifyDeanery(DomDeanery domDeanery, String newName) {
        if (!GuiUtil.confirmationDialog(this.getShell(), "Msg.ConfirmDeanMod", domDeanery.getName(), newName)) {
            return -1;
        }
        final DomDeanery deanery = domDeanery.clone();
        deanery.setName(newName);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("Save.Saving"), -1);
                try {
                    MDeanery.instance().modify(deanery);
                    Session.connection().commit();
                    VCongregations.this.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
        return 0;
    }

    private int deleteDeanery(DomDeanery domDeanery) {
        if (!GuiUtil.confirmationDialog(this.getShell(), "Msg.ConfirmDeanDel", domDeanery.getName())) {
            return -1;
        }
        final DomDeanery deanery = domDeanery;
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("DeletingObject"), -1);
                try {
                    MDeanery.instance().delete(deanery.getId());
                    Session.connection().commit();
                    VCongregations.this.load(p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
                catch (ObjectNotFound e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Delete") + "." + Resources.getErrString("ObjectNotFound"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refresh();
        return 0;
    }

    private int createCongregation(int deaneryId) {
        final DomCongregation domCongregation = this.vwCongregations.getCongregation();
        domCongregation.setDeaneryId(deaneryId);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("CreatingObject"), -1);
                try {
                    MCongregation.instance().create(domCongregation);
                    Session.connection().commit();
                    VCongregations.this.congregations = MCongregation.listCongregations(domCongregation.getDeaneryId());
                    MCongregation.instance().populateCashedCongs();
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Create"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refreshCong();
        return 0;
    }

    private int modifyCongregation(DomCongregation domCongregation, String newName, String newLocation, String newEMail, Integer addressId, Boolean automailEnabled) {
        if (!GuiUtil.confirmationDialog(this.getShell(), "Msg.ConfirmCongMod", domCongregation.getName())) {
            return -1;
        }
        final DomCongregation congregation = domCongregation.clone();
        congregation.setName(Util.c(newName));
        congregation.setLocation(Util.c(newLocation));
        congregation.setEMail(Util.c(newEMail));
        congregation.setAddressId(addressId);
        congregation.setAutomailerEnabled(automailEnabled);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("Save.Saving"), -1);
                try {
                    MCongregation.instance().modify(congregation);
                    Session.connection().commit();
                    VCongregations.this.congregations = MCongregation.listCongregations(congregation.getDeaneryId());
                    MCongregation.instance().populateCashedCongs();
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refreshCong();
        return 0;
    }

    private int deleteCongregation(DomCongregation domCongregation) {
        if (!GuiUtil.confirmationDialog(this.getShell(), "Msg.ConfirmCongDel", domCongregation.getName())) {
            return -1;
        }
        final DomCongregation congregation = domCongregation;
        congregation.setDeaneryId(domCongregation.getDeaneryId());
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("DeletingObject"), -1);
                try {
                    MCongregation.instance().delete(congregation.getId());
                    Session.connection().commit();
                    VCongregations.this.congregations = MCongregation.listCongregations(congregation.getDeaneryId());
                    MCongregation.instance().populateCashedCongs();
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                }
                catch (ObjectNotFound e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Delete") + "." + Resources.getErrString("ObjectNotFound"), new Object[0]);
                }
            }
        };
        Operation.run(this.getShell(), true, r);
        this.refreshCong();
        return 0;
    }

    protected void loadCongregations(DomDeanery deanery) {
        if (deanery == null) {
            this.congregations = new ArrayList<DomCongregation>();
        } else {
            final int id = deanery.getId();
            IRunnableWithProgress r = new IRunnableWithProgress(){

                @Override
                public void run(IProgressMonitor p) {
                    p.beginTask(Resources.getMsgString("LoadingCongregations"), -1);
                    try {
                        VCongregations.this.congregations = MCongregation.listCongregations(id);
                        p.done();
                    }
                    catch (SQLException e) {
                        p.done();
                        SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Load"), new Object[0]);
                    }
                }
            };
            Operation.run(this.getShell(), true, r);
        }
        this.refreshCong();
    }

    public VAttributes getDeanView() {
        return this.vwDeaneries;
    }

    public VAttributes getCongView() {
        return this.vwCongregations;
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException {
        this.deaneries = MDeanery.listDeaneries();
    }

    @Override
    public void refresh() {
        this.vwDeaneries.setSource(this.deaneries);
    }

    public void refreshCong() {
        this.vwCongregations.setSource(this.congregations);
    }
}

