/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MAddress;
import eelk.koguja.model.DomAddress;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.seq.SeqModifyAddress;
import eelk.koguja.seq.SeqNewAddress;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.util.Util;
import eelk.koguja.view.VAttributes;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VCongregationAttributes
extends VAttributes<DomCongregation> {
    private static final Logger logger = Logger.getLogger(VCongregationAttributes.class);
    private SeqNewAddress seqNew;
    private SeqModifyAddress seqModify;
    private DomAddress address;
    private DomCongregation congregation;
    private Text txtLocation;
    private Text txtEMail;
    private Text txtAddress;
    private Button btnAddress;
    private Button chkAutomailEnabled;

    public VCongregationAttributes(Composite parent) {
        super(parent);
    }

    public VCongregationAttributes(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void initControls() {
    }

    @Override
    protected void initControlsHere() {
        super.initControlsHere();
        this.getAttrPanel().setLayout((Layout)new GridLayout(2, false));
        this.getNameLabel().setLayoutData((Object)new GridData(128));
        this.getNameControl().setLayoutData((Object)new GridData(768));
        Label lblLocation = new Label(this.getAttrPanel(), 0);
        lblLocation.setText(Resources.getString("VCongregations.vwCongregations.lblLocation"));
        lblLocation.setLayoutData((Object)new GridData(128));
        this.txtLocation = new Text(this.getAttrPanel(), 2048);
        this.txtLocation.setLayoutData((Object)new GridData(768));
        Label lblEMail = new Label(this.getAttrPanel(), 0);
        lblEMail.setText(Resources.getString("VCongregations.vwCongregations.lblEMail"));
        lblEMail.setLayoutData((Object)new GridData(128));
        this.txtEMail = new Text(this.getAttrPanel(), 2048);
        this.txtEMail.setLayoutData((Object)new GridData(768));
        Label lblAddress = new Label(this.getAttrPanel(), 0);
        lblAddress.setText(Resources.getString("VCongregations.vwCongregations.lblAddress"));
        lblAddress.setLayoutData((Object)new GridData(128));
        Composite cmp = new Composite(this.getAttrPanel(), 0);
        GridLayout grlay = new GridLayout(2, false);
        cmp.setLayoutData((Object)new GridData(768));
        grlay.marginBottom = -5;
        grlay.marginLeft = -5;
        grlay.marginRight = -5;
        grlay.marginTop = -5;
        cmp.setLayout((Layout)grlay);
        this.txtAddress = new Text(cmp, 2048);
        this.txtAddress.setLayoutData((Object)new GridData(768));
        this.txtAddress.setEnabled(false);
        this.btnAddress = new Button(cmp, 8);
        this.btnAddress.setText(Resources.getString("VCongregations.vwCongregations.btnAddress"));
        this.btnAddress.setLayoutData((Object)new GridData(256));
        this.btnAddress.addSelectionListener((SelectionListener)this);
        Label lblAutomailEnabled = new Label(this.getAttrPanel(), 0);
        lblAutomailEnabled.setText(Resources.getString("VCongregations.vwCongregations.lblAutomailEnabled"));
        lblAutomailEnabled.setLayoutData((Object)new GridData(132));
        this.chkAutomailEnabled = new Button(this.getAttrPanel(), 32);
        this.chkAutomailEnabled.setLayoutData((Object)new GridData(768));
        this.chkAutomailEnabled.setEnabled(false);
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
        super.widgetSelected(e);
        if (e.getSource() == this.btnAddress) {
            this.modifyAddress();
        }
    }

    @Override
    public void selectionChanged(SelectionChangedEvent e) {
        if (e.getSelection().isEmpty()) {
            this.setAttributeText("");
            this.txtLocation.setText("");
            this.txtEMail.setText("");
            this.txtAddress.setText("");
            this.address = null;
            this.chkAutomailEnabled.setSelection(false);
            this.chkAutomailEnabled.setEnabled(false);
        } else {
            DomCongregation cong = (DomCongregation)this.getVwrAttributes().getSelectedObject();
            if (cong == this.congregation) {
                return;
            }
            this.congregation = cong;
            this.setAttributeText(this.getSelectedObject().toString());
            this.txtLocation.setText(Util.d(cong.getLocation()));
            this.txtEMail.setText(Util.d(cong.getEMail()));
            this.loadCongAddress(cong.getAddressId());
            this.txtAddress.setText(this.address == null ? "" : this.address.toString());
            this.chkAutomailEnabled.setSelection(cong.getAutomailerEnbled().booleanValue());
            this.chkAutomailEnabled.setEnabled(true);
        }
        this.checkButtons();
    }

    public DomCongregation getCongregation() {
        DomCongregation result = new DomCongregation();
        result.setName(this.getAttributeText());
        result.setLocation(this.getCongLocation());
        result.setEMail(this.getEMail());
        result.setAddressId(this.address == null ? null : Integer.valueOf(this.address.getId()));
        result.setAutomailerEnabled(this.getAutomailEnabled());
        return result;
    }

    public Boolean getAutomailEnabled() {
        return this.chkAutomailEnabled.getSelection();
    }

    public String getCongLocation() {
        return this.txtLocation.getText();
    }

    public String getEMail() {
        return this.txtEMail.getText();
    }

    public Integer getAddressId() {
        return this.address == null ? null : Integer.valueOf(this.address.getId());
    }

    @Override
    public boolean isAddEnabled() {
        return super.isAddEnabled() && this.getAddressId() != null;
    }

    private void modifyAddress() {
        if (this.address == null) {
            if (this.seqNew == null) {
                this.seqNew = new SeqNewAddress(this.getShell());
            }
            this.seqNew.setCongregationAddress(true);
            if (Sequence.execSequence(this.seqNew) == Sequence.SeqResult.SeqCompleted) {
                this.address = this.seqNew.getAddress();
            }
        } else {
            if (this.seqModify == null) {
                this.seqModify = new SeqModifyAddress(this.getShell());
            }
            this.seqModify.setAddress(this.address);
            this.seqModify.setCongregationAddress(true);
            if (Sequence.execSequence(this.seqModify) == Sequence.SeqResult.SeqCompleted) {
                this.address = this.seqModify.getAddress();
            }
        }
        if (this.address != null) {
            this.txtAddress.setText(this.address.toString());
        }
        this.checkButtons();
    }

    private void loadCongAddress(final Integer id) {
        if (id == null) {
            this.address = null;
            this.txtAddress.setText("");
            return;
        }
        Operation.run(this.getShell(), true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    p.beginTask(Resources.getMsgString("Load.Loading"), -1);
                    VCongregationAttributes.this.address = MAddress.instance().get(id);
                    p.done();
                }
                catch (SQLException ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
                }
                catch (ObjectNotFound ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        });
        this.txtAddress.setText(this.address.toString());
    }
}

