/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.dao.MConfirmation;
import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.gui.DiffText;
import eelk.koguja.model.DomConfirmation;
import eelk.koguja.model.DomConfirmationHistory;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.VEventPreview;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VConfirmationPreview
extends VEventPreview<DomConfirmation, DomConfirmationHistory> {
    private String personCongregation;
    private Text txtSurename;
    private Text txtGivenName;
    private Text txtDateOfBirth;
    private Text txtCongregation;
    private Text txtGrade;
    private DiffText diffLastName;
    private DiffText diffFirstName;
    private DiffText diffDateOfBirth;
    private DiffText diffGrade;

    public VConfirmationPreview(Composite parent) {
        this(parent, 0);
    }

    public VConfirmationPreview(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected Composite getSpecificPane(Composite parent, int style) {
        Composite specificPane = new Composite(parent, style);
        specificPane.setLayout((Layout)new FillLayout());
        Group grpIndividual = new Group(specificPane, 0);
        grpIndividual.setText(Resources.getString("VConfirmationPreview.grpIndividual"));
        grpIndividual.setLayout((Layout)new GridLayout(2, false));
        Label lblSurename = new Label((Composite)grpIndividual, 0);
        lblSurename.setText(Resources.getString("VConfirmationPreview.lblSurename"));
        lblSurename.setLayoutData((Object)new GridData(128));
        this.txtSurename = new Text((Composite)grpIndividual, 2052);
        this.txtSurename.setLayoutData((Object)new GridData(768));
        this.txtSurename.setEditable(false);
        Label lblGivenName = new Label((Composite)grpIndividual, 0);
        lblGivenName.setText(Resources.getString("VConfirmationPreview.lblGivenName"));
        lblGivenName.setLayoutData((Object)new GridData(128));
        this.txtGivenName = new Text((Composite)grpIndividual, 2052);
        this.txtGivenName.setLayoutData((Object)new GridData(768));
        this.txtGivenName.setEditable(false);
        Label lblDateOfBirth = new Label((Composite)grpIndividual, 0);
        lblDateOfBirth.setText(Resources.getString("VConfirmationPreview.lblDateOfBirth"));
        lblDateOfBirth.setLayoutData((Object)new GridData(128));
        this.txtDateOfBirth = new Text((Composite)grpIndividual, 2052);
        this.txtDateOfBirth.setLayoutData((Object)new GridData(768));
        this.txtDateOfBirth.setEditable(false);
        Label lblGrade = new Label((Composite)grpIndividual, 0);
        lblGrade.setText(Resources.getString("VConfirmationPreview.lblGrade"));
        lblGrade.setLayoutData((Object)new GridData(128));
        this.txtGrade = new Text((Composite)grpIndividual, 2052);
        this.txtGrade.setLayoutData((Object)new GridData(768));
        this.txtGrade.setEditable(false);
        Label lblCongregation = new Label((Composite)grpIndividual, 0);
        lblCongregation.setText(Resources.getString("VConfirmationPreview.lblCongregation"));
        lblCongregation.setLayoutData((Object)new GridData(128));
        this.txtCongregation = new Text((Composite)grpIndividual, 2052);
        this.txtCongregation.setLayoutData((Object)new GridData(768));
        this.txtCongregation.setEditable(false);
        return specificPane;
    }

    @Override
    protected void initControls() {
        super.initControls();
        this.diffLastName = new DiffText(this.txtSurename);
        this.diffFirstName = new DiffText(this.txtGivenName);
        this.diffDateOfBirth = new DiffText(this.txtDateOfBirth);
        this.diffGrade = new DiffText(this.txtGrade);
    }

    @Override
    protected void setSelectedObject(Integer objectId) throws SQLException, ObjectNotFound {
        this.selectedObject = MConfirmation.instance().get(objectId);
    }

    @Override
    protected List<DomConfirmationHistory> getHistoryList() throws SQLException, ObjectNotFound {
        List<DomConfirmationHistory> list = MConfirmation.instance().getConfirmationHistory(this.getObjectID());
        list.add(0, new DomConfirmationHistory((DomConfirmation)this.selectedObject));
        return list;
    }

    @Override
    public void loadHistory() {
        if (this.historyID == null) {
            return;
        }
        super.loadHistory();
        String newLastName = Util.d(((DomConfirmationHistory)this.historicalObject).getPersonLastName());
        String newFirstName = Util.d(((DomConfirmationHistory)this.historicalObject).getPersonFirstName());
        String newDateOfBirth = Util.dateToStr(((DomConfirmationHistory)this.historicalObject).getPersonBirthDate());
        String newGrade = Util.d(((DomConfirmationHistory)this.historicalObject).getMark());
        this.txtSurename.setText(newLastName);
        this.txtGivenName.setText(newFirstName);
        this.txtDateOfBirth.setText(newDateOfBirth);
        this.txtGrade.setText(newGrade);
    }

    @Override
    public void refresh() {
        super.refresh();
        DomConfirmation confirmation = (DomConfirmation)this.selectedObject;
        this.setTitle(Util.d(confirmation.getPersonLastName()));
        this.txtSurename.setText(Util.d(confirmation.getPersonLastName()));
        this.txtGivenName.setText(Util.d(confirmation.getPersonFirstName()));
        this.txtCongregation.setText(this.personCongregation);
        this.txtDateOfBirth.setText(Util.dateToStr(confirmation.getPersonBirthDate()));
        this.txtGrade.setText(Util.d(confirmation.getMark()));
        this.diffLastName.setBaseText(confirmation.getPersonLastName());
        this.diffFirstName.setBaseText(confirmation.getPersonFirstName());
        this.diffDateOfBirth.setBaseText(Util.dateToStr(confirmation.getPersonBirthDate()));
        this.diffGrade.setBaseText(confirmation.getMark());
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        super.load(p);
        if (this.selectedObject == null) {
            return;
        }
        Integer personCongId = null;
        if (((DomConfirmation)this.selectedObject).getPersonId() != null) {
            personCongId = MPersonSwt.instance().getCongregation(((DomConfirmation)this.selectedObject).getPersonId());
        }
        this.personCongregation = personCongId == null ? "" : MCongregation.instance().get(personCongId).getName();
    }

    @Override
    protected int getEventType() {
        return 1;
    }
}

