/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MConfirmation;
import eelk.koguja.model.DomConfirmation;
import eelk.koguja.model.DomParticipant;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.ISave;
import eelk.koguja.view.VEdit;
import eelk.koguja.view.VEventCommon;
import eelk.koguja.view.VPersonData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VConfirmationEdit
extends VEdit {
    private DomConfirmation confirmation;
    private boolean askCommentOnSave = true;
    private VEventCommon vwEventCommon;
    private Composite cmpConfirmation;
    private VPersonData vwConfPerson;
    private Text txtMarkGrade;

    public VConfirmationEdit(Composite parent) {
        this(parent, 0);
    }

    public VConfirmationEdit(Composite parent, int style) {
        super(parent, style);
    }

    public DomConfirmation getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmedPersonId(Integer id) {
        this.vwConfPerson.setObjectID(id);
    }

    public boolean askCommentOnSave() {
        return this.askCommentOnSave;
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        p.beginTask(Resources.getMsgString("Load.Loading"), 7);
        this.setMode(this.getObjectID() == null ? ISave.SaveMode.SaveAdd : ISave.SaveMode.SaveUpdate);
        if (this.getObjectID() != null) {
            this.setMode(ISave.SaveMode.SaveUpdate);
            this.vwEventCommon.setMode(ISave.SaveMode.SaveUpdate);
            this.confirmation = MConfirmation.instance().get(this.getObjectID());
            this.vwEventCommon.setEvent(this.getConfirmation());
            this.vwConfPerson.setPerson(this.getConfirmation().getPersonId(), this.getConfirmation().getPersonFirstName(), this.getConfirmation().getPersonLastName(), this.getConfirmation().getPersonBirthDate(), this.getConfirmation().getPersonCode());
            this.vwEventCommon.setParticipants(MConfirmation.instance().getParticipants(this.getObjectID()));
        } else {
            this.setMode(ISave.SaveMode.SaveAdd);
            this.vwEventCommon.setMode(ISave.SaveMode.SaveAdd);
            this.vwEventCommon.setParticipants(new ArrayList<DomParticipant>());
            this.confirmation = new DomConfirmation();
            this.confirmation.setDocNr(MConfirmation.getNextDocNr(Session.congregation().getId()));
            this.vwEventCommon.setEvent(this.confirmation);
        }
        p.worked(1);
        this.vwEventCommon.load(p);
        this.vwConfPerson.load(p);
        p.worked(1);
        this.askCommentOnSave = false;
        p.done();
    }

    @Override
    public void refresh() {
        this.vwEventCommon.refresh();
        this.vwConfPerson.refresh();
        if (this.confirmation == null) {
            return;
        }
        if (this.getConfirmation().getMark() != null) {
            this.txtMarkGrade.setText(Util.d(this.confirmation.getMark()));
        }
    }

    @Override
    public boolean save(IProgressMonitor p) throws SQLException {
        p.beginTask(Resources.getMsgString("Save.Saving"), 2);
        if (this.getMode().equals((Object)ISave.SaveMode.SaveAdd)) {
            this.setObjectID(MConfirmation.instance().create(this.confirmation));
        } else if (this.getMode().equals((Object)ISave.SaveMode.SaveUpdate)) {
            MConfirmation.instance().modify(this.confirmation);
        }
        p.worked(1);
        MConfirmation.instance().setParticipants(this.getObjectID(), this.vwEventCommon.getParticipants());
        p.worked(2);
        p.done();
        return this.objectID >= 0;
    }

    @Override
    public boolean collect() {
        if (this.confirmation == null) {
            this.confirmation = new DomConfirmation();
            this.vwEventCommon.setEvent(this.confirmation);
        }
        if (!this.vwEventCommon.collect()) {
            return false;
        }
        if (!this.collectConfirmedData()) {
            return false;
        }
        if (!this.collectConfirmationData()) {
            return false;
        }
        this.askCommentOnSave |= this.vwEventCommon.askCommentOnSave();
        if (this.getMode() == ISave.SaveMode.SaveAdd) {
            this.askCommentOnSave = false;
        }
        return true;
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new GridLayout(2, true));
        this.cmpConfirmation = new Composite((Composite)this, 0);
        this.cmpConfirmation.setLayoutData((Object)new GridData(1808));
        this.cmpConfirmation.setLayout((Layout)new GridLayout(1, true));
        this.initConfPersonControls();
        this.initConfirmationControls();
        this.vwEventCommon = new VEventCommon(this);
        this.vwEventCommon.setLayoutData(new GridData(1808));
        this.vwEventCommon.setEventType(1);
    }

    private void initConfPersonControls() {
        Group grpConfPerson = new Group(this.cmpConfirmation, 0);
        grpConfPerson.setText(Resources.getString("VConfirmationEdit.grpConfPerson"));
        grpConfPerson.setLayoutData((Object)new GridData(768));
        grpConfPerson.setLayout((Layout)new FillLayout());
        GuiUtil.displayAsMandatory((Control)grpConfPerson);
        this.vwConfPerson = new VPersonData((Composite)grpConfPerson, 0);
    }

    private void initConfirmationControls() {
        Group grpConfirmation = new Group(this.cmpConfirmation, 0);
        grpConfirmation.setText(Resources.getString("VConfirmationEdit.grpConfirmation"));
        grpConfirmation.setLayoutData((Object)new GridData(1808));
        grpConfirmation.setLayout((Layout)new GridLayout(2, false));
        Label lblMarkGrade = new Label((Composite)grpConfirmation, 0);
        lblMarkGrade.setText(Resources.getString("VConfirmationEdit.lblMarkGrade"));
        lblMarkGrade.setLayoutData((Object)new GridData(128));
        this.txtMarkGrade = new Text((Composite)grpConfirmation, 2048);
        this.txtMarkGrade.setTextLimit(10);
    }

    private boolean collectConfirmedData() {
        if (!this.vwConfPerson.collect()) {
            return false;
        }
        if (this.vwConfPerson.getObjectID() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VBaptismEdit.ConfirmedPerson", new Object[0]);
            this.vwConfPerson.setFocus();
            return false;
        }
        this.askCommentOnSave |= Util.compare(this.confirmation.getPersonId(), this.vwConfPerson.getObjectID()) != 0;
        this.confirmation.setPersonId(this.vwConfPerson.getObjectID());
        DomPerson person = this.vwConfPerson.getPerson();
        this.confirmation.setPersonFirstName(person.getFirstName());
        this.confirmation.setPersonLastName(person.getLastName());
        this.confirmation.setPersonCode(person.getCode());
        this.confirmation.setPersonBirthDate(person.getBirthDate());
        return true;
    }

    private boolean collectConfirmationData() {
        String s = Util.c(this.txtMarkGrade.getText());
        this.askCommentOnSave |= Util.compare(s, this.confirmation.getMark()) != 0;
        this.confirmation.setMark(s);
        return true;
    }
}

