/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.dao.MBaptism;
import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.gui.DiffText;
import eelk.koguja.model.DomBaptism;
import eelk.koguja.model.DomBaptismHistory;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.VEventPreview;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VBaptismPreview
extends VEventPreview<DomBaptism, DomBaptismHistory> {
    private String personCongregation;
    private Text txtSurename;
    private Text txtGivenName;
    private Text txtDateOfBirth;
    private Text txtCongregation;
    private DiffText diffLastName;
    private DiffText diffFirstName;
    private DiffText diffDateOfBirth;

    public VBaptismPreview(Composite parent) {
        this(parent, 0);
    }

    public VBaptismPreview(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected int getEventType() {
        return 0;
    }

    @Override
    protected Composite getSpecificPane(Composite parent, int style) {
        Composite specificPane = new Composite(parent, style);
        specificPane.setLayout((Layout)new FillLayout());
        Group grpIndividual = new Group(specificPane, 0);
        grpIndividual.setText(Resources.getString("VBaptismPreview.grpIndividual"));
        grpIndividual.setLayout((Layout)new GridLayout(2, false));
        Label lblSurename = new Label((Composite)grpIndividual, 0);
        lblSurename.setText(Resources.getString("VBaptismPreview.lblSurename"));
        lblSurename.setLayoutData((Object)new GridData(128));
        this.txtSurename = new Text((Composite)grpIndividual, 2052);
        this.txtSurename.setLayoutData((Object)new GridData(768));
        this.txtSurename.setEditable(false);
        Label lblGivenName = new Label((Composite)grpIndividual, 0);
        lblGivenName.setText(Resources.getString("VBaptismPreview.lblGivenName"));
        lblGivenName.setLayoutData((Object)new GridData(128));
        this.txtGivenName = new Text((Composite)grpIndividual, 2052);
        this.txtGivenName.setLayoutData((Object)new GridData(768));
        this.txtGivenName.setEditable(false);
        Label lblDateOfBirth = new Label((Composite)grpIndividual, 0);
        lblDateOfBirth.setText(Resources.getString("VBaptismPreview.lblDateOfBirth"));
        lblDateOfBirth.setLayoutData((Object)new GridData(128));
        this.txtDateOfBirth = new Text((Composite)grpIndividual, 2052);
        this.txtDateOfBirth.setLayoutData((Object)new GridData(768));
        this.txtDateOfBirth.setEditable(false);
        Label lblCongregation = new Label((Composite)grpIndividual, 0);
        lblCongregation.setText(Resources.getString("VBaptismPreview.lblCongregation"));
        lblCongregation.setLayoutData((Object)new GridData(128));
        this.txtCongregation = new Text((Composite)grpIndividual, 2052);
        this.txtCongregation.setLayoutData((Object)new GridData(768));
        this.txtCongregation.setEditable(false);
        return specificPane;
    }

    @Override
    public void initControls() {
        super.initControls();
        this.diffLastName = new DiffText(this.txtSurename);
        this.diffFirstName = new DiffText(this.txtGivenName);
        this.diffDateOfBirth = new DiffText(this.txtDateOfBirth);
    }

    @Override
    protected void setSelectedObject(Integer objectId) throws SQLException, ObjectNotFound {
        this.selectedObject = MBaptism.instance().get(objectId);
    }

    @Override
    protected List<DomBaptismHistory> getHistoryList() throws SQLException, ObjectNotFound {
        List<DomBaptismHistory> list = MBaptism.instance().getBaptismHistory(this.getObjectID());
        list.add(0, new DomBaptismHistory((DomBaptism)this.selectedObject));
        return list;
    }

    @Override
    public void loadHistory() {
        if (this.historyID == null) {
            return;
        }
        super.loadHistory();
        String newLastName = Util.d(((DomBaptismHistory)this.historicalObject).getPersonLastName());
        String newFirstName = Util.d(((DomBaptismHistory)this.historicalObject).getPersonFirstName());
        String newDateOfBirth = Util.dateToStr(((DomBaptismHistory)this.historicalObject).getPersonBirthDate());
        this.txtSurename.setText(newLastName);
        this.txtGivenName.setText(newFirstName);
        this.txtDateOfBirth.setText(newDateOfBirth);
    }

    @Override
    public void refresh() {
        if (this.getObjectID() == null) {
            return;
        }
        super.refresh();
        DomBaptism baptism = (DomBaptism)this.selectedObject;
        this.setTitle(Util.d(baptism.getPersonLastName()));
        this.txtSurename.setText(Util.d(baptism.getPersonLastName()));
        this.txtGivenName.setText(Util.d(baptism.getPersonFirstName()));
        this.txtDateOfBirth.setText(Util.dateToStr(baptism.getPersonBirthDate()));
        this.txtCongregation.setText(this.personCongregation);
        this.diffLastName.setBaseText(baptism.getPersonLastName());
        this.diffFirstName.setBaseText(baptism.getPersonFirstName());
        this.diffDateOfBirth.setBaseText(Util.dateToStr(baptism.getPersonBirthDate()));
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        super.load(p);
        if (this.selectedObject == null) {
            return;
        }
        Integer personCongId = null;
        if (((DomBaptism)this.selectedObject).getPersonId() != null) {
            personCongId = MPersonSwt.instance().getCongregation(((DomBaptism)this.selectedObject).getPersonId());
        }
        this.personCongregation = personCongId == null ? "" : MCongregation.instance().get(personCongId).getName();
    }
}

