/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.Session;
import eelk.koguja.dao.MBaptism;
import eelk.koguja.dao.MRelationship;
import eelk.koguja.events.BusinessObjectManagedEvent;
import eelk.koguja.events.IBusinessObjectManagedListener;
import eelk.koguja.gui.TableEx;
import eelk.koguja.model.DomBaptism;
import eelk.koguja.model.DomParticipant;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.DomRelationship;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.ISave;
import eelk.koguja.view.VEdit;
import eelk.koguja.view.VEventCommon;
import eelk.koguja.view.VPersonData;
import eelk.koguja.viewer.DomLabelProvider;
import eelk.koguja.viewer.DomTableViewer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;

public class VBaptismEdit
extends VEdit
implements IBusinessObjectManagedListener<DomPerson>,
ISelectionChangedListener {
    private DomBaptism baptism;
    private DomBaptism loadedBaptism;
    private boolean askCommentOnSave = true;
    private boolean godparentsManaged = false;
    private List<DomPerson> lstGodParents;
    private DomTableViewer<DomPerson> vwrGodParents;
    private VEventCommon vwEventCommon;
    private Composite cmpBaptism;
    private VPersonData vwBaptized;
    private VPersonData vwGodParent;
    private Button chkIsGodFather;

    public VBaptismEdit(Composite parent) {
        this(parent, 0);
    }

    public VBaptismEdit(Composite parent, int style) {
        super(parent, style);
    }

    public DomBaptism getBaptism() {
        return this.baptism;
    }

    public void setBaptizedPersonId(Integer id) {
        this.vwBaptized.setObjectID(id);
    }

    public boolean askCommentOnSave() {
        return this.askCommentOnSave || this.godparentsManaged;
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        p.beginTask(Resources.getMsgString("Load.Loading"), 7);
        this.setMode(this.getObjectID() == null ? ISave.SaveMode.SaveAdd : ISave.SaveMode.SaveUpdate);
        if (this.getObjectID() != null) {
            this.setMode(ISave.SaveMode.SaveUpdate);
            this.vwEventCommon.setMode(ISave.SaveMode.SaveUpdate);
            this.baptism = MBaptism.instance().get(this.getObjectID());
            this.loadedBaptism = new DomBaptism(this.baptism);
            this.vwEventCommon.setEvent(this.getBaptism());
            this.vwBaptized.setPerson(this.getBaptism().getPersonId(), this.getBaptism().getPersonFirstName(), this.getBaptism().getPersonLastName(), this.getBaptism().getPersonBirthDate(), this.getBaptism().getPersonCode());
            this.lstGodParents = MBaptism.instance().getGodParents(this.getObjectID());
            this.vwEventCommon.setParticipants(MBaptism.instance().getParticipants(this.getObjectID()));
        } else {
            this.setMode(ISave.SaveMode.SaveAdd);
            this.vwEventCommon.setMode(ISave.SaveMode.SaveAdd);
            this.lstGodParents = new ArrayList<DomPerson>();
            this.vwEventCommon.setParticipants(new ArrayList<DomParticipant>());
            this.baptism = new DomBaptism();
            this.baptism.setDocNr(MBaptism.getNextDocNr(Session.congregation().getId()));
            this.vwEventCommon.setEvent(this.baptism);
        }
        p.worked(1);
        this.vwEventCommon.load(p);
        this.vwBaptized.load(p);
        p.worked(1);
        this.askCommentOnSave = false;
        p.done();
    }

    @Override
    public void refresh() {
        this.vwEventCommon.refresh();
        this.vwBaptized.refresh();
        if (this.baptism == null) {
            return;
        }
        this.vwrGodParents.setSource(this.lstGodParents);
        if (this.baptism.isGodFather() != null) {
            this.chkIsGodFather.setSelection(this.baptism.isGodFather().booleanValue());
        }
    }

    public boolean hasChanged() {
        return !this.loadedBaptism.hasEqualFields(this.baptism) || this.godparentsManaged;
    }

    @Override
    public boolean save(IProgressMonitor p) throws SQLException {
        p.beginTask(Resources.getMsgString("Save.Saving"), 3 + this.lstGodParents.size());
        if (this.getMode().equals((Object)ISave.SaveMode.SaveAdd)) {
            this.setObjectID(MBaptism.instance().create(this.baptism));
        } else if (this.getMode().equals((Object)ISave.SaveMode.SaveUpdate)) {
            MBaptism.instance().modify(this.baptism);
        }
        p.worked(1);
        MBaptism.instance().setParticipants(this.getObjectID(), this.vwEventCommon.getParticipants());
        p.worked(1);
        MBaptism.instance().setGodParents(this.getObjectID(), this.lstGodParents);
        p.worked(1);
        for (DomPerson godParent : this.lstGodParents) {
            if (this.getBaptism().getPersonId().intValue() != godParent.getId()) {
                List<DomRelationship> rels = MRelationship.listMyRelationships(this.getBaptism().getPersonId());
                boolean createGodParentRS = true;
                for (DomRelationship relationship : rels) {
                    if (relationship.getTypeId() != 4 || (relationship.getPerson1Id() != this.getBaptism().getPersonId() || relationship.getPerson2Id().intValue() != godParent.getId()) && (relationship.getPerson2Id() != this.getBaptism().getPersonId() || relationship.getPerson1Id().intValue() != godParent.getId())) continue;
                    createGodParentRS = false;
                    break;
                }
                if (createGodParentRS) {
                    DomRelationship r = new DomRelationship();
                    r.setPerson1Id(godParent.getId());
                    r.setPerson2Id(this.getBaptism().getPersonId());
                    r.setTypeId(4);
                    r.setStartDate(this.getBaptism().getEventDate());
                    MRelationship.instance().set(r);
                }
            }
            p.worked(1);
        }
        p.done();
        if (this.objectID >= 0) {
            this.setMode(ISave.SaveMode.SaveUpdate);
        }
        return this.objectID >= 0;
    }

    @Override
    public boolean collect() {
        if (this.baptism == null) {
            this.baptism = new DomBaptism();
            this.vwEventCommon.setEvent(this.baptism);
        }
        if (!this.vwEventCommon.collect()) {
            return false;
        }
        if (!this.collectBaptizedData()) {
            return false;
        }
        if (!this.collectBaptismData()) {
            return false;
        }
        this.askCommentOnSave |= this.vwEventCommon.askCommentOnSave();
        if (this.getMode() == ISave.SaveMode.SaveAdd) {
            this.askCommentOnSave = false;
        }
        return true;
    }

    @Override
    public void businessObjectManaged(BusinessObjectManagedEvent<DomPerson> e) {
        if (this.vwGodParent == e.getSource()) {
            this.manageGodParents(e);
        }
    }

    @Override
    public void selectionChanged(SelectionChangedEvent e) {
        if (this.vwrGodParents.getViewer() == e.getSource()) {
            this.vwGodParent.setPerson((DomPerson)this.vwrGodParents.getSelectedObject());
        }
    }

    protected void manageGodParents(BusinessObjectManagedEvent<DomPerson> e) {
        this.godparentsManaged = true;
        boolean setSource = false;
        DomPerson person = e.getBusinessObject();
        switch (e.getEventType()) {
            case 1: {
                if (this.lstGodParents.contains(e.getBusinessObject())) break;
                setSource = this.lstGodParents.add(e.getBusinessObject());
                break;
            }
            case 2: {
                setSource = this.lstGodParents.remove(e.getBusinessObject());
                person = null;
                break;
            }
            case 4: {
                return;
            }
        }
        if (setSource) {
            this.vwrGodParents.setSource(this.lstGodParents);
        }
        if (person != null) {
            this.vwrGodParents.setSelectedObject(person.getId());
        }
        this.vwGodParent.setPerson((DomPerson)this.vwrGodParents.getSelectedObject());
    }

    private boolean collectBaptizedData() {
        if (!this.vwBaptized.collect()) {
            return false;
        }
        if (this.vwBaptized.getObjectID() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VBaptismEdit.BaptizedPerson", new Object[0]);
            this.vwBaptized.setFocus();
            return false;
        }
        this.askCommentOnSave |= Util.compare(this.baptism.getPersonId(), this.vwBaptized.getObjectID()) != 0;
        this.baptism.setPersonId(this.vwBaptized.getObjectID());
        DomPerson person = this.vwBaptized.getPerson();
        this.baptism.setPersonFirstName(person.getFirstName());
        this.baptism.setPersonLastName(person.getLastName());
        this.baptism.setPersonCode(person.getCode());
        this.baptism.setPersonBirthDate(person.getBirthDate());
        if (this.getMode() == ISave.SaveMode.SaveAdd) {
            boolean baptismPreformed = false;
            try {
                baptismPreformed = MBaptism.getBaptismForPerson(this.baptism.getPersonId()) != null;
            }
            catch (SQLException ex) {
                baptismPreformed = false;
            }
            if (baptismPreformed && !GuiUtil.confirmationDialog(this.getShell(), "Err.VEventCommon.EventExists")) {
                return false;
            }
        }
        return true;
    }

    private boolean collectBaptismData() {
        this.askCommentOnSave |= Util.compare(this.baptism.isGodFather(), this.chkIsGodFather.getSelection()) != 0;
        this.baptism.setIsGodFather(this.chkIsGodFather.getSelection());
        return true;
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new GridLayout(2, true));
        this.cmpBaptism = new Composite((Composite)this, 0);
        this.cmpBaptism.setLayoutData((Object)new GridData(1808));
        this.cmpBaptism.setLayout((Layout)new GridLayout(1, true));
        this.initBaptizedControls();
        this.initGodParentsControls();
        this.initBaptismControls();
        this.vwEventCommon = new VEventCommon(this);
        this.vwEventCommon.setLayoutData(new GridData(1808));
        this.vwEventCommon.setEventType(0);
    }

    private void initBaptizedControls() {
        Group grpBaptized = new Group(this.cmpBaptism, 0);
        grpBaptized.setText(Resources.getString("VBaptismEdit.grpBabtized"));
        grpBaptized.setLayoutData((Object)new GridData(768));
        grpBaptized.setLayout((Layout)new FillLayout());
        GuiUtil.displayAsMandatory((Control)grpBaptized);
        this.vwBaptized = new VPersonData((Composite)grpBaptized);
    }

    private void initGodParentsControls() {
        Group grpGodParents = new Group(this.cmpBaptism, 0);
        grpGodParents.setText(Resources.getString("VBaptismEdit.grpGodParents"));
        grpGodParents.setLayoutData((Object)new GridData(1808));
        grpGodParents.setLayout((Layout)new GridLayout(1, true));
        this.vwGodParent = new VPersonData((Composite)grpGodParents, false, false, 1);
        this.vwGodParent.setLayoutData(new GridData(768));
        this.vwGodParent.addBusinessObjectListener(this);
        TableEx tblGodParents = new TableEx((Composite)grpGodParents, 67584);
        tblGodParents.setHeaderVisible(true);
        tblGodParents.setLayoutData(new GridData(1808));
        tblGodParents.setLinesVisible(true);
        TableColumn colGodParentName = new TableColumn(tblGodParents.getTable(), 0);
        colGodParentName.setText(Resources.getString("VBaptismEdit.colGodParentName"));
        this.vwrGodParents = new DomTableViewer(tblGodParents.getTable(), this.getGodParentsLabelProvider());
        this.vwrGodParents.getViewer().addSelectionChangedListener(this);
        this.vwrGodParents.packColumns();
    }

    private void initBaptismControls() {
        Group grpBaptism = new Group(this.cmpBaptism, 0);
        grpBaptism.setText(Resources.getString("VBaptismEdit.grpBaptism"));
        grpBaptism.setLayoutData((Object)new GridData(1808));
        grpBaptism.setLayout((Layout)new RowLayout());
        this.chkIsGodFather = new Button((Composite)grpBaptism, 32);
        this.chkIsGodFather.setText(Resources.getString("VBaptismEdit.chkIsGodFather"));
        GuiUtil.displayAsMandatory((Control)this.chkIsGodFather);
    }

    private ITableLabelProvider getGodParentsLabelProvider() {
        return new DomLabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (element == null) {
                    return "";
                }
                DomPerson person = (DomPerson)element;
                switch (columnIndex) {
                    case 0: {
                        return person.toString();
                    }
                }
                return "";
            }
        };
    }
}

