/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.model.DomAddress;
import eelk.koguja.model.DomPersonAddress;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.seq.SeqGetRelativeAddress;
import eelk.koguja.seq.SeqModifyAddressValidity;
import eelk.koguja.seq.SeqModifyPersonAddress;
import eelk.koguja.seq.SeqNewAddress;
import eelk.koguja.seq.SeqRemoveAddress;
import eelk.koguja.seq.SeqViewPersonAddress;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Resources;
import eelk.koguja.view.VEdit;
import eelk.koguja.viewer.DomListViewer;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class VAddressList
extends VEdit
implements SelectionListener {
    public static Logger logger = Logger.getLogger(SeqRemoveAddress.class);
    private Integer preCongId = null;
    private int nextId = 0;
    private SeqNewAddress seqNewAddress;
    private SeqModifyPersonAddress seqModifyAddress;
    private SeqRemoveAddress seqRemoveAddress;
    private SeqGetRelativeAddress seqGetRelativeAddress;
    private SeqModifyAddressValidity seqModifyValidity;
    private SeqViewPersonAddress seqViewAddress;
    private List<DomPersonAddress> addresses;
    private DomListViewer<DomPersonAddress> vwrAddresses;
    private org.eclipse.swt.widgets.List lstAddresses;
    private Button btnNew;
    private Button btnEdit;
    private Button btnRemove;
    private Button btnAddFromRelative;
    private Button btnSetValidity;
    private Button btnViewAddress;

    public VAddressList(Composite parent) {
        super(parent);
    }

    public List<DomPersonAddress> getAddressList() {
        return this.vwrAddresses.getSource();
    }

    public void setPrefillCong(Integer value) {
        this.preCongId = value;
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        if (this.getObjectID() == null) {
            this.addresses = new ArrayList<DomPersonAddress>();
            return;
        }
        this.addresses = MPersonSwt.getPersonAddresses(this.getObjectID());
    }

    @Override
    public void refresh() {
        this.vwrAddresses.setSource(this.addresses);
    }

    @Override
    public boolean save(IProgressMonitor p) throws SQLException {
        return false;
    }

    @Override
    public boolean collect() {
        return false;
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.btnNew == e.getSource()) {
            this.createAddress();
        } else if (this.btnEdit == e.getSource()) {
            this.modifyAddress();
        } else if (this.btnRemove == e.getSource()) {
            this.removeAddress();
        } else if (this.btnAddFromRelative == e.getSource()) {
            this.getFromRelative();
        } else if (this.btnSetValidity == e.getSource()) {
            this.modifyValidity();
        } else if (this.btnViewAddress == e.getSource()) {
            this.viewAddress();
        } else if (this.lstAddresses == e.getSource()) {
            this.updateButtonsEnabledState();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new GridLayout(1, false));
        Label lblAddresses = new Label((Composite)this, 0);
        lblAddresses.setText(Resources.getString("VAddressList.lblAddresses"));
        lblAddresses.setLayoutData((Object)new GridData(32));
        this.lstAddresses = new org.eclipse.swt.widgets.List((Composite)this, 2816);
        this.lstAddresses.setLayoutData((Object)new GridData(1808));
        this.lstAddresses.addSelectionListener((SelectionListener)this);
        this.vwrAddresses = new DomListViewer(this.lstAddresses);
        Composite cmpManageAddresses = new Composite((Composite)this, 0);
        cmpManageAddresses.setLayoutData((Object)new GridData(32));
        cmpManageAddresses.setLayout((Layout)new GridLayout(3, true));
        this.btnNew = new Button(cmpManageAddresses, 0);
        this.btnNew.setText(Resources.getGenString("New"));
        this.btnNew.setLayoutData((Object)new GridData(256));
        this.btnNew.addSelectionListener((SelectionListener)this);
        this.btnEdit = new Button(cmpManageAddresses, 0);
        this.btnEdit.setText(Resources.getGenString("Edit"));
        this.btnEdit.setLayoutData((Object)new GridData(256));
        this.btnEdit.addSelectionListener((SelectionListener)this);
        this.btnRemove = new Button(cmpManageAddresses, 0);
        this.btnRemove.setText(Resources.getGenString("Remove"));
        this.btnRemove.setLayoutData((Object)new GridData(256));
        this.btnRemove.addSelectionListener((SelectionListener)this);
        this.btnAddFromRelative = new Button(cmpManageAddresses, 0);
        this.btnAddFromRelative.setText(Resources.getString("VAddressList.btnAddFromRelative"));
        this.btnAddFromRelative.setLayoutData((Object)new GridData(256));
        this.btnAddFromRelative.addSelectionListener((SelectionListener)this);
        this.btnSetValidity = new Button(cmpManageAddresses, 0);
        this.btnSetValidity.setText(Resources.getString("VAddressList.btnSetValidity"));
        this.btnSetValidity.setLayoutData((Object)new GridData(256));
        this.btnSetValidity.addSelectionListener((SelectionListener)this);
        this.btnViewAddress = new Button(cmpManageAddresses, 0);
        this.btnViewAddress.setText(Resources.getString("VAddressList.btnViewAddress"));
        this.btnViewAddress.setLayoutData((Object)new GridData(256));
        this.btnViewAddress.addSelectionListener((SelectionListener)this);
        this.updateButtonsEnabledState();
    }

    private void updateButtonsEnabledState() {
        boolean enabled = this.vwrAddresses.getSelectedObject() != null;
        this.btnEdit.setEnabled(enabled);
        this.btnRemove.setEnabled(enabled);
        this.btnSetValidity.setEnabled(enabled);
        this.btnViewAddress.setEnabled(enabled);
    }

    private void createAddress() {
        if (this.seqNewAddress == null) {
            this.seqNewAddress = new SeqNewAddress(this.getShell());
        }
        this.seqNewAddress.setPrefillCong(this.preCongId);
        if (Sequence.execSequence(this.seqNewAddress).equals((Object)Sequence.SeqResult.SeqCompleted)) {
            this.addNewAddress(this.seqNewAddress.getAddress());
        }
    }

    private void addNewAddress(DomAddress addr) {
        DomPersonAddress address = new DomPersonAddress(this.getObjectID() == null ? -1 : this.getObjectID(), addr);
        address.setId(--this.nextId);
        this.addresses.add(address);
        this.vwrAddresses.setSource(this.addresses);
        this.vwrAddresses.setSelectedObject(address.getId());
        this.vwrAddresses.getViewer().refresh();
        this.updateButtonsEnabledState();
    }

    private void modifyAddress() {
        if (this.vwrAddresses.getSelectedObject() == null) {
            return;
        }
        if (this.seqModifyAddress == null) {
            this.seqModifyAddress = new SeqModifyPersonAddress(this.getShell());
        }
        this.seqModifyAddress.setAddress(((DomPersonAddress)this.vwrAddresses.getSelectedObject()).getAddress());
        if (Sequence.execSequence(this.seqModifyAddress).equals((Object)Sequence.SeqResult.SeqCompleted)) {
            ((DomPersonAddress)this.vwrAddresses.getSelectedObject()).setAddress(this.seqModifyAddress.getAddress());
            this.vwrAddresses.getViewer().refresh();
        }
        this.updateButtonsEnabledState();
    }

    private void removeAddress() {
        if (this.vwrAddresses.getSelectedObject() == null) {
            return;
        }
        if (this.seqRemoveAddress == null) {
            this.seqRemoveAddress = new SeqRemoveAddress(this.getShell());
        }
        this.seqRemoveAddress.setAddress(((DomPersonAddress)this.vwrAddresses.getSelectedObject()).getAddress());
        this.seqRemoveAddress.setPersonId(this.getObjectID());
        if (Sequence.execSequence(this.seqRemoveAddress).equals((Object)Sequence.SeqResult.SeqCompleted)) {
            this.vwrAddresses.getSource().remove(this.vwrAddresses.getSelectedObject());
            this.vwrAddresses.getViewer().refresh();
        }
        this.updateButtonsEnabledState();
    }

    private void getFromRelative() {
        if (this.seqGetRelativeAddress == null) {
            this.seqGetRelativeAddress = new SeqGetRelativeAddress(this.getShell());
        }
        this.seqGetRelativeAddress.setPersonId(this.getObjectID());
        if (Sequence.execSequence(this.seqGetRelativeAddress).equals((Object)Sequence.SeqResult.SeqCompleted)) {
            this.addNewAddress(this.seqGetRelativeAddress.getAddress());
        }
    }

    private void modifyValidity() {
        if (this.vwrAddresses.getSelectedObject() == null) {
            return;
        }
        if (this.seqModifyValidity == null) {
            this.seqModifyValidity = new SeqModifyAddressValidity(this.getShell());
        }
        DomPersonAddress address = (DomPersonAddress)this.vwrAddresses.getSelectedObject();
        this.seqModifyValidity.setAddress(address.getAddress());
        this.seqModifyValidity.setValidFrom(address.getValidFrom());
        this.seqModifyValidity.setValidTo(address.getValidTo());
        if (Sequence.execSequence(this.seqModifyValidity).equals((Object)Sequence.SeqResult.SeqCompleted)) {
            Date date = this.seqModifyValidity.getValidFrom() == null ? null : new Date(this.seqModifyValidity.getValidFrom().getTime());
            address.setValidFrom(date);
            date = this.seqModifyValidity.getValidTo() == null ? null : new Date(this.seqModifyValidity.getValidTo().getTime());
            address.setValidTo(date);
            this.vwrAddresses.getViewer().refresh();
        }
        this.updateButtonsEnabledState();
    }

    private void viewAddress() {
        if (this.vwrAddresses.getSelectedObject() == null) {
            return;
        }
        if (this.seqViewAddress == null) {
            this.seqViewAddress = new SeqViewPersonAddress(this.getShell());
        }
        DomPersonAddress address = (DomPersonAddress)this.vwrAddresses.getSelectedObject();
        this.seqViewAddress.setValidFrom(address.getValidFrom());
        this.seqViewAddress.setValidTo(address.getValidTo());
        this.seqViewAddress.setAddress(((DomPersonAddress)this.vwrAddresses.getSelectedObject()).getAddress());
        if (Sequence.execSequence(this.seqViewAddress).equals((Object)Sequence.SeqResult.SeqCompleted)) {
            ((DomPersonAddress)this.vwrAddresses.getSelectedObject()).setAddress(this.seqViewAddress.getAddress());
            this.vwrAddresses.getViewer().refresh();
        }
        this.updateButtonsEnabledState();
    }
}

