/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.view;

import eelk.koguja.dao.MAddress;
import eelk.koguja.dao.MCongregation;
import eelk.koguja.model.DomAddress;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import eelk.koguja.view.ISave;
import eelk.koguja.view.VEdit;
import java.sql.SQLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class VAddressEdit
extends VEdit {
    private DomAddress address;
    private boolean skipLoad = false;
    private boolean isCongregationAddress = false;
    private boolean forceCreate = false;
    private Integer preCongId = null;
    private Text txtCountry;
    private Text txtCounty;
    private Text txtCity;
    private Text txtStreet;
    private Text txtHouseNo;
    private Text txtPostCode;
    private Text txtPhone;
    private Label lblRemark;
    private Text txtRemark;

    public VAddressEdit(Composite parent) {
        this(parent, 0);
    }

    public VAddressEdit(Composite parent, int style) {
        super(parent, style);
    }

    public DomAddress getAddress() {
        return this.address;
    }

    public void setAddress(DomAddress value) {
        this.skipLoad = true;
        this.address = value;
    }

    public boolean isCongregationAddress() {
        return this.isCongregationAddress;
    }

    public void setCongregationAddress(boolean value) {
        if (this.isCongregationAddress == value) {
            return;
        }
        this.isCongregationAddress = value;
        this.lblRemark.setText(Resources.getString(this.isCongregationAddress ? "VAddAddress.lblRegCode" : "VAddAddress.lblRemark"));
    }

    public void forceCreate() {
        this.forceCreate = true;
    }

    public void setPrefillCong(Integer value) {
        this.preCongId = value;
    }

    @Override
    public void load(IProgressMonitor p) throws SQLException, ObjectNotFound {
        if (this.skipLoad) {
            return;
        }
        if (this.getObjectID() != null) {
            this.setMode(ISave.SaveMode.SaveUpdate);
            this.address = MAddress.instance().get(this.getObjectID());
        } else {
            this.setMode(ISave.SaveMode.SaveAdd);
            this.address = new DomAddress();
            this.address.setCountry("Eesti");
            if (this.preCongId != null) {
                try {
                    DomCongregation cong = MCongregation.instance().get(this.preCongId);
                    if (cong.getAddressId() != null) {
                        DomAddress adrs = MAddress.instance().get(cong.getAddressId());
                        this.address.setCity(adrs.getCity());
                        this.address.setCounty(adrs.getCounty());
                        this.address.setCountry(adrs.getCountry());
                    }
                }
                catch (SQLException sQLException) {
                }
                catch (ObjectNotFound objectNotFound) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void refresh() {
        if (this.address == null) {
            return;
        }
        this.txtCountry.setText(Util.d(this.address.getCountry()));
        this.txtCounty.setText(Util.d(this.address.getCounty()));
        this.txtCity.setText(Util.d(this.address.getCity()));
        this.txtStreet.setText(Util.d(this.address.getStreet()));
        this.txtHouseNo.setText(Util.d(this.address.getHouse()));
        this.txtPostCode.setText(Util.d(this.address.getPostcode()));
        this.txtPhone.setText(Util.d(this.address.getPhone()));
        this.txtRemark.setText(Util.d(this.address.getComment()));
    }

    @Override
    public boolean save(IProgressMonitor p) throws SQLException {
        if (this.getMode().equals((Object)ISave.SaveMode.SaveAdd) || this.forceCreate) {
            return MAddress.instance().create(this.address) > 0;
        }
        if (this.getMode().equals((Object)ISave.SaveMode.SaveUpdate)) {
            MAddress.instance().modify(this.address);
            return true;
        }
        return false;
    }

    @Override
    public boolean collect() {
        if (this.address == null) {
            this.address = new DomAddress();
        }
        this.address.setStreet(Util.c(this.txtStreet.getText()));
        this.address.setHouse(Util.c(this.txtHouseNo.getText()));
        this.address.setPostcode(Util.c(this.txtPostCode.getText()));
        if (this.address.getPostcode() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VAddressEdit.PostCode", new Object[0]);
            this.txtPostCode.setFocus();
            return false;
        }
        this.address.setCity(Util.c(this.txtCity.getText()));
        if (this.address.getCity() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VAddressEdit.City", new Object[0]);
            this.txtCity.setFocus();
            return false;
        }
        this.address.setCounty(Util.c(this.txtCounty.getText()));
        this.address.setCountry(Util.c(this.txtCountry.getText()));
        if (this.address.getCountry() == null) {
            GuiUtil.informationDialog(this.getShell(), "Err.VAddressEdit.Country", new Object[0]);
            this.txtCountry.setFocus();
            return false;
        }
        this.address.setPhone(Util.c(this.txtPhone.getText()));
        this.address.setComment(Util.c(this.txtRemark.getText()));
        return true;
    }

    @Override
    protected void initControls() {
        this.setLayout((Layout)new GridLayout(2, false));
        Label lblStreet = new Label((Composite)this, 0);
        lblStreet.setText(Resources.getString("VAddAddress.lblStreet"));
        lblStreet.setLayoutData((Object)new GridData(128));
        this.txtStreet = new Text((Composite)this, 2048);
        this.txtStreet.setLayoutData((Object)new GridData(768));
        this.txtStreet.setTextLimit(240);
        Label lblHouseNo = new Label((Composite)this, 0);
        lblHouseNo.setText(Resources.getString("VAddAddress.lblHouseNo"));
        lblHouseNo.setLayoutData((Object)new GridData(128));
        lblHouseNo.setVisible(false);
        this.txtHouseNo = new Text((Composite)this, 2048);
        this.txtHouseNo.setTextLimit(240);
        this.txtHouseNo.setLayoutData((Object)new GridData(768));
        Label lblPostCode = new Label((Composite)this, 0);
        lblPostCode.setText(Resources.getString("VAddAddress.lblPostCode"));
        lblPostCode.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblPostCode);
        Composite cmp = new Composite((Composite)this, 0);
        GridLayout grlayout = new GridLayout(3, true);
        grlayout.marginLeft = -5;
        grlayout.marginRight = -5;
        grlayout.marginTop = -5;
        grlayout.marginBottom = -5;
        cmp.setLayout((Layout)grlayout);
        this.txtPostCode = new Text(cmp, 2048);
        this.txtPostCode.setTextLimit(240);
        Label lblCity = new Label(cmp, 0);
        lblCity.setText(Resources.getString("VAddAddress.lblCity"));
        lblCity.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblCity);
        this.txtCity = new Text(cmp, 2048);
        this.txtCity.setTextLimit(240);
        Label lblCounty = new Label((Composite)this, 0);
        lblCounty.setText(Resources.getString("VAddAddress.lblCounty"));
        lblCounty.setLayoutData((Object)new GridData(128));
        cmp = new Composite((Composite)this, 0);
        grlayout = new GridLayout(3, true);
        grlayout.marginLeft = -5;
        grlayout.marginRight = -5;
        grlayout.marginTop = -5;
        grlayout.marginBottom = -5;
        cmp.setLayout((Layout)grlayout);
        this.txtCounty = new Text(cmp, 2048);
        this.txtCounty.setTextLimit(240);
        Label lblCountry = new Label(cmp, 0);
        lblCountry.setText(Resources.getString("VAddAddress.lblCountry"));
        lblCountry.setLayoutData((Object)new GridData(128));
        GuiUtil.displayAsMandatory((Control)lblCountry);
        this.txtCountry = new Text(cmp, 2048);
        this.txtCountry.setTextLimit(240);
        Label lblPhone = new Label((Composite)this, 0);
        lblPhone.setText(Resources.getString("VAddAddress.lblPhone"));
        lblPhone.setLayoutData((Object)new GridData(128));
        this.txtPhone = new Text((Composite)this, 2048);
        this.txtPhone.setTextLimit(240);
        this.lblRemark = new Label((Composite)this, 0);
        this.lblRemark.setText(Resources.getString("VAddAddress.lblRemark"));
        this.lblRemark.setLayoutData((Object)new GridData(256));
        this.lblRemark.setAlignment(131072);
        this.txtRemark = new Text((Composite)this, 2048);
        this.txtRemark.setLayoutData((Object)new GridData(768));
        this.txtRemark.setTextLimit(240);
    }
}

