/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.util;

import java.sql.SQLException;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public interface iExceptionHandler {
    public static final int STACK_TRACE_LEVEL = 15;

    public static void handleException(Throwable t, Logger logger, iExceptionHandler eh, String message, Object ... arguments) {
        if (t instanceof SQLException) {
            iExceptionHandler.handleSQLException((SQLException)t, logger, eh, message, arguments);
        } else {
            iExceptionHandler.handleException(t, logger, true, eh, message, arguments);
        }
    }

    public static void handleSQLException(SQLException ex, Logger logger, iExceptionHandler eh, String message, Object ... arguments) {
        String QUERY_CANCELLED = "57014";
        boolean showMessage = !ex.getSQLState().equals("57014");
        iExceptionHandler.handleException((Throwable)ex, logger, showMessage, eh, message, arguments);
    }

    public static void handleException(Throwable t, Logger logger, boolean showMessage, iExceptionHandler eh, String message, Object ... arguments) {
        StringBuffer mLog = new StringBuffer(MessageFormat.format(message, arguments));
        StringBuffer mDisplay = new StringBuffer(MessageFormat.format(message, arguments));
        mLog.append(" [").append(t.getMessage()).append("]");
        mDisplay.append("\n\n").append(t.getMessage());
        iExceptionHandler.addTrace(t, mLog);
        Throwable cause = t.getCause();
        if (cause != null) {
            mLog.append(" Caused By [").append(cause.getMessage()).append("]");
            iExceptionHandler.addTrace(cause, mLog);
            mDisplay.append("\n Caused By ").append(cause.getMessage());
        }
        logger.error(mLog);
        if (showMessage && eh != null) {
            eh.showMessage(mDisplay.toString());
        }
        System.gc();
    }

    public static void addTrace(Throwable t, StringBuffer a) {
        StackTraceElement[] st = t.getStackTrace();
        if (st != null) {
            for (int k = 0; k < st.length && k < 15; ++k) {
                if (st[k] == null) continue;
                a.append(" [").append(st[k].toString()).append("]");
            }
        }
    }

    public void showMessage(String var1);

    public void Ex(Throwable var1, Logger var2, String var3, Object ... var4);
}

