/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.util;

import eelk.koguja.util.Util;
import eelk.koguja.util.iExceptionHandler;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class Resources {
    public static final String CANNOT_LOAD_RESOURCES = "Unable to load resources! Program will shut down immediately.";
    public static final String MISSING_STRING_VALUE = "?";
    private static final String RESOURCES_FILE = "eelk/koguja/lang/koguja_et.txt";
    private static final String DEFAULT_ERROR_CAPTION = "Error";
    public static final Logger logger = Logger.getLogger(Resources.class);
    private static PropertyResourceBundle resources;
    private static final String ERR_MSG_KEY = "ErrorCaption";
    private static final String INFO_MSG_KEY = "InformationCaption";
    private static final String WARN_MSG_KEY = "WarningCaption";
    private static final String QST_MSG_KEY = "QuestionCaption";
    private static final String GENERAL_STRING = "Gen";
    private static final String ERROR_STRING = "Err";
    private static final String MESSAGE_STRING = "Msg";

    public static boolean loadResources() {
        return Resources.loadResources(RESOURCES_FILE);
    }

    public static boolean loadResources(String fileName) {
        try {
            URL t = Util.getResource(fileName);
            resources = new PropertyResourceBundle(t.openStream());
        }
        catch (Exception ex) {
            iExceptionHandler.handleException((Throwable)ex, logger, null, "Failed to load resource file {0}", fileName);
            return false;
        }
        return true;
    }

    public static String getString(String key) {
        if (resources == null) {
            return MISSING_STRING_VALUE;
        }
        try {
            return resources.getString(key);
        }
        catch (MissingResourceException e) {
            return MISSING_STRING_VALUE;
        }
    }

    public static String getGenString(String key) {
        return Resources.getString("Gen." + key);
    }

    public static String getErrString(String key) {
        return Resources.getString("Err." + key);
    }

    public static String getErrMsgTitle() {
        String result = Resources.getGenString(ERR_MSG_KEY);
        return result.equals(MISSING_STRING_VALUE) ? DEFAULT_ERROR_CAPTION : result;
    }

    public static String getInfoMsgTitle() {
        return Resources.getGenString(INFO_MSG_KEY);
    }

    public static String getWarnMsgTitle() {
        return Resources.getGenString(WARN_MSG_KEY);
    }

    public static String getQuestMsgTitle() {
        return Resources.getGenString(QST_MSG_KEY);
    }

    public static String getMsgString(String key) {
        return Resources.getString("Msg." + key);
    }

    public static ResourceBundle getBundle() {
        return resources;
    }
}

