/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.util;

import java.util.Date;
import java.util.GregorianCalendar;

public class PersonCode {
    private PersonCode() {
    }

    public static boolean isCorrect(String code) {
        if (code == null) {
            return false;
        }
        if (code.length() != 11) {
            return false;
        }
        for (char ch : code.toCharArray()) {
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        if (code.charAt(0) == '0') {
            return false;
        }
        int s1 = 0;
        int s2 = 0;
        int w1 = 1;
        int w2 = 3;
        for (int i = 0; i < code.length() - 1; ++i) {
            int k = code.charAt(i) - 48;
            s1 += w1 * k;
            w1 = w1 % 9 + 1;
            s2 += w2 * k;
            w2 = w2 % 9 + 1;
        }
        int chksum = s1 % 11;
        if (chksum == 10) {
            chksum = s2 % 11;
        }
        if (chksum == 10) {
            chksum = 0;
        }
        if (chksum != code.charAt(10) - 48) {
            return false;
        }
        int month = Integer.parseInt(code.substring(3, 5));
        if (month == 0 || month > 12) {
            return false;
        }
        int day = Integer.parseInt(code.substring(5, 7));
        if (day == 0) {
            return false;
        }
        if (month != 2) {
            return day <= 30 || (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) && day <= 31;
        }
        int year = PersonCode.getYear(code);
        return new GregorianCalendar().isLeapYear(year) ? day <= 29 : day <= 28;
    }

    public static int getSex(String code) {
        if (code == null || code.length() == 0) {
            return -1;
        }
        char ch = code.charAt(0);
        if (ch > '0' && ch <= '9') {
            return 1 - (ch - 48 & 1);
        }
        return -1;
    }

    private static int getYear(String code) {
        int y = Integer.parseInt(code.substring(1, 3));
        int c = Integer.parseInt(code.substring(0, 1));
        return y + ((c - 1 >> 1) + 18) * 100;
    }

    public static Date getDate(String code) {
        if (!PersonCode.isCorrect(code)) {
            return null;
        }
        int day = Integer.parseInt(code.substring(5, 7));
        int month = Integer.parseInt(code.substring(3, 5));
        int year = PersonCode.getYear(code);
        return new GregorianCalendar(year, month - 1, day).getTime();
    }
}

