/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.util;

import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

public class ImageFactory {
    private static final Logger logger = Logger.getLogger(ImageFactory.class);
    private static final Map<Integer, Image> imgMap = new HashMap<Integer, Image>();

    public static Image getImage(ImageCollection i) {
        return ImageFactory.getImage(i.id);
    }

    public static ImageDescriptor getImageDescriptor(ImageCollection i) {
        return ImageDescriptor.createFromImage(ImageFactory.getImage(i));
    }

    private static Image getImage(int id) {
        Image i = imgMap.get(id);
        if (i == null) {
            String path = null;
            if (id == 0) {
                path = "images/check.png";
            } else if (id == 1) {
                path = "images/new.png";
            } else if (id == 2) {
                path = "images/edit.png";
            } else if (id == 3) {
                path = "images/view.png";
            } else if (id == 4) {
                path = "images/copy.png";
            } else if (id == 5) {
                path = "images/cut.png";
            } else if (id == 6) {
                path = "images/paste.png";
            } else if (id == 7) {
                path = "images/group.png";
            } else if (id == 8) {
                path = "images/relship.png";
            } else if (id == 9) {
                path = "images/findrel.png";
            } else if (id == 10) {
                path = "images/redx.png";
            } else if (id == 11) {
                path = "images/family.png";
            }
            if (path != null) {
                i = ImageFactory.getImage(path);
            }
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Image getImage(String path) {
        Image image;
        block14: {
            String err = Resources.getErrString("ImageLoad");
            image = null;
            InputStream stream = null;
            stream = Util.getResource(path).openStream();
            image = new Image((Device)GuiUtil.activeDisplay(), stream);
            try {
                stream.close();
            }
            catch (IOException e) {
                SwtExceptionHandler.instance().Ex(e, logger, err, path);
            }
            break block14;
            catch (SWTException e) {
                SwtExceptionHandler.instance().Ex(e, logger, err, path);
                try {
                    stream.close();
                }
                catch (IOException e2) {
                    SwtExceptionHandler.instance().Ex(e2, logger, err, path);
                }
            }
            catch (IOException e2) {
                SwtExceptionHandler.instance().Ex(e2, logger, err, path);
                {
                    catch (Throwable throwable) {
                        try {
                            stream.close();
                        }
                        catch (IOException e3) {
                            SwtExceptionHandler.instance().Ex(e3, logger, err, path);
                        }
                        throw throwable;
                    }
                }
                try {
                    stream.close();
                }
                catch (IOException e4) {
                    SwtExceptionHandler.instance().Ex(e4, logger, err, path);
                }
            }
        }
        return image;
    }

    public static enum ImageCollection {
        CHECK(0),
        NEW(1),
        EDIT(2),
        VIEW(3),
        COPY(4),
        CUT(5),
        PASTE(6),
        GROUP(7),
        RELATIONSHIP(8),
        FINDRELATIVES(9),
        REDX(10),
        FAMILY(11);

        private final int id;

        private ImageCollection(int id) {
            this.id = id;
        }
    }
}

