/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.util;

import eelk.koguja.dlg.DlgMain;
import eelk.koguja.util.MessageResult;
import eelk.koguja.util.Resources;
import eelk.koguja.util.iGuiUtil;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class GuiUtil
implements iGuiUtil {
    private static boolean confirmationDialog(Shell shell, String questionKey, int selectedButtonIndex, Object ... arguments) {
        int btnIndex = selectedButtonIndex != 0 && selectedButtonIndex != 1 ? 0 : selectedButtonIndex;
        String parsedInfo = MessageFormat.format(Resources.getString(questionKey), arguments);
        String[] buttonLabels = new String[]{Resources.getGenString("Yes"), Resources.getGenString("No")};
        MessageDialog dialog = new MessageDialog(shell, Resources.getQuestMsgTitle(), null, parsedInfo, 3, buttonLabels, btnIndex);
        int result = dialog.open();
        return result == 0;
    }

    public static int confirmationDialog(Shell shell, String questionKey, String[] buttons, int selectedButtonIndex, Object ... arguments) {
        int btnIndex = selectedButtonIndex >= buttons.length ? 0 : selectedButtonIndex;
        String parsedInfo = MessageFormat.format(Resources.getString(questionKey), arguments);
        MessageDialog dialog = new MessageDialog(shell, Resources.getQuestMsgTitle(), null, parsedInfo, 3, buttons, btnIndex);
        return dialog.open();
    }

    public static boolean confirmationDialog(Shell shell, String questionKey) {
        return GuiUtil.confirmationDialog(shell, questionKey, 1, new Object[0]);
    }

    public static boolean confirmationDialog(Shell shell, String questionKey, String s) {
        return GuiUtil.confirmationDialog(shell, questionKey, 1, s);
    }

    public static boolean confirmationDialog(Shell shell, String questionKey, String s, Object ... arguments) {
        return GuiUtil.confirmationDialog(shell, questionKey, 1, s, arguments);
    }

    public static void informationDialog(Shell shell, String messageKey, Object ... arguments) {
        String parsedInfo = MessageFormat.format(Resources.getString(messageKey), arguments);
        String[] buttonLabels = new String[]{Resources.getGenString("OK")};
        MessageDialog dialog = new MessageDialog(shell, Resources.getInfoMsgTitle(), null, parsedInfo, 2, buttonLabels, 0);
        dialog.open();
    }

    public static void errorDialog(Shell shell, String message) {
        String[] buttonLabels = new String[]{Resources.getGenString("OK")};
        MessageDialog dialog = new MessageDialog(shell, Resources.getErrMsgTitle(), null, message, 1, buttonLabels, 0);
        dialog.open();
    }

    public static void errorDialog(final String msg) {
        final Display d = DlgMain.instance().getShell().getDisplay();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                GuiUtil.errorDialog(d.getActiveShell(), msg);
            }
        };
        d.syncExec(r);
    }

    public static MessageResult warningDialog(Shell shell, String messageKey, Object ... arguments) {
        String parsedInfo = MessageFormat.format(Resources.getString(messageKey), arguments);
        String[] buttonLabels = new String[]{Resources.getGenString("Yes"), Resources.getGenString("No"), Resources.getGenString("Cancel")};
        MessageDialog dialog = new MessageDialog(shell, Resources.getInfoMsgTitle(), null, parsedInfo, 4, buttonLabels, 0);
        switch (dialog.open()) {
            case 0: {
                return MessageResult.Yes;
            }
            case 1: {
                return MessageResult.No;
            }
            case 2: {
                return MessageResult.Cancel;
            }
        }
        return MessageResult.None;
    }

    public static Shell activeShell() {
        Display d = GuiUtil.activeDisplay();
        Shell s = d.getActiveShell();
        if (s == null) {
            s = new Shell();
        }
        return s;
    }

    public static Display activeDisplay() {
        Display d = Display.getCurrent();
        if (d == null) {
            d = new Display();
        }
        return d;
    }

    public static Executor SwtDisplayExecutor() {
        boolean isAppleOSX = System.getProperty("os.name").contains("Mac");
        if (isAppleOSX) {
            try {
                Class<?> comAppleConcurrentDispatch = Class.forName("com.apple.concurrent.Dispatch");
                Method getInstance = comAppleConcurrentDispatch.getMethod("getInstance", null);
                Object dispatchInstance = getInstance.invoke(null, (Object[])null);
                Method getNonBlockingMainQueueExecutor = dispatchInstance.getClass().getMethod("getNonBlockingMainQueueExecutor", null);
                return (Executor)getNonBlockingMainQueueExecutor.invoke(dispatchInstance, (Object[])null);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return Executors.newSingleThreadExecutor();
            }
        }
        return Executors.newSingleThreadExecutor();
    }

    public static Control findFocusControl() {
        Shell s = GuiUtil.activeShell();
        return GuiUtil.findFocusControl((Composite)s);
    }

    public static Control findFocusControl(Composite w) {
        if (w == null) {
            return null;
        }
        Control[] s = w.getChildren();
        for (int i = 0; i < s.length; ++i) {
            Control t;
            if (s[i].isFocusControl()) {
                return s[i];
            }
            if (!(s[i] instanceof Composite) || (t = GuiUtil.findFocusControl((Composite)s[i])) == null) continue;
            return t;
        }
        return null;
    }

    public static boolean doClipboardOp(ClipboardOp op) {
        if (op == null) {
            return false;
        }
        Control c = GuiUtil.findFocusControl();
        if (c == null) {
            return false;
        }
        if (c instanceof Text) {
            GuiUtil.doClipboardOp(op, (Text)c);
            return true;
        }
        if (c instanceof Table && op == ClipboardOp.SelectAll) {
            ((Table)c).selectAll();
            return true;
        }
        return false;
    }

    public static void doClipboardOp(ClipboardOp op, Text t) {
        if (op == null || t == null) {
            return;
        }
        if (op == ClipboardOp.Cut) {
            t.cut();
        } else if (op == ClipboardOp.Copy) {
            t.copy();
        } else if (op == ClipboardOp.Paste) {
            t.paste();
        } else if (op == ClipboardOp.SelectAll) {
            t.selectAll();
        } else if (op == ClipboardOp.Clear) {
            t.setText("");
        }
    }

    public static void doClipboardOp(ClipboardOp op, Combo t) {
        if (op == null || t == null) {
            return;
        }
        if (op == ClipboardOp.Cut) {
            t.cut();
        } else if (op == ClipboardOp.Copy) {
            t.copy();
        } else if (op == ClipboardOp.Paste) {
            t.paste();
        } else if (op == ClipboardOp.Clear) {
            t.setText("");
        }
    }

    public static boolean focusFirst(Composite c) {
        if (c == null) {
            return false;
        }
        Control[] t = c.getTabList();
        if (t == null || t.length == 0) {
            return false;
        }
        t[0].setFocus();
        return true;
    }

    public static void displayAsMandatory(Control ctrl) {
        FontData fd = ctrl.getFont().getFontData()[0];
        ctrl.setFont(new Font((Device)ctrl.getDisplay(), fd.getName(), fd.getHeight(), 1));
        ctrl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ((Control)e.getSource()).getFont().dispose();
            }
        });
    }

    public static enum ClipboardOp {
        Cut,
        Copy,
        Paste,
        SelectAll,
        Clear;

    }
}

