/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.util;

import eelk.koguja.Session;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.IDbUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import java.sql.CallableStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class DbUtil
implements IDbUtil {
    private static final Logger logger = Logger.getLogger(DbUtil.class);
    private static boolean isSuperuser;
    private static boolean checkUserCong;
    private static boolean checkUserPerson;
    private static boolean checkUserBaptism;
    private static boolean checkUserConfirmation;
    private static boolean checkUserWedding;
    private static boolean checkUserFuneral;
    private static boolean checkUserDonation;

    public static boolean isSuperuser(Shell shell) {
        return DbUtil.isSuperuser(shell, true);
    }

    public static boolean isSuperuser(Shell shell, boolean isErrorRaised) {
        String sql = "{? = call is_superuser()}";
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("CreatingObject"), -1);
                try {
                    CallableStatement cs = Session.prepareCall("{? = call is_superuser()}");
                    cs.registerOutParameter(1, 16);
                    cs.execute();
                    isSuperuser = cs.getBoolean(1);
                    cs.close();
                    p.done();
                }
                catch (SQLException e) {
                    isSuperuser = false;
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Create"), new Object[0]);
                }
            }
        };
        Operation.run(shell, true, r);
        if (!isSuperuser && isErrorRaised) {
            MessageDialog.openInformation(shell, Resources.getInfoMsgTitle(), Resources.getErrString("RestrictedOperation"));
        }
        return isSuperuser;
    }

    public static boolean checkUserCong(final IDbUtil.Permission permission, Shell shell) {
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString(""), -1);
                String sql = "{? = call check_user_cong(?, ?, ?)}";
                try {
                    CallableStatement cs = Session.prepareCall("{? = call check_user_cong(?, ?, ?)}");
                    cs.registerOutParameter(1, 16);
                    cs.setInt(2, permission.getCode());
                    cs.setInt(3, Session.current().getCongregation().getId());
                    cs.setBoolean(4, false);
                    cs.execute();
                    checkUserCong = cs.getBoolean(1);
                    cs.close();
                    p.done();
                }
                catch (SQLException ex) {
                    checkUserCong = false;
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Create"), new Object[0]);
                }
            }
        };
        Operation.run(shell, true, r);
        if (!checkUserCong) {
            String msgKey = "";
            if (permission == IDbUtil.Permission.Read) {
                msgKey = "Err.NoReadAccess.Congregation";
            } else if (permission == IDbUtil.Permission.Write) {
                msgKey = "Err.NoWriteAccess.Congregation";
            } else if (permission == IDbUtil.Permission.Delete) {
                msgKey = "Err.NoDeleteAccess.Congregation";
            } else if (permission == IDbUtil.Permission.Admin) {
                msgKey = "Err.NoAdminAccess.Congregation";
            }
            GuiUtil.informationDialog(shell, msgKey, new Object[0]);
        }
        return checkUserCong;
    }

    public static boolean checkUserPerson(final IDbUtil.Permission permission, final int personId, Shell shell) {
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("Load.PersonAccess"), -1);
                String sql = "{? = call check_user_person(?, ?, ?)}";
                try {
                    CallableStatement cs = Session.prepareCall("{? = call check_user_person(?, ?, ?)}");
                    cs.registerOutParameter(1, 16);
                    cs.setInt(2, permission.getCode());
                    cs.setInt(3, personId);
                    cs.setBoolean(4, false);
                    cs.execute();
                    checkUserPerson = cs.getBoolean(1);
                    cs.close();
                    p.done();
                }
                catch (SQLException ex) {
                    checkUserPerson = false;
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Create"), new Object[0]);
                }
            }
        };
        Operation.run(shell, true, r);
        if (!checkUserPerson) {
            String msgKey = "";
            if (permission == IDbUtil.Permission.Read) {
                msgKey = "Err.NoReadAccess.Person";
            } else if (permission == IDbUtil.Permission.Write) {
                msgKey = "Err.NoWriteAccess.Person";
            } else if (permission == IDbUtil.Permission.Delete) {
                msgKey = "Err.NoDeleteAccess.Person";
            } else if (permission == IDbUtil.Permission.Admin) {
                msgKey = "Err.NoAdminAccess.Person";
            }
            GuiUtil.informationDialog(shell, msgKey, new Object[0]);
        }
        return checkUserPerson;
    }

    public static boolean checkUserBaptism(final IDbUtil.Permission permission, final int baptismId, Shell shell) {
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("Load.BaptismAccess"), -1);
                String sql = "{? = call check_user_baptism(?, ?, ?)}";
                try {
                    CallableStatement cs = Session.prepareCall("{? = call check_user_baptism(?, ?, ?)}");
                    cs.registerOutParameter(1, 16);
                    cs.setInt(2, permission.getCode());
                    cs.setInt(3, baptismId);
                    cs.setBoolean(4, false);
                    cs.execute();
                    checkUserBaptism = cs.getBoolean(1);
                    cs.close();
                    p.done();
                }
                catch (SQLException ex) {
                    checkUserBaptism = false;
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Create"), new Object[0]);
                }
            }
        };
        Operation.run(shell, true, r);
        if (!checkUserBaptism) {
            String msgKey = "";
            if (permission == IDbUtil.Permission.Read) {
                msgKey = "Err.NoReadAccess.Baptism";
            } else if (permission == IDbUtil.Permission.Write) {
                msgKey = "Err.NoWriteAccess.Baptism";
            } else if (permission == IDbUtil.Permission.Delete) {
                msgKey = "Err.NoDeleteAccess.Baptism";
            } else if (permission == IDbUtil.Permission.Admin) {
                msgKey = "Err.NoAdminAccess.Baptism";
            }
            GuiUtil.informationDialog(shell, msgKey, new Object[0]);
        }
        return checkUserBaptism;
    }

    public static boolean checkUserConfirmation(final IDbUtil.Permission permission, final int confirmationId, Shell shell) {
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("Load.ConfirmationAccess"), -1);
                String sql = "{? = call check_user_confirmation(?, ?, ?)}";
                try {
                    CallableStatement cs = Session.prepareCall("{? = call check_user_confirmation(?, ?, ?)}");
                    cs.registerOutParameter(1, 16);
                    cs.setInt(2, permission.getCode());
                    cs.setInt(3, confirmationId);
                    cs.setBoolean(4, false);
                    cs.execute();
                    checkUserConfirmation = cs.getBoolean(1);
                    cs.close();
                    p.done();
                }
                catch (SQLException ex) {
                    checkUserConfirmation = false;
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Create"), new Object[0]);
                }
            }
        };
        Operation.run(shell, true, r);
        if (!checkUserConfirmation) {
            String msgKey = "";
            if (permission == IDbUtil.Permission.Read) {
                msgKey = "Err.NoReadAccess.Confirmation";
            } else if (permission == IDbUtil.Permission.Write) {
                msgKey = "Err.NoWriteAccess.Confirmation";
            } else if (permission == IDbUtil.Permission.Delete) {
                msgKey = "Err.NoDeleteAccess.Confirmation";
            } else if (permission == IDbUtil.Permission.Admin) {
                msgKey = "Err.NoAdminAccess.Confirmation";
            }
            GuiUtil.informationDialog(shell, msgKey, new Object[0]);
        }
        return checkUserConfirmation;
    }

    public static boolean checkUserWedding(final IDbUtil.Permission permission, final int weddingId, Shell shell) {
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("Load.WeddingAccess"), -1);
                String sql = "{? = call check_user_wedding(?, ?, ?)}";
                try {
                    CallableStatement cs = Session.prepareCall("{? = call check_user_wedding(?, ?, ?)}");
                    cs.registerOutParameter(1, 16);
                    cs.setInt(2, permission.getCode());
                    cs.setInt(3, weddingId);
                    cs.setBoolean(4, false);
                    cs.execute();
                    checkUserWedding = cs.getBoolean(1);
                    cs.close();
                    p.done();
                }
                catch (SQLException ex) {
                    checkUserWedding = false;
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Create"), new Object[0]);
                }
            }
        };
        Operation.run(shell, true, r);
        if (!checkUserWedding) {
            String msgKey = "";
            if (permission == IDbUtil.Permission.Read) {
                msgKey = "Err.NoReadAccess.Wedding";
            } else if (permission == IDbUtil.Permission.Write) {
                msgKey = "Err.NoWriteAccess.Wedding";
            } else if (permission == IDbUtil.Permission.Delete) {
                msgKey = "Err.NoDeleteAccess.Wedding";
            } else if (permission == IDbUtil.Permission.Admin) {
                msgKey = "Err.NoAdminAccess.Wedding";
            }
            GuiUtil.informationDialog(shell, msgKey, new Object[0]);
        }
        return checkUserWedding;
    }

    public static boolean checkUserFuneral(final IDbUtil.Permission permission, final int funeralId, Shell shell) {
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("Load.FuneralAccess"), -1);
                String sql = "{? = call check_user_funeral(?, ?, ?)}";
                try {
                    CallableStatement cs = Session.prepareCall("{? = call check_user_funeral(?, ?, ?)}");
                    cs.registerOutParameter(1, 16);
                    cs.setInt(2, permission.getCode());
                    cs.setInt(3, funeralId);
                    cs.setBoolean(4, false);
                    cs.execute();
                    checkUserFuneral = cs.getBoolean(1);
                    cs.close();
                    p.done();
                }
                catch (SQLException ex) {
                    checkUserFuneral = false;
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Create"), new Object[0]);
                }
            }
        };
        Operation.run(shell, true, r);
        if (!checkUserFuneral) {
            String msgKey = "";
            if (permission == IDbUtil.Permission.Read) {
                msgKey = "Err.NoReadAccess.Funeral";
            } else if (permission == IDbUtil.Permission.Write) {
                msgKey = "Err.NoWriteAccess.Funeral";
            } else if (permission == IDbUtil.Permission.Delete) {
                msgKey = "Err.NoDeleteAccess.Funeral";
            } else if (permission == IDbUtil.Permission.Admin) {
                msgKey = "Err.NoAdminAccess.Funeral";
            }
            GuiUtil.informationDialog(shell, msgKey, new Object[0]);
        }
        return checkUserFuneral;
    }

    public static boolean checkUserDonation(final IDbUtil.Permission permission, final int donationId, Shell shell) {
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("Load.DonationAccess"), -1);
                String sql = "{? = call check_user_donation(?, ?, ?)}";
                try {
                    CallableStatement cs = Session.prepareCall("{? = call check_user_donation(?, ?, ?)}");
                    cs.registerOutParameter(1, 16);
                    cs.setInt(2, permission.getCode());
                    cs.setInt(3, donationId);
                    cs.setBoolean(4, false);
                    cs.execute();
                    checkUserDonation = cs.getBoolean(1);
                    cs.close();
                    p.done();
                }
                catch (SQLException ex) {
                    checkUserDonation = false;
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Create"), new Object[0]);
                }
            }
        };
        Operation.run(shell, true, r);
        if (!checkUserDonation) {
            String msgKey = "";
            if (permission == IDbUtil.Permission.Read) {
                msgKey = "Err.NoReadAccess.Donation";
            } else if (permission == IDbUtil.Permission.Write) {
                msgKey = "Err.NoWriteAccess.Donation";
            } else if (permission == IDbUtil.Permission.Delete) {
                msgKey = "Err.NoDeleteAccess.Donation";
            } else if (permission == IDbUtil.Permission.Admin) {
                msgKey = "Err.NoAdminAccess.Donation";
            }
            GuiUtil.informationDialog(shell, msgKey, new Object[0]);
        }
        return checkUserDonation;
    }

    public static String getNextDocNr(String docNr) throws SQLException {
        String sql = "{? = call get_next_doc_nr(?)}";
        CallableStatement cs = Session.prepareCall(sql);
        cs.registerOutParameter(1, 12);
        cs.setString(2, docNr);
        cs.execute();
        String result = cs.getString(1);
        cs.close();
        return result;
    }
}

