/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.GregorianCalendar;

public final class Currencies {
    public static final String CURRENCY_SIGN_EEK = "kr";
    public static final String CURRENCY_SIGN_EUR = "\u20ac";
    private static final BigDecimal EUR_IN_EEK = new BigDecimal("15.6466");

    public static BigDecimal getEurInEek(BigDecimal eur) {
        return eur.multiply(EUR_IN_EEK);
    }

    public static BigDecimal getEekInEur(BigDecimal eek) {
        return eek.divide(EUR_IN_EEK, 2, RoundingMode.HALF_UP);
    }

    public static boolean isEuroDate(Date date) {
        GregorianCalendar firstEuroDate = new GregorianCalendar(2011, 0, 1);
        return date == null || !date.before(firstEuroDate.getTime());
    }

    public static String getCurrencySymbol(Date date) {
        if (Currencies.isEuroDate(date)) {
            return CURRENCY_SIGN_EUR;
        }
        return CURRENCY_SIGN_EEK;
    }
}

