/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class LoggedCallableStatement {
    private static final Logger logger = Logger.getLogger(LoggedCallableStatement.class);
    private final CallableStatement statement;
    private final List<List<Object>> batchParams;
    private final List<Object> params;
    private final String sql;
    private int paramCount;

    public LoggedCallableStatement(CallableStatement statement, String sql) {
        if (statement == null) {
            throw new IllegalArgumentException("CallableStatement is null");
        }
        this.statement = statement;
        this.sql = sql;
        int paramCount = this.count(sql, '?');
        this.params = new ArrayList<Object>(paramCount);
        for (int i = 0; i < paramCount; ++i) {
            this.params.add(null);
        }
        this.batchParams = new ArrayList<List<Object>>();
    }

    private int count(String s, char c) {
        if (s == null) {
            return 0;
        }
        char[] data = s.toCharArray();
        int len = data.length;
        int count = 0;
        for (char datum : data) {
            if (datum != c) continue;
            ++count;
        }
        return count;
    }

    private String replace(String s, char c, List<Object> list) {
        if (s == null) {
            return null;
        }
        if (list == null) {
            return s;
        }
        char[] data = s.toCharArray();
        int len = data.length;
        StringBuilder sb = new StringBuilder();
        Iterator<Object> it = list.iterator();
        for (char datum : data) {
            if (datum == c) {
                if (it.hasNext()) {
                    sb.append(it.next());
                    continue;
                }
                sb.append("null");
                continue;
            }
            sb.append(datum);
        }
        return sb.toString();
    }

    public ResultSet executeQuery() throws SQLException {
        logger.info(this.replace(this.sql, '?', this.params));
        return this.statement.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        logger.info(this.replace(this.sql, '?', this.params));
        return this.statement.executeUpdate();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.params.set(parameterIndex - 1, null);
        this.statement.setNull(parameterIndex, sqlType);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setByte(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setShort(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setLong(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.params.set(parameterIndex - 1, Float.valueOf(x));
        this.statement.setFloat(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setDouble(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setBigDecimal(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setString(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setBytes(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setDate(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setTimestamp(parameterIndex, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setAsciiStream(parameterIndex, x, length);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.params.set(parameterIndex - 1, x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setBinaryStream(parameterIndex, x, length);
    }

    public void clearParameters() throws SQLException {
        this.statement.clearParameters();
        for (int i = 0; i < this.paramCount; ++i) {
            this.params.set(i, null);
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setObject(parameterIndex, x);
    }

    public boolean execute() throws SQLException {
        logger.info(this.replace(this.sql, '?', this.params));
        return this.statement.execute();
    }

    public void addBatch() throws SQLException {
        this.batchParams.add(new ArrayList<Object>(this.params));
        this.statement.addBatch();
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.params.set(parameterIndex - 1, reader);
        this.statement.setCharacterStream(parameterIndex, reader, length);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.params.set(i - 1, x);
        this.statement.setRef(i, x);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.params.set(i - 1, x);
        this.statement.setBlob(i, x);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.params.set(i - 1, x);
        this.statement.setClob(i, x);
    }

    public void setArray(int i, Array x) throws SQLException {
        this.params.set(i - 1, x);
        this.statement.setArray(i, x);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.statement.getMetaData();
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setDate(parameterIndex, x, cal);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.params.set(parameterIndex - 1, x);
        this.statement.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.params.set(parameterIndex, x);
        this.statement.setTimestamp(parameterIndex, x, cal);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.params.set(paramIndex, null);
        this.statement.setNull(paramIndex, sqlType, typeName);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.params.set(parameterIndex, x);
        this.statement.setURL(parameterIndex, x);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.statement.getParameterMetaData();
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        logger.info(sql);
        return this.statement.executeQuery(sql);
    }

    public int executeUpdate(String sql) throws SQLException {
        logger.info(sql);
        return this.statement.executeUpdate(sql);
    }

    public void close() throws SQLException {
        this.statement.close();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.statement.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        this.statement.setMaxRows(max);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.statement.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.statement.setQueryTimeout(seconds);
    }

    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.statement.setCursorName(name);
    }

    public boolean execute(String sql) throws SQLException {
        logger.info(sql);
        return this.statement.execute(sql);
    }

    public ResultSet getResultSet() throws SQLException {
        return this.statement.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    public int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.statement.setFetchDirection(direction);
    }

    public int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.statement.setFetchSize(rows);
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.statement.getResultSetType();
    }

    public void addBatch(String sql) throws SQLException {
        this.statement.addBatch(sql);
    }

    public void clearBatch() throws SQLException {
        this.statement.clearBatch();
        this.batchParams.clear();
    }

    public int[] executeBatch() throws SQLException {
        for (List<Object> l : this.batchParams) {
            logger.info(this.replace(this.sql, '?', l));
        }
        return this.statement.executeBatch();
    }

    public Connection getConnection() throws SQLException {
        return this.statement.getConnection();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.statement.getMoreResults(current);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.statement.getGeneratedKeys();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        logger.info(sql);
        return this.statement.executeUpdate(sql, autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        logger.info(sql);
        return this.statement.executeUpdate(sql, columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        logger.info(sql);
        return this.statement.executeUpdate(sql, columnNames);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        logger.info(sql);
        return this.statement.execute(sql, autoGeneratedKeys);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        logger.info(sql);
        return this.statement.execute(sql, columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        logger.info(sql);
        return this.statement.execute(sql, columnNames);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.statement.getResultSetHoldability();
    }
}

