/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.sql;

import eelk.koguja.Session;
import eelk.koguja.util.Resources;
import eelk.koguja.util.iExceptionHandler;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class ConnectionRefresher
implements Runnable {
    private static final Logger logger = Logger.getLogger(ConnectionRefresher.class);
    private Date lastQueryTime = Calendar.getInstance().getTime();
    private long maxIdleSeconds = 300L;
    private boolean terminated = false;

    public ConnectionRefresher() {
        String maxIdleSeconds = System.getProperty("db.maxIdleSeconds");
        if (maxIdleSeconds != null) {
            this.maxIdleSeconds = Long.parseLong(maxIdleSeconds);
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public synchronized void queryExecuted() {
        this.lastQueryTime = Calendar.getInstance().getTime();
    }

    @Override
    public void run() {
        while (!this.terminated) {
            try {
                Thread.sleep(1000L);
                if (this.millisFromLastQuery() / 1000L <= this.maxIdleSeconds) continue;
                Session.connection().prepareCall("SELECT 1").execute();
                this.queryExecuted();
            }
            catch (InterruptedException ex) {
                logger.debug("Exception in ConnectionRefresher: " + ex.toString());
            }
            catch (SQLException ex) {
                iExceptionHandler.handleException((Throwable)ex, logger, null, Resources.getErrString("Err"), new Object[0]);
            }
        }
    }

    public void terminate() {
        this.terminated = true;
    }

    private long millisFromLastQuery() {
        return Calendar.getInstance().getTime().getTime() - this.lastQueryTime.getTime();
    }
}

