/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.Session;
import eelk.koguja.dlg.DlgSelectPerson;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class SeqSelectPerson
extends Sequence {
    public static final Logger logger = Logger.getLogger(SeqSelectPerson.class);
    private String firstName;
    private String lastName;
    private Date date;
    private String code;
    private boolean all;
    private Integer personId;
    private DlgSelectPerson dlgSelectPerson;

    public SeqSelectPerson(Shell parent) {
        super(parent);
    }

    public void setSearchCond(String firstName, String lastName, Date date, String code, boolean all) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.date = date;
        this.code = code;
        this.all = all;
    }

    public Integer getPersonId() {
        return this.personId;
    }

    @Override
    protected Sequence.SeqResult exec() {
        if (this.dlgSelectPerson == null) {
            this.dlgSelectPerson = new DlgSelectPerson(this.modalParent);
        }
        this.dlgSelectPerson.create();
        this.dlgSelectPerson.getSelectPersonsView().setSearchCond(this.firstName, this.lastName, this.date, this.code, this.all);
        Operation.run(this.parent, true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    SeqSelectPerson.this.dlgSelectPerson.getSelectPersonsView().load(p);
                }
                catch (SQLException ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
                }
                catch (ObjectNotFound ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("ObjectNotFound"), new Object[0]);
                }
            }
        });
        this.dlgSelectPerson.getSelectPersonsView().refresh();
        if (this.dlgSelectPerson.open() != 0) {
            return Sequence.SeqResult.SeqCancelled;
        }
        this.personId = this.dlgSelectPerson.getSelectPersonsView().getObjectID();
        return Sequence.SeqResult.SeqCompleted;
    }
}

