/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.Session;
import eelk.koguja.dlg.DlgSelectOfficiant;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class SeqSelectOfficiant
extends Sequence {
    public static final Logger logger = Logger.getLogger(SeqSelectOfficiant.class);
    private DomPerson person = null;
    private DlgSelectOfficiant dlgSelectOfficiant;

    public SeqSelectOfficiant(Shell parent) {
        super(parent);
    }

    public DomPerson getPerson() {
        return this.person;
    }

    @Override
    protected Sequence.SeqResult exec() {
        if (this.dlgSelectOfficiant == null) {
            this.dlgSelectOfficiant = new DlgSelectOfficiant(this.modalParent);
        }
        this.dlgSelectOfficiant.create();
        Operation.run(this.parent, true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    SeqSelectOfficiant.this.dlgSelectOfficiant.getSelectOfficiantsView().load(p);
                }
                catch (SQLException ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
                }
                catch (ObjectNotFound ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("ObjectNotFound"), new Object[0]);
                }
            }
        });
        this.dlgSelectOfficiant.getSelectOfficiantsView().refresh();
        if (this.dlgSelectOfficiant.open() != 0) {
            return Sequence.SeqResult.SeqCancelled;
        }
        this.person = this.dlgSelectOfficiant.getSelectOfficiantsView().getPerson();
        return Sequence.SeqResult.SeqCompleted;
    }
}

