/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.Session;
import eelk.koguja.dao.Model;
import eelk.koguja.dlg.DlgMain;
import eelk.koguja.search.Expression;
import eelk.koguja.search.Result;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.VMain;
import eelk.koguja.view.VResult;
import eelk.koguja.view.VSearch;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class SeqSearch<S extends Expression, R extends Result>
extends Sequence {
    private static final Logger logger = Logger.getLogger(SeqSearch.class);
    private final VResult.ResultMode resultMode;
    private List<R> result;
    private final VSearch<S> vSearch;
    private final VResult vResult;
    private final Model<?, S, R> model;
    private final String resultMsg;

    public SeqSearch(VSearch<S> vSearch, VResult vResult, Model<?, S, R> model, VResult.ResultMode resultMode, String resultMsg) {
        super(DlgMain.instance().getShell());
        this.vSearch = vSearch;
        this.vResult = vResult;
        this.model = model;
        this.resultMode = resultMode;
        this.resultMsg = resultMsg;
    }

    @Override
    protected Sequence.SeqResult exec() {
        VMain vMain = DlgMain.instance().getVMain();
        S expression = this.vSearch.createExp();
        this.vSearch.fillExp(expression);
        IRunnableWithProgress r = new IRunnableWithProgress((Expression)expression){
            final /* synthetic */ Expression val$expression;
            {
                this.val$expression = expression;
            }

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getString("Msg.SeqSearch.performingSearch"), -1);
                try {
                    SeqSearch.this.result = SeqSearch.this.model.search(this.val$expression);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Search"), new Object[0]);
                }
            }
        };
        Operation.run(this.parent, true, r);
        this.vResult.setResults(this.result, this.resultMode);
        this.vSearch.addHistoryItem(expression);
        vMain.getSearchComposite().refreshHistoryMenu();
        String msg = this.vResult.getResults().size() == 1 ? Resources.getMsgString(this.resultMsg + "1") : MessageFormat.format(Resources.getMsgString(this.resultMsg), this.vResult.getResults().size());
        DlgMain.instance().setStatusLineMessage(msg);
        return Sequence.SeqResult.SeqCompleted;
    }
}

