/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.Session;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.Result;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class SeqReportSendMail
extends Sequence {
    private final List<Result> personlist;

    public SeqReportSendMail(Shell shell, List<Result> results) {
        super(shell);
        this.personlist = results;
    }

    @Override
    protected Sequence.SeqResult exec() {
        Operation.run(this.parent, true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                p.beginTask(Resources.getMsgString("Report.SendMail"), SeqReportSendMail.this.personlist.size() * 2);
                HashSet<Integer> idList = new HashSet<Integer>();
                for (Result result : SeqReportSendMail.this.personlist) {
                    idList.add(result.getId());
                    p.worked(1);
                }
                if (idList.isEmpty()) {
                    p.done();
                    return;
                }
                StringBuilder marks = new StringBuilder();
                for (int i = 0; i < idList.size(); ++i) {
                    marks.append(", ?");
                }
                marks = new StringBuilder(marks.substring(2));
                String sql = "SELECT \"e-mail\" FROM v_my_persons WHERE id IN (" + marks + ")";
                try {
                    PreparedStatement ps = Session.prepareStatement(sql);
                    Iterator ids = idList.iterator();
                    for (int i = 1; i <= idList.size(); ++i) {
                        ps.setInt(i, (Integer)ids.next());
                    }
                    ResultSet rs = ps.executeQuery();
                    StringBuilder mailAddresses = new StringBuilder();
                    while (rs.next()) {
                        String email = rs.getString(1);
                        if (email != null && email.trim().length() > 0) {
                            mailAddresses.append(",").append(email);
                        }
                        p.worked(1);
                    }
                    if (mailAddresses.length() > 1 && mailAddresses.length() <= 2013) {
                        mailAddresses = new StringBuilder(mailAddresses.substring(1));
                        Runtime.getRuntime().exec("cmd.exe /c start mailto:" + mailAddresses);
                    } else {
                        p.done();
                        if (mailAddresses.length() > 2013) {
                            SwtExceptionHandler.instance().Ex(new Exception(), Logger.getLogger(SeqReportSendMail.class), Resources.getErrString("SeqReportSendMail.LengthExceeded"), new Object[0]);
                        } else {
                            SwtExceptionHandler.instance().Ex(new ObjectNotFound(0), Logger.getLogger(SeqReportSendMail.class), Resources.getErrString("SeqReportSendMail.NoMail"), new Object[0]);
                        }
                    }
                    ps.close();
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(e, Logger.getLogger(SeqReportSendMail.class), Resources.getErrString("Load"), new Object[0]);
                }
                catch (IOException e) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(e, Logger.getLogger(SeqReportSendMail.class), Resources.getErrString("OpenExternal"), new Object[0]);
                }
            }
        });
        return Sequence.SeqResult.SeqCompleted;
    }
}

