/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.Session;
import eelk.koguja.model.DomReportField;
import eelk.koguja.report.DataSourceRowComparator;
import eelk.koguja.report.MultiRSDataSource;
import eelk.koguja.search.Result;
import eelk.koguja.seq.SeqDefaultReport;
import eelk.koguja.util.Resources;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;

public class SeqReportPersonStatement
extends SeqDefaultReport {
    public SeqReportPersonStatement(Shell parent, List<Result> results) {
        super(parent, Resources.getString("report.personstatement"), results);
    }

    public SeqReportPersonStatement(Shell parent, List<Result> results, boolean configure) {
        super(parent, Resources.getString("report.personstatement"), results, configure);
    }

    @Override
    protected List<DomReportField> getReportFields() {
        ArrayList<DomReportField> list = new ArrayList<DomReportField>();
        DomReportField field = new DomReportField("fromcongregation", Resources.getString("report.personstatement.fromcongregation"));
        list.add(field);
        field = new DomReportField("tocongregation", Resources.getString("report.personstatement.tocongregation"));
        list.add(field);
        field = new DomReportField("personname", Resources.getString("report.personstatement.personname"));
        list.add(field);
        field = new DomReportField("personcode", Resources.getString("report.personstatement.personcode"));
        list.add(field);
        field = new DomReportField("fathername", Resources.getString("report.personstatement.fathername"));
        list.add(field);
        field = new DomReportField("mathername", Resources.getString("report.personstatement.mathername"));
        list.add(field);
        field = new DomReportField("birthdata", Resources.getString("report.personstatement.birthdata"));
        list.add(field);
        field = new DomReportField("baptismdata", Resources.getString("report.personstatement.baptismdata"));
        list.add(field);
        field = new DomReportField("confirmationdata", Resources.getString("report.personstatement.confirmationdata"));
        list.add(field);
        field = new DomReportField("marriagedata", Resources.getString("report.personstatement.marriagedata"));
        list.add(field);
        field = new DomReportField("childrendata", Resources.getString("report.personstatement.childrendata"));
        list.add(field);
        field = new DomReportField("addressdata", Resources.getString("report.personstatement.addressdata"));
        list.add(field);
        field = new DomReportField("carddata", Resources.getString("report.personstatement.carddata"));
        list.add(field);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JRDataSource doQuery(List<DomReportField> orderFields, Map<String, Object> constraints, IProgressMonitor p) throws SQLException {
        List<DomReportField> fields = this.getReportFields();
        String sql = "SELECT distinct a.id as id,(a.firstname||' '||a.lastname||COALESCE(' ('|| a.maiden_name || ')', ''))  as personname,a.code as personcode,a.sex,(COALESCE(to_char(a.birthdate, 'dd.mm.yyyy')||' ', '')||COALESCE(a.birthplace || ' ', '')) as birthdata, COALESCE(a.book || ' ', '')||COALESCE(a.page, '') as carddata, a.deathdate,a.comment,a.marital_status,a.modified_comment,isa.id as isaid,isa.relid as isarelid,(COALESCE(isa.firstname||' ','')||COALESCE(isa.lastname||' ','')||COALESCE(' ('|| isa.maiden_name || ')', '')) as fathername,isa.birthdate as isabirthdate,ema.id as emaid,ema.relid as emarelid,(COALESCE(ema.firstname||' ','')||COALESCE(ema.lastname||' ','')||COALESCE(' ('|| ema.maiden_name || ')', '')) as mathername,ema.birthdate as emabirthdate,kog.id as kogid,kog.relid as kogrelid,kog.name as fromcongregation,kog.start_date as kogalgus,rist.ristid as ristid,rist.relid as ristrelid,(COALESCE(rist.name||' ','')||COALESCE(to_char(rist.event_date, 'dd.mm.yyyy'),'')) as baptismdata,leer.leerid as leertid,leer.relid as leerrelid,leer.kogid as leerkogid,(COALESCE(leer.name||' ','')||COALESCE(to_char(leer.event_date, 'dd.mm.yyyy'),'')) as confirmationdata, abielu.id as abikid,(COALESCE(abielu.firstname||' ','')||COALESCE(abielu.lastname||' ','')||COALESCE(' ('|| abielu.maiden_name || ')', '')||COALESCE(to_char(abielu.start_date, 'dd.mm.yyyy'),'')) as marriagedata, abielu.start_date as abielualgus,abielu.relid as abielurelid,abielu.key1 as abik1id,abielu.key2 as abik2id, (COALESCE(addr.street||' ','')||COALESCE(addr.house||' ','')||COALESCE(addr.city||' ' || '')||COALESCE(addr.country || '')) AS addressdata, addr.valid_from AS addrvalidfrom, '' as childrendata, '' as tocongregation,a.deleted,a.modified_on,a.modified_by FROM persons a LEFT JOIN (SELECT c.id,c.firstname,c.lastname,c.maiden_name,c.birthdate,d.id as relid,d.person1_id as mykey FROM persons c LEFT JOIN relationships d ON c.id=d.person2_id and d.type_id=1 and c.sex=0) AS isa ON a.id = isa.mykey LEFT JOIN (SELECT c.id,c.firstname,c.lastname,c.maiden_name,c.birthdate,d.id as relid,d.person1_id as mykey FROM persons c LEFT JOIN relationships d ON c.id=d.person2_id and d.type_id=1 and c.sex=1) AS ema ON a.id = ema.mykey LEFT JOIN (SELECT c.id,c.name,d.start_date,d.id as relid,d.person_id as mykey FROM congregations c LEFT JOIN congregations_members d ON c.id=d.congregation_id WHERE d.end_date IS NULL) AS kog ON a.id = kog.mykey LEFT JOIN (SELECT c.id,c.country,c.county,c.city,c.street,c.house,c.postcode,c.phone,c.comment,d.valid_from FROM address c LEFT JOIN persons_address d ON c.id=d.address_id) AS addr ON a.most_recent_address_id = addr.id LEFT JOIN (SELECT c.id as kogid,d.id as ristid,c.name,d.event_date,d.id as relid,d.person_id as mykey FROM congregations c LEFT JOIN baptisms d ON c.id=d.congregation_id) AS rist ON a.id = rist.mykey LEFT JOIN (SELECT c.id as kogid,d.id as leerid,c.name,d.event_date,d.id as relid,d.person_id as mykey FROM congregations c LEFT JOIN confirmations d ON c.id=d.congregation_id) AS leer ON a.id = leer.mykey LEFT JOIN (SELECT c.id, c.firstname, c.lastname,c.maiden_name,c.birthdate, d.start_date, d.id as relid, d.person1_id as key1, d.person2_id as key2 FROM persons c LEFT JOIN relationships d ON c.id=d.person1_id OR c.id=d.person2_id WHERE (d.type_id = 2 OR d.type_id=10) AND d.end_date IS NULL) AS abielu ON (a.id = abielu.key1 OR a.id = abielu.key2) AND abielu.id!=a.id where a.id = ?";
        try (PreparedStatement ps = Session.prepareStatement(sql);){
            MultiRSDataSource dataSource = new MultiRSDataSource();
            List ids = (List)constraints.get("id");
            for (Object id : ids) {
                if (id instanceof Integer) {
                    ps.setInt(1, (Integer)id);
                    ResultSet rs = ps.executeQuery();
                    if (rs.next()) {
                        dataSource.add(rs, fields);
                    }
                    rs.close();
                }
                p.worked(1);
                if (!p.isCanceled()) continue;
                JRDataSource jRDataSource = null;
                return jRDataSource;
            }
            Collections.sort(dataSource.data, new DataSourceRowComparator(orderFields));
            MultiRSDataSource multiRSDataSource = dataSource;
            return multiRSDataSource;
        }
    }

    @Override
    public String getReportPath() {
        return "eelk/koguja/reports/personstatement.jasper";
    }
}

