/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.Session;
import eelk.koguja.model.DomReportField;
import eelk.koguja.report.DataSourceRowComparator;
import eelk.koguja.report.MultiRSDataSource;
import eelk.koguja.search.Result;
import eelk.koguja.seq.SeqDefaultReport;
import eelk.koguja.util.Resources;
import eelk.koguja.util.Util;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;

public class SeqReportPersonContactsListWide
extends SeqDefaultReport {
    public SeqReportPersonContactsListWide(Shell parent, List<Result> results) {
        super(parent, Resources.getString("report.personnameslist"), results);
    }

    protected List<DomReportField> getReportResultFields() {
        ArrayList<DomReportField> list = new ArrayList<DomReportField>();
        DomReportField field = new DomReportField("firstname", Resources.getString("report.personlist.firstname"));
        list.add(field);
        field = new DomReportField("lastname", Resources.getString("report.personlist.lastname"));
        list.add(field);
        field = new DomReportField("code", Resources.getString("report.personlist.code"));
        list.add(field);
        field = new DomReportField("birthdate", Resources.getString("report.personlist.dateofbirth"));
        list.add(field);
        field = new DomReportField("address", Resources.getString("report.personlist.address"));
        list.add(field);
        field = new DomReportField("phone", Resources.getString("report.personlist.phone"));
        list.add(field);
        field = new DomReportField("email", Resources.getString("report.personlist.email"));
        list.add(field);
        return list;
    }

    @Override
    protected List<DomReportField> getReportFields() {
        ArrayList<DomReportField> list = new ArrayList<DomReportField>();
        list.addAll(this.getReportResultFields());
        DomReportField field = new DomReportField("birth_day", Resources.getString("report.personcontactslist.birth.day"));
        list.add(field);
        field = new DomReportField("baptism", Resources.getString("report.personcontactslist.baptism"));
        list.add(field);
        field = new DomReportField("baptism_day", Resources.getString("report.personcontactslist.baptism.day"));
        list.add(field);
        field = new DomReportField("confirmation", Resources.getString("report.personcontactslist.confirmation"));
        list.add(field);
        field = new DomReportField("confirmation_day", Resources.getString("report.personcontactslist.confirmation.day"));
        list.add(field);
        field = new DomReportField("wedding", Resources.getString("report.personcontactslist.wedding"));
        list.add(field);
        field = new DomReportField("wedding_day", Resources.getString("report.personcontactslist.wedding.day"));
        list.add(field);
        field = new DomReportField("funeral", Resources.getString("report.personcontactslist.funeral"));
        list.add(field);
        field = new DomReportField("funeral_day", Resources.getString("report.personcontactslist.funeral.day"));
        list.add(field);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JRDataSource doQuery(List<DomReportField> orderFields, Map<String, Object> constraints, IProgressMonitor p) throws SQLException {
        List<DomReportField> fields = this.getReportResultFields();
        ArrayList<DomReportField> allSelectFields = new ArrayList<DomReportField>();
        allSelectFields.addAll(fields);
        HashSet<String> selectSortFields = new HashSet<String>();
        HashSet<String> sortViews = new HashSet<String>();
        for (DomReportField domReportField : orderFields) {
            if (fields.contains(domReportField)) continue;
            if (domReportField.getColumnName().equals("birth_day")) {
                selectSortFields.add("DATE (EXTRACT(YEAR FROM CURRENT_DATE) || '-' || EXTRACT(MONTH FROM birthdate) || '-' || EXTRACT(DAY FROM birthdate)) AS birth_day");
            }
            if (domReportField.getColumnName().equals("baptism") || domReportField.getColumnName().equals("baptism_day")) {
                sortViews.add("LEFT JOIN v_my_baptisms AS bap ON bap.person_id=p.id");
                if (domReportField.getColumnName().equals("baptism")) {
                    selectSortFields.add("bap.event_date AS baptism");
                } else {
                    selectSortFields.add("DATE (EXTRACT(YEAR FROM CURRENT_DATE) || '-' || EXTRACT(MONTH FROM bap.event_date) || '-' || EXTRACT(DAY FROM bap.event_date)) AS baptism_day");
                }
            }
            if (domReportField.getColumnName().equals("confirmation") || domReportField.getColumnName().equals("confirmation_day")) {
                sortViews.add("LEFT JOIN v_my_confirmations AS conf ON conf.person_id=p.id");
                if (domReportField.getColumnName().equals("confirmation")) {
                    selectSortFields.add("conf.event_date AS confirmation");
                } else {
                    selectSortFields.add("DATE (EXTRACT(YEAR FROM CURRENT_DATE) || '-' || EXTRACT(MONTH FROM conf.event_date) || '-' || EXTRACT(DAY FROM conf.event_date)) AS confirmation_day");
                }
            }
            if (domReportField.getColumnName().equals("wedding") || domReportField.getColumnName().equals("wedding_day")) {
                sortViews.add("LEFT JOIN v_my_weddings AS wed ON (wed.bride_id=p.id OR wed.groom_id=p.id)");
                if (domReportField.getColumnName().equals("wedding")) {
                    selectSortFields.add("wed.event_date AS wedding");
                } else {
                    selectSortFields.add("DATE (EXTRACT(YEAR FROM CURRENT_DATE) || '-' || EXTRACT(MONTH FROM wed.event_date) || '-' || EXTRACT(DAY FROM wed.event_date)) AS wedding_day");
                }
            }
            if (domReportField.getColumnName().equals("funeral") || domReportField.getColumnName().equals("funeral_day")) {
                sortViews.add("LEFT JOIN v_my_funerals AS fun ON fun.person_id=p.id");
                if (domReportField.getColumnName().equals("funeral")) {
                    selectSortFields.add("fun.event_date AS funeral");
                } else {
                    selectSortFields.add("DATE (EXTRACT(YEAR FROM CURRENT_DATE) || '-' || EXTRACT(MONTH FROM fun.event_date) || '-' || EXTRACT(DAY FROM fun.event_date)) AS funeral_day");
                }
            }
            allSelectFields.add(domReportField);
        }
        StringBuilder views = new StringBuilder();
        for (String view : sortViews) {
            views.append(view).append(" ");
        }
        String string = "SELECT " + DomReportField.toColumnNames(fields, ",") + (!selectSortFields.isEmpty() ? "," + Util.setToStr(selectSortFields) : "") + " FROM v_report_personcontactslist AS p " + views + " WHERE p.id = ?";
        try (PreparedStatement ps = Session.prepareStatement(string);){
            MultiRSDataSource dataSource = new MultiRSDataSource();
            List ids = (List)constraints.get("id");
            for (Object id : ids) {
                if (id instanceof Integer) {
                    ps.setInt(1, (Integer)id);
                    ResultSet rs = ps.executeQuery();
                    if (rs.next()) {
                        dataSource.add(rs, allSelectFields);
                    }
                    rs.close();
                }
                p.worked(1);
                if (!p.isCanceled()) continue;
                JRDataSource jRDataSource = null;
                return jRDataSource;
            }
            Collections.sort(dataSource.data, new DataSourceRowComparator(orderFields));
            MultiRSDataSource multiRSDataSource = dataSource;
            return multiRSDataSource;
        }
    }

    @Override
    public String getReportPath() {
        return "eelk/koguja/reports/personcontactslist_wide.jasper";
    }
}

