/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.Session;
import eelk.koguja.dlg.DlgMembersByYearReportSetup;
import eelk.koguja.model.DomReportField;
import eelk.koguja.report.MultiRSDataSource;
import eelk.koguja.seq.SeqReport;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Resources;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;

public class SeqReportMembersByYear
extends SeqReport {
    public SeqReportMembersByYear(Shell parent) {
        super(parent, Resources.getString("report.membersbyyear"), null);
    }

    @Override
    protected Sequence.SeqResult configureAndShowDlgSetup() {
        this.dlgSetup = new DlgMembersByYearReportSetup(this.parent, this.title);
        ((DlgMembersByYearReportSetup)this.dlgSetup).open();
        if (((DlgMembersByYearReportSetup)this.dlgSetup).getReturnCode() != 0) {
            return Sequence.SeqResult.SeqCancelled;
        }
        return Sequence.SeqResult.SeqProceeded;
    }

    protected List<DomReportField> getReportFields(Map<String, Object> constraints) {
        ArrayList<DomReportField> list = new ArrayList<DomReportField>();
        DomReportField field = new DomReportField("deanery_name", Resources.getString("report.membersbyyear.deanery.name"));
        list.add(field);
        field = new DomReportField("congregation_name", Resources.getString("report.membersbyyear.congregation.name"));
        list.add(field);
        String year = "year";
        Object year_v = null;
        for (int i = 1; i <= 10; ++i) {
            year_v = constraints.get(year + i);
            field = new DomReportField(year + i, year_v != null ? year_v.toString() : "");
            list.add(field);
        }
        return list;
    }

    @Override
    protected List<DomReportField> getReportFields() {
        return null;
    }

    @Override
    protected JRDataSource doQuery(List<DomReportField> orderFields, Map<String, Object> constraints, IProgressMonitor p) throws SQLException {
        int i;
        List<DomReportField> fields = this.getReportFields(constraints);
        String sql = "SELECT " + DomReportField.toColumnNames(fields, ",") + " FROM get_memberbyyear(?,?,?,?,?,?,?,?,?,?)";
        Object deanery = constraints.get("deanery_id");
        Object congregation = constraints.get("congregation_id");
        if (deanery != null || congregation != null) {
            sql = sql + " WHERE";
            if (deanery != null) {
                sql = sql + " deanery_id = ?";
            }
            if (congregation != null) {
                sql = sql + " congregation_id = ?";
            }
        }
        PreparedStatement ps = Session.prepareStatement(sql);
        String year = "year";
        Object year_v = null;
        for (i = 1; i <= 10; ++i) {
            year_v = constraints.get(year + i);
            ps.setObject(i, year_v);
        }
        if (deanery != null || congregation != null) {
            i = 11;
            if (deanery != null) {
                ps.setObject(i++, deanery);
            }
            if (congregation != null) {
                ps.setObject(i++, congregation);
            }
        }
        MultiRSDataSource dataSource = new MultiRSDataSource();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            dataSource.add(rs, fields);
        }
        rs.close();
        ps.close();
        return dataSource;
    }

    @Override
    public String getReportPath() {
        return "eelk/koguja/reports/membersbyyear.jasper";
    }
}

