/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.Session;
import eelk.koguja.dlg.DlgDonationReportSetup;
import eelk.koguja.model.DomReportField;
import eelk.koguja.report.MultiRSDataSource;
import eelk.koguja.search.Result;
import eelk.koguja.seq.SeqReport;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Currencies;
import eelk.koguja.util.Resources;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;

public class SeqReportDonationStatistics
extends SeqReport {
    private Map<String, Object> constraints = null;

    public SeqReportDonationStatistics(Shell parent, List<Result> results) {
        super(parent, Resources.getString("report.donationstatistics"), results);
    }

    @Override
    protected Sequence.SeqResult configureAndShowDlgSetup() {
        this.dlgSetup = new DlgDonationReportSetup(this.parent, this.title);
        ((DlgDonationReportSetup)this.dlgSetup).open();
        if (((DlgDonationReportSetup)this.dlgSetup).getReturnCode() != 0) {
            return Sequence.SeqResult.SeqCancelled;
        }
        return Sequence.SeqResult.SeqProceeded;
    }

    @Override
    protected List<DomReportField> getReportFields() {
        ArrayList<DomReportField> list = new ArrayList<DomReportField>();
        DomReportField field = new DomReportField("min", Resources.getString("report.donationstatistics.min"));
        list.add(field);
        field = new DomReportField("max", Resources.getString("report.donationstatistics.max"));
        list.add(field);
        field = new DomReportField("average", Resources.getString("report.donationstatistics.average"));
        list.add(field);
        field = new DomReportField("count", Resources.getString("report.donationstatistics.count"));
        list.add(field);
        field = new DomReportField("sum", null);
        list.add(field);
        field = new DomReportField("deanery_name", Resources.getString("report.donationstatistics.deanery.name"));
        list.add(field);
        field = new DomReportField("congregation_name", Resources.getString("report.donationstatistics.congregation.name"));
        list.add(field);
        return list;
    }

    @Override
    protected JRDataSource doQuery(List<DomReportField> orderFields, Map<String, Object> constraints, IProgressMonitor p) throws SQLException {
        List<DomReportField> fields = this.getReportFields();
        String sql = "SELECT " + DomReportField.toColumnNames(fields, ",") + " FROM v_report_donationstatistics";
        Object deanery = constraints.get("deanery_id");
        Object congregation = constraints.get("congregation_id");
        Object startDate = constraints.get("start_date");
        Object endDate = constraints.get("end_date");
        if (deanery != null || congregation != null || startDate != null || endDate != null) {
            sql = sql + " WHERE";
            if (deanery != null) {
                sql = sql + " deanery_id = ?";
            }
            if (congregation != null) {
                sql = sql + " congregation_id = ?";
            }
            if (startDate != null) {
                if (deanery != null || congregation != null) {
                    sql = sql + " AND";
                }
                sql = sql + " start_date >= ?";
            }
            if (endDate != null) {
                if (deanery != null || congregation != null || startDate != null) {
                    sql = sql + " AND";
                }
                sql = sql + " end_date <= ?";
            }
        }
        PreparedStatement ps = Session.prepareStatement(sql);
        if (deanery != null || congregation != null || startDate != null || endDate != null) {
            int i = 1;
            if (deanery != null) {
                ps.setObject(i++, deanery);
            }
            if (congregation != null) {
                ps.setObject(i++, congregation);
            }
            if (startDate != null) {
                ps.setObject(i++, startDate);
            }
            if (endDate != null) {
                ps.setObject(i++, endDate);
            }
        }
        MultiRSDataSource dataSource = new MultiRSDataSource();
        ResultSet rs = ps.executeQuery();
        rs.close();
        ps.close();
        this.constraints = constraints;
        return dataSource;
    }

    @Override
    protected Map<String, Object> getReportParameters() {
        Map<String, Object> prm = super.getReportParameters();
        if (this.constraints != null) {
            prm.put("CURRENCY", Currencies.getCurrencySymbol((Date)this.constraints.get("end_date")));
        }
        return prm;
    }

    @Override
    public String getReportPath() {
        return "eelk/koguja/reports/donationstatistics.jasper";
    }
}

