/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.Session;
import eelk.koguja.dlg.DlgDonationReportSetup;
import eelk.koguja.model.DomReportField;
import eelk.koguja.report.MultiRSDataSource;
import eelk.koguja.report.ReportItem;
import eelk.koguja.seq.SeqReport;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Currencies;
import eelk.koguja.util.Resources;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;

public class SeqReportDonationListWithDetails
extends SeqReport {
    private Map<String, Object> constraints = null;

    public SeqReportDonationListWithDetails(Shell parent) {
        super(parent, Resources.getString("report.donationlistwithdetails"), null);
    }

    @Override
    protected Sequence.SeqResult configureAndShowDlgSetup() {
        this.dlgSetup = new DlgDonationReportSetup(this.parent, this.title);
        ((DlgDonationReportSetup)this.dlgSetup).open();
        if (((DlgDonationReportSetup)this.dlgSetup).getReturnCode() != 0) {
            return Sequence.SeqResult.SeqCancelled;
        }
        return Sequence.SeqResult.SeqProceeded;
    }

    @Override
    protected List<DomReportField> getReportFields() {
        ArrayList<DomReportField> list = new ArrayList<DomReportField>();
        DomReportField field = new DomReportField("deanery_name", Resources.getString("report.donationlistwithdetails.deanery.name"));
        list.add(field);
        field = new DomReportField("congregation_name", Resources.getString("report.donationlistwithdetails.congregation.name"));
        list.add(field);
        field = new DomReportField("donation_type", Resources.getString("report.donationlistwithdetails.donation.type"));
        list.add(field);
        field = new DomReportField("intended_use", Resources.getString("report.donationlistwithdetails.donation.intendeduse"));
        list.add(field);
        field = new DomReportField("doc_nr", Resources.getString("report.donationlistwithdetails.donation.docnr"));
        list.add(field);
        field = new DomReportField("donation_date", Resources.getString("report.donationlistwithdetails.donation.date"));
        list.add(field);
        field = new DomReportField("donation_from", Resources.getString("report.donationlistwithdetails.donator"));
        list.add(field);
        field = new DomReportField("person_firstname", Resources.getString("report.donationlistwithdetails.donator"));
        list.add(field);
        field = new DomReportField("person_lastname", Resources.getString("report.donationlistwithdetails.donator"));
        list.add(field);
        field = new DomReportField("person_code", Resources.getString("report.donationlistwithdetails.donator.code"));
        list.add(field);
        field = new DomReportField("group_name", Resources.getString("report.donationlistwithdetails.donator.code"));
        list.add(field);
        field = new DomReportField("house", Resources.getString("report.donationlistwithdetails.address"));
        list.add(field);
        field = new DomReportField("street", Resources.getString("report.donationlistwithdetails.address"));
        list.add(field);
        field = new DomReportField("city", Resources.getString("report.donationlistwithdetails.address"));
        list.add(field);
        field = new DomReportField("postcode", Resources.getString("report.donationlistwithdetails.address"));
        list.add(field);
        field = new DomReportField("amount", Resources.getString("report.donationlistwithdetails.donation.amount"));
        list.add(field);
        field = new DomReportField("payment_method", Resources.getString("report.donationlistwithdetails.paymentmethod"));
        list.add(field);
        field = new DomReportField("comment", Resources.getString("report.donationlistwithdetails.donation.comment"));
        list.add(field);
        return list;
    }

    @Override
    protected JRDataSource doQuery(List<DomReportField> orderFields, Map<String, Object> constraints, IProgressMonitor p) throws SQLException {
        List<DomReportField> fields = this.getReportFields();
        String sql = "SELECT " + DomReportField.toColumnNames(fields, ",") + " FROM v_report_donationlistwithdetails";
        Object deanery = constraints.get("deanery_id");
        Object congregation = constraints.get("congregation_id");
        Object startDate = constraints.get("start_date");
        Object endDate = constraints.get("end_date");
        if (deanery != null || congregation != null || startDate != null || endDate != null) {
            sql = sql + " WHERE";
            if (deanery != null) {
                sql = sql + " deanery_id = ?";
            }
            if (congregation != null) {
                if (deanery != null) {
                    sql = sql + " AND";
                }
                sql = sql + " congregation_id = ?";
            }
            if (startDate != null) {
                if (deanery != null || congregation != null) {
                    sql = sql + " AND";
                }
                sql = sql + " donation_date >= ?";
            }
            if (endDate != null) {
                if (deanery != null || congregation != null || startDate != null) {
                    sql = sql + " AND";
                }
                sql = sql + " donation_date <= ?";
            }
        }
        PreparedStatement ps = Session.prepareStatement(sql);
        if (deanery != null || congregation != null || startDate != null || endDate != null) {
            int i = 1;
            if (deanery != null) {
                ps.setObject(i++, deanery);
            }
            if (congregation != null) {
                ps.setObject(i++, congregation);
            }
            if (startDate != null) {
                ps.setObject(i++, startDate);
            }
            if (endDate != null) {
                ps.setObject(i++, endDate);
            }
        }
        MultiRSDataSource dataSource = new MultiRSDataSource();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            Date date;
            Map<String, ReportItem> m = dataSource.add(rs, fields);
            if (endDate != null && !Currencies.isEuroDate((Date)endDate) || Currencies.isEuroDate(date = (Date)m.get("donation_date").getValue())) continue;
            BigDecimal amount = (BigDecimal)m.get("amount").getValue();
            BigDecimal amountInEur = Currencies.getEekInEur(amount);
            m.get("amount").setValue(amountInEur);
            m.get("amount").setFormattedValue(amountInEur);
        }
        rs.close();
        ps.close();
        this.constraints = constraints;
        return dataSource;
    }

    @Override
    protected Map<String, Object> getReportParameters() {
        Map<String, Object> prm = super.getReportParameters();
        if (this.constraints != null) {
            prm.put("CURRENCY", Currencies.getCurrencySymbol((Date)this.constraints.get("end_date")));
        }
        return prm;
    }

    @Override
    public String getReportPath() {
        return "eelk/koguja/reports/donationlistwithdetails.jasper";
    }
}

