/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.Session;
import eelk.koguja.dao.MAddress;
import eelk.koguja.dao.MCongregation;
import eelk.koguja.dao.MDonation;
import eelk.koguja.dlg.DlgFileDialog;
import eelk.koguja.model.DomAddress;
import eelk.koguja.model.DomCongregation;
import eelk.koguja.model.DomDonation;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.util.Util;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class SeqReportDonationINF4
extends Sequence {
    private static final Logger logger = Logger.getLogger(SeqReportDonationINF4.class);
    private DlgFileDialog fileDialog;

    public SeqReportDonationINF4(Shell parent) {
        super(parent);
    }

    @Override
    protected Sequence.SeqResult exec() {
        String fileName = this.getFileName();
        if (fileName == null) {
            return Sequence.SeqResult.SeqCancelled;
        }
        if (!this.saveFile(fileName)) {
            return Sequence.SeqResult.SeqFailed;
        }
        GuiUtil.informationDialog(this.parent, "report.donations.result", fileName);
        return Sequence.SeqResult.SeqCompleted;
    }

    private boolean saveFile(final String fileName) {
        boolean saveSucceeded = true;
        Operation.run(this.parent, true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                p.beginTask(Resources.getMsgString("Report.Donation.Create"), 4);
                try {
                    DomCongregation congregation = MCongregation.instance().get(Session.congregation().getId());
                    p.worked(1);
                    List<DomDonation> lstDonations = MDonation.listINF4ReportDonations(congregation.getId());
                    p.worked(1);
                    DomAddress address = congregation.getAddressId() == null ? new DomAddress() : MAddress.instance().get(congregation.getAddressId());
                    p.worked(1);
                    PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), StandardCharsets.UTF_8));
                    pw.write(Resources.getString("report.donations.inf4") + ";;\r\n");
                    pw.write(Util.d(address.getComment()) + ";;\r\n");
                    pw.write(Util.d(congregation.getName()) + ";;\r\n");
                    pw.write(Util.d(address.toString()) + ";;\r\n");
                    pw.write(Util.d(address.getPhoneNum()) + ";;\r\n");
                    pw.write(Util.d(congregation.getEMail()) + ";;\r\n");
                    pw.write(Util.d(MDonation.getLastYear()) + ";;\r\n");
                    pw.write(Resources.getString("report.donations.columnheadersline") + "\r\n");
                    DecimalFormat decimalFormat = SeqReportDonationINF4.this.createDecimalFormat();
                    for (DomDonation d : lstDonations) {
                        String line = d.getINF4Line(decimalFormat);
                        if (line == null) continue;
                        pw.write(line + "\r\n");
                    }
                    pw.close();
                    p.worked(1);
                    p.done();
                }
                catch (IOException ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Save.File"), new Object[0]);
                }
                catch (SQLException ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
                }
                catch (ObjectNotFound ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        });
        return saveSucceeded;
    }

    private String getFileName() {
        if (this.fileDialog == null) {
            this.fileDialog = new DlgFileDialog(this.parent, 8192);
            this.fileDialog.setFilterNames(new String[]{Resources.getString("FileDialog.CSVFiles"), Resources.getString("FileDialog.AllFiles")});
            String EXT_CSV_FILES = "*.csv";
            String EXT_ALL_FILES = "*.*";
            this.fileDialog.setFilterExtensions(new String[]{EXT_CSV_FILES, EXT_ALL_FILES});
        }
        return this.fileDialog.open();
    }

    private DecimalFormat createDecimalFormat() {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        return new DecimalFormat("0.00", decimalFormatSymbols);
    }
}

