/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.Session;
import eelk.koguja.model.DomReportField;
import eelk.koguja.report.DataSourceRowComparator;
import eelk.koguja.report.MultiRSDataSource;
import eelk.koguja.report.ReportItem;
import eelk.koguja.search.Result;
import eelk.koguja.seq.SeqDefaultReport;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;

public class SeqReportAddressLabels
extends SeqDefaultReport {
    private boolean compact = true;

    public SeqReportAddressLabels(Shell parent, List<Result> results, boolean compact) {
        super(parent, Resources.getString("report.addresslabels"), results, true);
        this.compact = compact;
    }

    @Override
    protected List<DomReportField> getReportFields() {
        ArrayList<DomReportField> list = new ArrayList<DomReportField>();
        DomReportField field = new DomReportField("address_country", Resources.getString("report.personlist.address.country"));
        list.add(field);
        field = new DomReportField("address_city", Resources.getString("report.personlist.address.city"));
        list.add(field);
        field = new DomReportField("address_street", Resources.getString("report.personlist.address.street"));
        list.add(field);
        field = new DomReportField("address_house", Resources.getString("report.personlist.address.house"));
        list.add(field);
        field = new DomReportField("address_postcode", Resources.getString("report.personlist.address.postcode"));
        list.add(field);
        field = new DomReportField("address_id", Resources.getString("report.personlist.address"));
        list.add(field);
        return list;
    }

    protected List<DomReportField> getAllFields() {
        ArrayList<DomReportField> list = new ArrayList<DomReportField>();
        DomReportField field = new DomReportField("firstname", Resources.getString("report.personlist.firstname"));
        list.add(field);
        field = new DomReportField("lastname", Resources.getString("report.personlist.lastname"));
        list.add(field);
        field = new DomReportField("age", Resources.getString("report.personlist.age"));
        list.add(field);
        field = new DomReportField("address_id", Resources.getString("report.personlist.address"));
        list.add(field);
        field = new DomReportField("address_street", Resources.getString("report.personlist.address.street"));
        list.add(field);
        field = new DomReportField("address_house", Resources.getString("report.personlist.address.house"));
        list.add(field);
        field = new DomReportField("address_city", Resources.getString("report.personlist.address.city"));
        list.add(field);
        field = new DomReportField("address_postcode", Resources.getString("report.personlist.address.postcode"));
        list.add(field);
        field = new DomReportField("address_country", Resources.getString("report.personlist.address.country"));
        list.add(field);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JRDataSource doQuery(List<DomReportField> orderFields, Map<String, Object> constraints, IProgressMonitor p) throws SQLException {
        List<DomReportField> fields = this.getAllFields();
        String sql = "SELECT " + DomReportField.toColumnNames(fields, ",") + " FROM v_report_personlist  WHERE id = ?";
        try (PreparedStatement ps = Session.prepareStatement(sql);){
            MultiRSDataSource dataSource = new MultiRSDataSource();
            List ids = (List)constraints.get("id");
            for (Object id : ids) {
                if (id instanceof Integer) {
                    ps.setInt(1, (Integer)id);
                    ResultSet rs = ps.executeQuery();
                    if (rs.next() && rs.getString("address_id") != null) {
                        dataSource.add(rs, fields);
                    }
                    rs.close();
                }
                p.worked(1);
                if (!p.isCanceled()) continue;
                JRDataSource jRDataSource = null;
                return jRDataSource;
            }
            if (this.compact || orderFields != null) {
                List<DomReportField> sort = null;
                DomReportField repField = null;
                sort = orderFields == null || orderFields.isEmpty() ? this.getReportFields() : orderFields;
                repField = new DomReportField("lastname", null);
                repField.setAsc(true);
                sort.add(repField);
                Collections.sort(dataSource.data, new DataSourceRowComparator(sort));
            }
            MultiRSDataSource outDataSource = new MultiRSDataSource();
            HashMap<String, ReportItem> lastMap = null;
            try {
                while (dataSource.next()) {
                    if (!this.compact || lastMap == null || !dataSource.getField("address_id").getValue().equals(((ReportItem)lastMap.get("address_id")).getValue())) {
                        HashMap<String, ReportItem> map = new HashMap<String, ReportItem>();
                        for (DomReportField field : fields) {
                            if (field.getColumnName().equals("firstname") || field.getColumnName().equals("age")) continue;
                            if (field.getColumnName().equals("lastname")) {
                                String person = dataSource.getField("firstname").getValue() + " " + dataSource.getField("lastname").getValue();
                                map.put("persons", new ReportItem(person, person));
                                continue;
                            }
                            map.put(field.getColumnName(), dataSource.getField(field.getColumnName()));
                        }
                        outDataSource.add(map);
                        lastMap = map;
                        continue;
                    }
                    ReportItem oldPersons = (ReportItem)lastMap.get("persons");
                    String person = oldPersons.getValue() + ", " + dataSource.getField("firstname").getValue() + " " + dataSource.getField("lastname").getValue();
                    lastMap.put("persons", new ReportItem(person, person));
                }
            }
            catch (JRException e) {
                SwtExceptionHandler.instance().Ex(e, Logger.getLogger(SeqReportAddressLabels.class), "", new Object[0]);
            }
            MultiRSDataSource multiRSDataSource = outDataSource;
            return multiRSDataSource;
        }
    }

    @Override
    public String getReportPath() {
        return "eelk/koguja/reports/addresslabels.jasper";
    }
}

