/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.Session;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.DomReportField;
import eelk.koguja.preference.Preferences;
import eelk.koguja.report.MultiRSDataSource;
import eelk.koguja.report.ReportManager;
import eelk.koguja.report.ReportSetup;
import eelk.koguja.search.Result;
import eelk.koguja.seq.SeqReportBaptismList;
import eelk.koguja.seq.SeqReportFuneralList;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.util.Util;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public abstract class SeqReport
extends Sequence {
    private static final Logger logger = Logger.getLogger(SeqReport.class);
    private final String REPORT_TITLE = "report." + this.getReportName() + ".title";
    private final String REPORT_SORT_N = "report." + this.getReportName() + ".sort%d";
    private final String REPORT_ASC_N = "report." + this.getReportName() + ".asc%d";
    protected ReportSetup dlgSetup;
    protected JRDataSource dataSource;
    protected final String title;
    private final boolean showConfigureDlg;
    private final List<Result> results;

    public SeqReport(Shell parent, String title, List<Result> results) {
        this(parent, title, results, true);
    }

    public SeqReport(Shell parent, String title, List<Result> results, boolean configure) {
        super(parent);
        this.title = Preferences.getStore().contains(this.REPORT_TITLE) && Util.c(Preferences.getStore().getString(this.REPORT_TITLE)) != null ? Preferences.getStore().getString(this.REPORT_TITLE) : title;
        this.results = results;
        this.showConfigureDlg = configure;
    }

    protected String getReportName() {
        return Util.getBaseFilename(this.getReportPath());
    }

    @Override
    protected Sequence.SeqResult exec() {
        Sequence.SeqResult seqResult = Sequence.SeqResult.SeqProceeded;
        if (this.showConfigureDlg && (seqResult = this.configureAndShowDlgSetup()) != Sequence.SeqResult.SeqProceeded) {
            return seqResult;
        }
        this.savePreferences();
        IRunnableWithProgress r = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) {
                int len = SeqReport.this.results == null ? -1 : SeqReport.this.results.size();
                p.beginTask(Resources.getMsgString("LoadingReport"), len);
                try {
                    SeqReport.this.dataSource = SeqReport.this.doQuery(SeqReport.this.dlgSetup == null ? null : SeqReport.this.dlgSetup.getReportOrder(), SeqReport.this.createConstraints(), p);
                    p.done();
                }
                catch (SQLException e) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(e, logger, Resources.getErrString("Report.Data"), new Object[0]);
                }
            }
        };
        Operation.run(this.parent, true, r);
        if (this.dataSource == null) {
            return Sequence.SeqResult.SeqCancelled;
        }
        ReportManager.runReport(this.parent, this.getReportPath(), this.getReportParameters(), this.dataSource);
        seqResult = Sequence.SeqResult.SeqCompleted;
        return seqResult;
    }

    protected Map<String, Object> getReportParameters() {
        String userName;
        Hashtable<String, Object> prm = this.dlgSetup == null ? new Hashtable<String, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("TITLE", SeqReport.this.title);
            }
        } : this.dlgSetup.getReportParameters();
        if (this instanceof SeqReportBaptismList || this instanceof SeqReportFuneralList) {
            prm.put("EVENT_PARTICIPANTS", ((MultiRSDataSource)this.dataSource).getSubDataSets());
        }
        try {
            DomPerson user = MPersonSwt.instance().getUserRelatedPerson(Session.current().getUsername());
            userName = user.getFirstName() + " " + user.getLastName();
        }
        catch (Exception e) {
            userName = Session.current().getUsername();
        }
        prm.put("USERNAME", userName);
        prm.put("CONGREGATION", Session.congregation().getName());
        return prm;
    }

    private Map<String, Object> createConstraints() {
        Map<String, Object> rc;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.results != null) {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            for (Result r : this.results) {
                ids.add(r.getId());
            }
            result.put("id", ids);
        }
        if (this.showConfigureDlg && (rc = this.dlgSetup.getReportConstraints()) != null) {
            result.putAll(rc);
        }
        return result;
    }

    protected abstract List<DomReportField> getReportFields();

    protected abstract Sequence.SeqResult configureAndShowDlgSetup();

    protected void savePreferences() {
        this.saveReportTitle();
    }

    protected void saveReportTitle() {
        String title;
        if (!this.showConfigureDlg) {
            return;
        }
        if (this.dlgSetup.getReportParameters().containsKey("TITLE") && !(title = (String)this.dlgSetup.getReportParameters().get("TITLE")).equals(this.title)) {
            Preferences.getStore().setValue(this.REPORT_TITLE, title);
        }
    }

    protected void saveReportOrderFields() {
        if (!this.showConfigureDlg) {
            return;
        }
        List<DomReportField> fields = this.dlgSetup.getReportOrder();
        int cFld = 1;
        for (DomReportField fld : fields) {
            if (Util.c(fld.getColumnName()) == null) continue;
            Preferences.getStore().setValue(String.format(this.REPORT_SORT_N, cFld), fld.getColumnName());
            Preferences.getStore().setValue(String.format(this.REPORT_ASC_N, cFld), fld.isAsc());
            ++cFld;
        }
        while (Preferences.getStore().contains(String.format(this.REPORT_SORT_N, cFld))) {
            Preferences.getStore().setValue(String.format(this.REPORT_SORT_N, cFld), "-");
            if (Preferences.getStore().contains(String.format(this.REPORT_ASC_N, cFld))) {
                Preferences.getStore().setValue(String.format(this.REPORT_ASC_N, cFld), "-");
            }
            ++cFld;
        }
    }

    protected void loadReporOrderFields() {
        List<DomReportField> allFields = this.getReportFields();
        ArrayList<DomReportField> orderFields = new ArrayList<DomReportField>();
        int cFld = 1;
        while (Preferences.getStore().contains(String.format(this.REPORT_SORT_N, cFld)) && !Preferences.getStore().getString(String.format(this.REPORT_SORT_N, cFld)).equals("-")) {
            DomReportField fld = DomReportField.find(allFields, Preferences.getStore().getString(String.format(this.REPORT_SORT_N, cFld)));
            if (fld != null) {
                if (Preferences.getStore().contains(String.format(this.REPORT_ASC_N, cFld)) && !Preferences.getStore().getString(String.format(this.REPORT_ASC_N, cFld)).equals("-")) {
                    fld.setAsc(Preferences.getStore().getBoolean(String.format(this.REPORT_ASC_N, cFld)));
                }
                orderFields.add(fld);
            }
            ++cFld;
        }
        this.dlgSetup.setReportOrder(orderFields);
    }

    protected abstract JRDataSource doQuery(List<DomReportField> var1, Map<String, Object> var2, IProgressMonitor var3) throws SQLException;

    protected abstract String getReportPath();
}

