/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.dao.MAddress;
import eelk.koguja.dlg.DlgRemoveAddress;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.seq.SeqManageAddress;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class SeqRemoveAddress
extends SeqManageAddress {
    public static final Logger logger = Logger.getLogger(SeqRemoveAddress.class);
    private Sequence.SeqResult seqResult;
    private DlgRemoveAddress dlgRemAddress;

    public SeqRemoveAddress(Shell parent) {
        super(parent);
    }

    @Override
    protected Sequence.SeqResult exec() {
        if (this.dlgRemAddress == null) {
            this.dlgRemAddress = new DlgRemoveAddress(this.modalParent.getShell());
        }
        this.dlgRemAddress.setAddressText(this.getAddress().toString());
        List<DomPerson> lstPersonsOnAddress = this.getPersonsUsingAddress();
        this.dlgRemAddress.setPersons(lstPersonsOnAddress);
        if (lstPersonsOnAddress.size() > 1) {
            if (this.dlgRemAddress.open() != 0) {
                return Sequence.SeqResult.SeqCancelled;
            }
            this.setGlobal(this.dlgRemAddress.removeAll());
        } else {
            this.setGlobal(false);
        }
        this.seqResult = Sequence.SeqResult.SeqCompleted;
        Operation.run(this.parent, true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    p.beginTask(Resources.getMsgString("Save"), -1);
                    if (SeqRemoveAddress.this.dlgRemAddress.removeAll()) {
                        MAddress.instance().delete(SeqRemoveAddress.this.getAddress().getId());
                    }
                    p.done();
                }
                catch (SQLException ex) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Save"), new Object[0]);
                    SeqRemoveAddress.this.seqResult = Sequence.SeqResult.SeqFailed;
                }
                catch (ObjectNotFound ex) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Save"), new Object[0]);
                    SeqRemoveAddress.this.seqResult = Sequence.SeqResult.SeqFailed;
                }
            }
        });
        return this.seqResult;
    }
}

