/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.Session;
import eelk.koguja.dao.MWedding;
import eelk.koguja.dlg.DlgSelectEvent;
import eelk.koguja.model.DomWedding;
import eelk.koguja.seq.SeqPersonEventSearch;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.DbUtil;
import eelk.koguja.util.IDbUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class SeqPersonWeddingSearch
extends SeqPersonEventSearch<DomWedding> {
    private static final Logger logger = Logger.getLogger(SeqPersonWeddingSearch.class);
    private DlgSelectEvent dlgSelectEvent;

    public SeqPersonWeddingSearch(Shell parent) {
        super(parent);
    }

    @Override
    protected Sequence.SeqResult exec() {
        if (!DbUtil.checkUserCong(IDbUtil.Permission.Write, this.parent)) {
            return Sequence.SeqResult.SeqFailed;
        }
        this.findWedding();
        if (this.dlgSelectEvent == null) {
            this.dlgSelectEvent = new DlgSelectEvent(this.modalParent);
        }
        this.dlgSelectEvent.setCanUseFound(this.getEvent() != null);
        if (this.dlgSelectEvent.open() != 0) {
            return Sequence.SeqResult.SeqCancelled;
        }
        if (this.dlgSelectEvent.getEventResult() == DlgSelectEvent.SelectEventResult.CREATE_NEW) {
            this.setEvent(this.createWedding());
            this.setIsNewEvent(true);
        } else {
            this.setIsNewEvent(false);
            if (this.getPerson().getSex() == 0) {
                ((DomWedding)this.getEvent()).setGroomId(this.getPerson().getId());
            } else {
                ((DomWedding)this.getEvent()).setBrideId(this.getPerson().getId());
            }
        }
        return Sequence.SeqResult.SeqCompleted;
    }

    private DomWedding createWedding() {
        Date DEFAULT_BIRTHDATE = new Date(0L);
        DomWedding result = new DomWedding();
        result.setState(2);
        result.setCongregationName(Resources.getGenString("Unknown"));
        result.setEventDate(new Date(this.getEventDate().getTime()));
        if (this.getPerson().getSex() == 0) {
            result.setGroomId(this.getPerson().getId());
            result.setGroomFirstName(this.getPerson().getFirstName());
            result.setGroomLastName(this.getPerson().getLastName());
            result.setGroomBirthdate(this.getPerson().getBirthDate());
            result.setGroomCode(this.getPerson().getCode());
            result.setBrideFirstName(Resources.getGenString("Unknown"));
            result.setBrideLastName(Resources.getGenString("Unknown"));
            result.setBrideBirthdate(DEFAULT_BIRTHDATE);
        } else {
            result.setBrideId(this.getPerson().getId());
            result.setBrideFirstName(this.getPerson().getFirstName());
            result.setBrideLastName(this.getPerson().getLastName());
            result.setBrideBirthdate(this.getPerson().getBirthDate());
            result.setBrideCode(this.getPerson().getCode());
            result.setGroomFirstName(Resources.getGenString("Unknown"));
            result.setGroomLastName(Resources.getGenString("Unknown"));
            result.setGroomBirthdate(DEFAULT_BIRTHDATE);
        }
        result.setMarriageRegistered(false);
        result.setMarriageConvetionVerified(false);
        return result;
    }

    private void findWedding() {
        this.setEvent(null);
        Operation.run(this.parent, true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    p.beginTask(Resources.getMsgString("Load.Loading"), -1);
                    SeqPersonWeddingSearch.this.setEvent(MWedding.getWeddingForPerson(new Date(SeqPersonWeddingSearch.this.getEventDate().getTime()), SeqPersonWeddingSearch.this.getPerson()));
                    p.done();
                }
                catch (SQLException ex) {
                    p.done();
                    Session.rollback();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        });
    }
}

