/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.dao.MConfirmation;
import eelk.koguja.dlg.DlgSelectEvent;
import eelk.koguja.model.DomConfirmation;
import eelk.koguja.seq.SeqPersonEventSearch;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.DbUtil;
import eelk.koguja.util.IDbUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class SeqPersonConfSearch
extends SeqPersonEventSearch<DomConfirmation> {
    private static final Logger logger = Logger.getLogger(SeqPersonConfSearch.class);
    private DlgSelectEvent dlgSelectEvent;

    public SeqPersonConfSearch(Shell parent) {
        super(parent);
    }

    @Override
    protected Sequence.SeqResult exec() {
        if (!DbUtil.checkUserCong(IDbUtil.Permission.Write, this.parent)) {
            return Sequence.SeqResult.SeqFailed;
        }
        this.findConfirmation();
        if (this.dlgSelectEvent == null) {
            this.dlgSelectEvent = new DlgSelectEvent(this.modalParent);
        }
        this.dlgSelectEvent.setCanUseFound(this.getEvent() != null);
        if (this.dlgSelectEvent.open() != 0) {
            return Sequence.SeqResult.SeqCancelled;
        }
        if (this.dlgSelectEvent.getEventResult() == DlgSelectEvent.SelectEventResult.CREATE_NEW) {
            this.setEvent(this.createConfirmation());
            this.setIsNewEvent(true);
        } else {
            this.setIsNewEvent(false);
            ((DomConfirmation)this.getEvent()).setPersonId(this.getPerson().getId());
        }
        return Sequence.SeqResult.SeqCompleted;
    }

    private DomConfirmation createConfirmation() {
        DomConfirmation result = new DomConfirmation();
        result.setState(2);
        result.setCongregationName(Resources.getGenString("Unknown"));
        result.setEventDate(new Date(this.getEventDate().getTime()));
        result.setPersonId(this.getPerson().getId());
        return result;
    }

    private void findConfirmation() {
        this.setEvent(null);
        Operation.run(this.parent, true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    p.beginTask(Resources.getMsgString("Load.Loading"), -1);
                    SeqPersonConfSearch.this.setEvent(MConfirmation.getConfirmationForPerson(new Date(SeqPersonConfSearch.this.getEventDate().getTime()), SeqPersonConfSearch.this.getPerson()));
                    p.done();
                }
                catch (SQLException ex) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        });
    }
}

