/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.dao.MBaptism;
import eelk.koguja.dlg.DlgSelectEvent;
import eelk.koguja.model.DomBaptism;
import eelk.koguja.seq.SeqPersonEventSearch;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.DbUtil;
import eelk.koguja.util.IDbUtil;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class SeqPersonBaptismSearch
extends SeqPersonEventSearch<DomBaptism> {
    private static final Logger logger = Logger.getLogger(SeqPersonBaptismSearch.class);
    private DlgSelectEvent dlgSelectEvent;

    public SeqPersonBaptismSearch(Shell parent) {
        super(parent);
    }

    @Override
    protected Sequence.SeqResult exec() {
        if (!DbUtil.checkUserCong(IDbUtil.Permission.Write, this.parent)) {
            return Sequence.SeqResult.SeqFailed;
        }
        this.findBaptism();
        if (this.dlgSelectEvent == null) {
            this.dlgSelectEvent = new DlgSelectEvent(this.modalParent);
        }
        this.dlgSelectEvent.setCanUseFound(this.getEvent() != null);
        if (this.dlgSelectEvent.open() != 0) {
            return Sequence.SeqResult.SeqCancelled;
        }
        if (this.dlgSelectEvent.getEventResult() == DlgSelectEvent.SelectEventResult.CREATE_NEW) {
            this.setEvent(this.createBaptism());
            this.setIsNewEvent(true);
        } else {
            this.setIsNewEvent(false);
            ((DomBaptism)this.getEvent()).setPersonId(this.getPerson().getId());
        }
        return Sequence.SeqResult.SeqCompleted;
    }

    private DomBaptism createBaptism() {
        DomBaptism result = new DomBaptism();
        result.setState(2);
        result.setCongregationName(Resources.getGenString("Unknown"));
        result.setEventDate(new Date(this.getEventDate().getTime()));
        result.setPersonId(this.getPerson().getId());
        result.setIsGodFather(false);
        return result;
    }

    private void findBaptism() {
        this.setEvent(null);
        Operation.run(this.parent, true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    p.beginTask(Resources.getMsgString("Load.Loading"), -1);
                    SeqPersonBaptismSearch.this.setEvent(MBaptism.getBaptismForPerson(new Date(SeqPersonBaptismSearch.this.getEventDate().getTime()), SeqPersonBaptismSearch.this.getPerson()));
                    p.done();
                }
                catch (SQLException ex) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
                }
            }
        });
    }
}

