/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.dlg.DlgMain;
import eelk.koguja.dlg.DlgWeddingEdit;
import eelk.koguja.events.BusinessObjectEventFactory;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.DomWedding;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.seq.SeqNewEvent;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import eelk.koguja.view.VMain;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Shell;

public class SeqNewWedding
extends SeqNewEvent {
    public static final Logger logger = Logger.getLogger(SeqNewWedding.class);
    private DlgWeddingEdit dlgWeddingEdit;

    public SeqNewWedding(Shell parent) {
        super(parent);
    }

    @Override
    protected Sequence.SeqResult exec() {
        Sequence.SeqResult result = super.exec();
        if (result != Sequence.SeqResult.SeqProceeded) {
            return result;
        }
        if (this.dlgWeddingEdit == null) {
            this.dlgWeddingEdit = new DlgWeddingEdit(this.modalParent);
        }
        this.setWedPersons();
        if (this.dlgWeddingEdit.open() == 0) {
            if (DlgMain.instance().getVMain().getMode() == VMain.SearchMode.WEDDING) {
                DomWedding wedding = this.dlgWeddingEdit.getView().getWedding();
                BusinessObjectEventFactory.notifyCreateListeners(wedding, new Object[0]);
            }
            return Sequence.SeqResult.SeqCompleted;
        }
        return Sequence.SeqResult.SeqCancelled;
    }

    private void setWedPerson(DomPerson person) {
        if (person.getSex() == 0) {
            this.dlgWeddingEdit.getView().setGroomId(person.getId());
        } else {
            this.dlgWeddingEdit.getView().setBrideId(person.getId());
        }
    }

    private void setWedPersons() {
        if (this.getSelectedPersonsCount() == 0 || this.getSelectedPersonsCount() > 2) {
            return;
        }
        this.dlgWeddingEdit.create();
        try {
            DomPerson person1 = MPersonSwt.instance().getFromAll(this.getSelectedPersonId(0));
            if (this.getSelectedPersonsCount() == 1) {
                this.setWedPerson(person1);
                return;
            }
            DomPerson person2 = MPersonSwt.instance().getFromAll(this.getSelectedPersonId(1));
            if (person1.getSex().equals(person2.getSex())) {
                return;
            }
            this.setWedPerson(person1);
            this.setWedPerson(person2);
        }
        catch (SQLException ex) {
            SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Load"), new Object[0]);
        }
        catch (ObjectNotFound ex) {
            SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("PersonNotFound"), new Object[0]);
        }
    }
}

