/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.dao.MPersonAddress;
import eelk.koguja.dlg.DlgSetValidityPeriodAddress;
import eelk.koguja.dlg.DlgValidityAddress;
import eelk.koguja.model.DomPerson;
import eelk.koguja.seq.SeqManageAddress;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Operation;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class SeqModifyAddressValidity
extends SeqManageAddress {
    public static final Logger logger = Logger.getLogger(SeqModifyAddressValidity.class);
    private Date validFrom;
    private Date validTo;
    private boolean saveSucceeded;
    private DlgValidityAddress dlgValidityAddress;
    private DlgSetValidityPeriodAddress dlgValidityPeriod;

    public SeqModifyAddressValidity(Shell parent) {
        super(parent);
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(Date value) {
        this.validFrom = value;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    public void setValidTo(Date value) {
        this.validTo = value;
    }

    @Override
    protected Sequence.SeqResult exec() {
        if (this.dlgValidityAddress == null) {
            this.dlgValidityAddress = new DlgValidityAddress(this.modalParent.getShell());
        }
        this.dlgValidityAddress.setAddressText(this.getAddress().toString());
        List<DomPerson> lstPersonsOnAddress = this.getPersonsUsingAddress();
        this.dlgValidityAddress.setPersons(lstPersonsOnAddress);
        if (lstPersonsOnAddress.size() > 1) {
            if (this.dlgValidityAddress.open() != 0) {
                return Sequence.SeqResult.SeqCancelled;
            }
            this.setGlobal(this.dlgValidityAddress.validateAll());
        } else {
            this.setGlobal(false);
        }
        if (this.dlgValidityPeriod == null) {
            this.dlgValidityPeriod = new DlgSetValidityPeriodAddress(this.modalParent.getShell());
        }
        this.dlgValidityPeriod.create();
        this.dlgValidityPeriod.getView().setValidFrom(this.getValidFrom());
        this.dlgValidityPeriod.getView().setValidTo(this.getValidTo());
        this.dlgValidityPeriod.getView().refresh();
        if (this.dlgValidityPeriod.open() != 0) {
            return Sequence.SeqResult.SeqCancelled;
        }
        this.setValidFrom(this.dlgValidityPeriod.getView().getValidFrom());
        this.setValidTo(this.dlgValidityPeriod.getView().getValidTo());
        if (this.isGlobal() && !this.save()) {
            return Sequence.SeqResult.SeqFailed;
        }
        return Sequence.SeqResult.SeqCompleted;
    }

    private boolean save() {
        this.saveSucceeded = true;
        Operation.run(this.parent, true, new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor p) throws InvocationTargetException, InterruptedException {
                try {
                    p.beginTask(Resources.getMsgString("Save.Saving"), -1);
                    Date from = SeqModifyAddressValidity.this.getValidFrom();
                    Date to = SeqModifyAddressValidity.this.getValidTo();
                    MPersonAddress.instance().modifyAll(SeqModifyAddressValidity.this.getAddress().getId(), from == null ? null : new java.sql.Date(from.getTime()), to == null ? null : new java.sql.Date(to.getTime()));
                    p.done();
                }
                catch (SQLException ex) {
                    p.done();
                    SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Save"), new Object[0]);
                    SeqModifyAddressValidity.this.saveSucceeded = false;
                }
            }
        });
        return this.saveSucceeded;
    }
}

