/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.Session;
import eelk.koguja.dao.MBaptism;
import eelk.koguja.dao.MConfirmation;
import eelk.koguja.dao.MDonation;
import eelk.koguja.dao.MFuneral;
import eelk.koguja.dao.MPerson;
import eelk.koguja.dao.MPersonAddress;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.dao.MRelationship;
import eelk.koguja.dao.MWedding;
import eelk.koguja.events.BusinessObjectEventFactory;
import eelk.koguja.model.DomBaptism;
import eelk.koguja.model.DomConfirmation;
import eelk.koguja.model.DomDonation;
import eelk.koguja.model.DomDonationWithTypeName;
import eelk.koguja.model.DomFuneral;
import eelk.koguja.model.DomPerson;
import eelk.koguja.model.DomPersonAddress;
import eelk.koguja.model.DomRelationship;
import eelk.koguja.model.DomWedding;
import eelk.koguja.model.ObjectNotFound;
import eelk.koguja.search.Result;
import eelk.koguja.seq.SeqDelete;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.DbUtil;
import eelk.koguja.util.GuiUtil;
import eelk.koguja.util.IDbUtil;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Shell;

public class SeqMergePersons
extends SeqDelete {
    public static final Logger logger = Logger.getLogger(SeqMergePersons.class);

    public SeqMergePersons(Shell parent) {
        super(parent);
    }

    @Override
    protected Sequence.SeqResult exec() {
        List<Result> results = this.getObjects();
        for (Result r : results) {
            if (DbUtil.checkUserPerson(IDbUtil.Permission.Delete, r.getId(), GuiUtil.activeShell())) continue;
            return Sequence.SeqResult.SeqFailed;
        }
        if (results.size() != 2) {
            GuiUtil.informationDialog(this.parent, "Msg.PersonResult.NonDualSel", new Object[0]);
            return Sequence.SeqResult.SeqFailed;
        }
        if (!GuiUtil.confirmationDialog(this.parent, "Msg.PersonResult.MergeSelected")) {
            return Sequence.SeqResult.SeqCancelled;
        }
        int personId1 = results.get(0).getId();
        int personId2 = results.get(1).getId();
        try {
            DomPerson person1 = MPersonSwt.instance().get(personId1);
            DomPerson person2 = MPersonSwt.instance().get(personId2);
            if (person1.getMaidenName() == null && person2.getMaidenName() != null) {
                person1.setMaidenName(person2.getMaidenName());
            }
            if (person1.getCode() == null && person2.getCode() != null) {
                person1.setCode(person2.getCode());
            }
            if (person1.getMaritalStatus() == null && person2.getMaritalStatus() != null) {
                person1.setMaritalStatus(person2.getMaritalStatus());
            }
            if (person1.getBirthPlace() == null && person2.getBirthPlace() != null) {
                person1.setBirthPlace(person2.getBirthPlace());
            }
            if (person1.getBirthDate() == null && person2.getBirthDate() != null) {
                person1.setBirthDate(person2.getBirthDate());
            }
            if (person1.getBirthDateFuzzyEnd() == null && person2.getBirthDateFuzzyEnd() != null) {
                person1.setBirthDateFuzzyEnd(person2.getBirthDateFuzzyEnd());
            }
            if (person1.getDeathDate() == null && person2.getDeathDate() != null) {
                person1.setDeathDate(person2.getDeathDate());
            }
            if (person1.getDeathDateFuzzyEnd() == null && person2.getDeathDateFuzzyEnd() != null) {
                person1.setDeathDateFuzzyEnd(person2.getDeathDateFuzzyEnd());
            }
            if (person1.getMembercard() == null && person2.getMembercard() != null) {
                person1.setMembercard(person2.getMembercard());
            }
            if (person1.getProfession() == null && person2.getProfession() != null) {
                person1.setProfession(person2.getProfession());
            }
            if (person1.getEmail() == null && person2.getEmail() != null) {
                person1.setEmail(person2.getEmail());
            }
            if (person1.getLink() == null && person2.getLink() != null) {
                person1.setLink(person2.getLink());
            }
            if (person1.getPhone() == null && person2.getPhone() != null) {
                person1.setPhone(person2.getPhone());
            }
            if (person1.getNationalityId() != person2.getNationalityId()) {
                person1.setNationalityId(person2.getNationalityId());
            }
            if (person1.getReligionId() != person2.getReligionId()) {
                person1.setReligionId(person2.getReligionId());
            }
            if (person1.getComment() == null && person2.getComment() != null) {
                person1.setComment(person2.getComment());
            } else if (person2.getComment() != null && !person1.getComment().equals(person2.getComment())) {
                person1.setComment(person1.getComment() + "\n--liidetud--\n" + person2.getComment());
            }
            if (person1.getBook() == null && person2.getBook() != null) {
                person1.setBook(person2.getBook());
            }
            if (person1.getPage() == null && person2.getPage() != null) {
                person1.setPage(person2.getPage());
            }
            DomBaptism b1 = MBaptism.getBaptismForPerson(personId1);
            DomBaptism b2 = MBaptism.getBaptismForPerson(personId2);
            if (b1 == null && b2 != null) {
                b2.setPersonId(personId1);
                MBaptism.instance().modify(b2);
            }
            DomConfirmation c1 = MConfirmation.getConfirmationForPerson(personId1);
            DomConfirmation c2 = MConfirmation.getConfirmationForPerson(personId2);
            if (c1 == null && c2 != null) {
                c2.setPersonId(personId1);
                MConfirmation.instance().modify(c2);
            }
            DomWedding w1 = MWedding.getWeddingForPerson(personId1);
            DomWedding w2 = MWedding.getWeddingForPerson(personId2);
            if (w1 == null && w2 != null && person1.getSex().equals(person2.getSex())) {
                if (person1.getSex() == 0) {
                    w2.setGroomId(personId1);
                } else {
                    w2.setBrideId(personId1);
                }
                MWedding.instance().modify(w2);
            }
            DomFuneral f1 = MFuneral.getFuneralForPerson(personId1);
            DomFuneral f2 = MFuneral.getFuneralForPerson(personId2);
            if (f1 == null && f2 != null) {
                f2.setPersonId(personId1);
                MFuneral.instance().modify(f2);
            }
            List<DomDonationWithTypeName> donations1 = MDonation.listMyDonations(personId1);
            List<DomDonationWithTypeName> donations2 = MDonation.listMyDonations(personId2);
            for (DomDonationWithTypeName donation2 : donations2) {
                if (donations1.contains(donation2)) continue;
                DomDonation d2 = MDonation.instance().get(donation2.getId());
                d2.setPersonId(personId1);
                MDonation.instance().modify(d2);
            }
            List<DomRelationship> rels1 = MRelationship.listMyRelationships(personId1);
            List<DomRelationship> rels2 = MRelationship.listMyRelationships(personId2);
            for (DomRelationship rel2 : rels2) {
                boolean modify = false;
                Integer p1 = null;
                Integer p2 = null;
                if (rel2.getPerson1Id() == personId2 && rel2.getPerson2Id() != personId1) {
                    p1 = rel2.getPerson1Id();
                    p2 = rel2.getPerson2Id();
                    rel2.setPerson1Id(personId1);
                    modify = true;
                } else if (rel2.getPerson2Id() == personId2 && rel2.getPerson1Id() != personId1) {
                    p1 = rel2.getPerson2Id();
                    p2 = rel2.getPerson1Id();
                    rel2.setPerson2Id(personId1);
                    modify = true;
                }
                if (!modify) continue;
                for (DomRelationship rel1 : rels1) {
                    if ((rel1.getPerson1Id() != rel2.getPerson1Id() || rel1.getPerson2Id() != rel2.getPerson2Id()) && (rel1.getPerson1Id() != rel2.getPerson2Id() || rel1.getPerson2Id() != rel2.getPerson1Id()) || rel1.getTypeId() != rel2.getTypeId()) continue;
                    modify = false;
                }
                if (modify) {
                    MRelationship.instance().set(rel2);
                }
                if (p2.equals(rel2.getPerson2Id())) {
                    MRelationship.instance().end(p1, p2);
                    continue;
                }
                MRelationship.instance().end(p2, p1);
            }
            List<DomPersonAddress> addr = MPerson.getPersonAddresses(personId2);
            if (addr.size() > 0) {
                MPersonAddress.instance().changePerson(personId2, personId1);
            }
            MPerson.instance().alterPersonCongregations(personId2, personId1);
            MPersonSwt.instance().delete(personId2);
            MPersonSwt.instance().modify(person1);
            Connection conn = Session.connection();
            if (conn != null) {
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Session.rollback();
            SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("Delete"), new Object[0]);
            return Sequence.SeqResult.SeqFailed;
        }
        catch (ObjectNotFound ex) {
            Session.rollback();
            SwtExceptionHandler.instance().Ex(ex, logger, Resources.getErrString("ObjectNotFound"), new Object[0]);
            return Sequence.SeqResult.SeqFailed;
        }
        this.notifyDeletedListeners();
        return Sequence.SeqResult.SeqCompleted;
    }

    @Override
    protected void notifyDeletedListeners() {
        for (Result r : this.getObjects()) {
            DomPerson p = new DomPerson();
            p.setId(r.getId());
            BusinessObjectEventFactory.notifyDeleteListeners(p);
        }
    }
}

