/*
 * Decompiled with CFR 0.152.
 */
package eelk.koguja.seq;

import eelk.koguja.dao.MAddress;
import eelk.koguja.dao.MPersonSwt;
import eelk.koguja.model.DomAddress;
import eelk.koguja.model.DomPerson;
import eelk.koguja.seq.Sequence;
import eelk.koguja.util.Resources;
import eelk.koguja.util.SwtExceptionHandler;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Shell;

public abstract class SeqManageAddress
extends Sequence {
    public static final Logger logger = Logger.getLogger(SeqManageAddress.class);
    private DomAddress address;
    private Integer personId;
    private boolean isGlobal = false;

    public SeqManageAddress(Shell parent) {
        super(parent);
    }

    public DomAddress getAddress() {
        return this.address;
    }

    public void setAddress(DomAddress value) {
        this.address = value;
    }

    @Deprecated
    protected int getAddressUsedCount() {
        try {
            return MAddress.instance().getAddressUsedCount(this.getAddress().getId());
        }
        catch (SQLException ex) {
            SwtExceptionHandler.instance().Ex(ex, logger, Resources.getString("Load"), new Object[0]);
            return 0;
        }
    }

    protected List<DomPerson> getPersonsUsingAddress() {
        try {
            return MPersonSwt.listPublicPersonsWithAddress(this.getAddress().getId());
        }
        catch (SQLException ex) {
            SwtExceptionHandler.instance().Ex(ex, logger, Resources.getString("Load"), new Object[0]);
            return null;
        }
    }

    public Integer getPersonId() {
        return this.personId;
    }

    public void setPersonId(Integer value) {
        this.personId = value;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    protected void setGlobal(boolean value) {
        this.isGlobal = value;
    }
}

